
import java.io.*;
import java.awt.FileDialog;
import java.awt.Frame;

void setup() {
  WavFile baseFile = WavFile.readFromFilePath(sketchPath("test.wav"));
  float[][] waveForm = baseFile.samplesAsFloat();
  println(baseFile.samplingInfo.toString());
  float[][] newWaveForm = new float[waveForm.length][waveForm[0].length];
  float[] kernel = new float[10000];
  for (int i=0;i<kernel.length;i++) {
    float position = ((float)i-(float)kernel.length/2)/((float)kernel.length/2);
    kernel[i] = random(-2, 2)*pow(1-abs(position), 5);
  }
  int nbIterations=1;
  size(200, 150);
  background(0);
  stroke(0xFF);
  textSize(9);
  text("length : "+kernel.length, 5, 15);
  text("passes : "+nbIterations, 5, 25);
  for (int it=0;it<nbIterations;it++) {
    for (int i=0;i<kernel.length;i++) point((float)i*width/kernel.length, kernel[i]*10+(float)height/2);
    for (int c=0;c<waveForm.length;c++) {
      for (int s=0;s<waveForm[c].length;s++) {
        newWaveForm[c][s] = 0;
        for (int k=0;k<kernel.length;k++) {
          newWaveForm[c][s] += waveForm[c][(s+k-floor((float)kernel.length/2)+waveForm[c].length)%waveForm[c].length] * kernel[k];
        }
      }
    }
    float highest=0;
    for (int c=0;c<newWaveForm.length;c++) {
      for (int i=0;i<newWaveForm[c].length;i++) highest=max((float)highest, abs((float)newWaveForm[c][i]));
    }
    for (int c=0;c<newWaveForm.length;c++) {
      for (int i=0;i<newWaveForm[c].length;i++) newWaveForm[c][i]=newWaveForm[c][i]/highest;
    }
    for (int c=0;c<newWaveForm.length;c++) {
      for (int i=0;i<newWaveForm[c].length;i++) waveForm[c][i]=newWaveForm[c][i];
    }
  }
  baseFile.setSamplesFromFloat(newWaveForm);
  baseFile.writeToFilePath(sketchPath("result.wav"));
  save("kernelPic.png");
}

void draw() {
}

