/*
 * Decompiled with CFR 0.152.
 */
class SamplingInfo {
    public String name;
    public int chunkSize;
    public short formatCode;
    public short numberOfChannels;
    public int samplesPerSecond;
    public short bitsPerSample;

    public SamplingInfo(String string, int n, short s, short s2, int n2, short s3) {
        this.name = string;
        this.chunkSize = n;
        this.formatCode = s;
        this.numberOfChannels = s2;
        this.samplesPerSecond = n2;
        this.bitsPerSample = s3;
    }

    public int bytesPerSecond() {
        return this.samplesPerSecond * this.numberOfChannels * this.bitsPerSample / 8;
    }

    public Sample samplePrototype() {
        Sample sample = null;
        if (this.bitsPerSample == 16) {
            sample = new Sample16(0);
        } else if (this.bitsPerSample == 24) {
            sample = new Sample24(0);
        } else if (this.bitsPerSample == 32) {
            sample = new Sample32(0);
        }
        return sample;
    }

    public String toString() {
        String string = "<SamplingInfo chunkSize='" + this.chunkSize + "' " + "formatCode='" + this.formatCode + "' " + "numberOfChannels='" + this.numberOfChannels + "' " + "samplesPerSecond='" + this.samplesPerSecond + "' " + "bitsPerSample='" + this.bitsPerSample + "' " + "/>";
        return string;
    }

    public static class Instances {
        public static SamplingInfo Default = new SamplingInfo("Default", 16, 1, 1, 44100, 16);
    }
}

