/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.util;

import com.jogamp.common.nio.Buffers;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import javax.media.opengl.GL;
import javax.media.opengl.GLException;

public class GLBuffers
extends Buffers {
    public static final boolean isSignedGLType(int n) {
        switch (n) {
            case 5121: 
            case 5123: 
            case 5125: 
            case 34552: {
                return false;
            }
        }
        return true;
    }

    public static final boolean isGLTypeFixedPoint(int n) {
        switch (n) {
            case 5126: 
            case 5130: 
            case 5131: 
            case 36193: {
                return false;
            }
        }
        return true;
    }

    public static final int sizeOfGLType(int n) {
        switch (n) {
            case 5120: 
            case 5121: 
            case 32818: 
            case 33634: {
                return 1;
            }
            case 5122: 
            case 5123: 
            case 5131: 
            case 32819: 
            case 32820: 
            case 33635: 
            case 33636: 
            case 33637: 
            case 33638: 
            case 36193: {
                return 2;
            }
            case 5124: 
            case 5125: 
            case 5132: 
            case 32821: 
            case 33639: 
            case 33640: 
            case 34042: 
            case 34552: 
            case 34554: 
            case 35899: 
            case 35902: 
            case 36342: {
                return 4;
            }
            case 36269: {
                return 8;
            }
            case 5126: {
                return 4;
            }
            case 5130: {
                return 8;
            }
        }
        return -1;
    }

    public static final Buffer newDirectGLBuffer(int n, int n2) {
        switch (n) {
            case 5120: 
            case 5121: 
            case 32818: 
            case 33634: {
                return GLBuffers.newDirectByteBuffer((int)n2);
            }
            case 5122: 
            case 5123: 
            case 5131: 
            case 32819: 
            case 32820: 
            case 33635: 
            case 33636: 
            case 33637: 
            case 33638: 
            case 36193: {
                return GLBuffers.newDirectShortBuffer((int)n2);
            }
            case 5124: 
            case 5125: 
            case 5132: 
            case 32821: 
            case 33639: 
            case 33640: 
            case 34042: 
            case 34552: 
            case 34554: 
            case 35899: 
            case 35902: 
            case 36342: {
                return GLBuffers.newDirectIntBuffer((int)n2);
            }
            case 36269: {
                return GLBuffers.newDirectLongBuffer((int)n2);
            }
            case 5126: {
                return GLBuffers.newDirectFloatBuffer((int)n2);
            }
            case 5130: {
                return GLBuffers.newDirectDoubleBuffer((int)n2);
            }
        }
        return null;
    }

    public static final Buffer sliceGLBuffer(ByteBuffer byteBuffer, int n, int n2, int n3) {
        if (byteBuffer == null || n2 == 0) {
            return null;
        }
        int n4 = byteBuffer.position();
        int n5 = byteBuffer.limit();
        byteBuffer.position(n);
        byteBuffer.limit(n + n2);
        Buffer buffer = null;
        switch (n3) {
            case 5120: 
            case 5121: 
            case 32818: 
            case 33634: {
                buffer = byteBuffer.slice().order(byteBuffer.order());
                break;
            }
            case 5122: 
            case 5123: 
            case 5131: 
            case 32819: 
            case 32820: 
            case 33635: 
            case 33636: 
            case 33637: 
            case 33638: 
            case 36193: {
                buffer = byteBuffer.slice().order(byteBuffer.order()).asShortBuffer();
                break;
            }
            case 5124: 
            case 5125: 
            case 5132: 
            case 32821: 
            case 33639: 
            case 33640: 
            case 34042: 
            case 34552: 
            case 34554: 
            case 35899: 
            case 35902: 
            case 36342: {
                buffer = byteBuffer.slice().order(byteBuffer.order()).asIntBuffer();
                break;
            }
            case 36269: {
                buffer = byteBuffer.slice().order(byteBuffer.order()).asLongBuffer();
                break;
            }
            case 5126: {
                buffer = byteBuffer.slice().order(byteBuffer.order()).asFloatBuffer();
                break;
            }
            case 5130: {
                buffer = byteBuffer.slice().order(byteBuffer.order()).asDoubleBuffer();
            }
        }
        byteBuffer.position(n4).limit(n5);
        return buffer;
    }

    private static final int glGetInteger(GL gL, int n, int[] nArray) {
        gL.glGetIntegerv(n, nArray, 0);
        return nArray[0];
    }

    public static final int sizeof(GL gL, int[] nArray, int n, int n2, int n3, int n4, boolean bl) {
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 1;
        int n9 = 0;
        int n10 = 0;
        if (bl) {
            n8 = GLBuffers.glGetInteger(gL, 3333, nArray);
            if (gL.isGL2GL3()) {
                n5 = GLBuffers.glGetInteger(gL, 3330, nArray);
                n6 = GLBuffers.glGetInteger(gL, 3331, nArray);
                n7 = GLBuffers.glGetInteger(gL, 3332, nArray);
                if (n4 > 1) {
                    n9 = GLBuffers.glGetInteger(gL, 32876, nArray);
                    n10 = GLBuffers.glGetInteger(gL, 32875, nArray);
                }
            }
        } else {
            n8 = GLBuffers.glGetInteger(gL, 3317, nArray);
            if (gL.isGL2GL3()) {
                n5 = GLBuffers.glGetInteger(gL, 3314, nArray);
                n6 = GLBuffers.glGetInteger(gL, 3315, nArray);
                n7 = GLBuffers.glGetInteger(gL, 3316, nArray);
                if (n4 > 1) {
                    n9 = GLBuffers.glGetInteger(gL, 32878, nArray);
                    n10 = GLBuffers.glGetInteger(gL, 32877, nArray);
                }
            }
        }
        n2 = Math.max(0, n2);
        n3 = Math.max(1, n3);
        n4 = Math.max(1, n4);
        n6 = Math.max(0, n6);
        n7 = Math.max(0, n7);
        n8 = Math.max(1, n8);
        n10 = Math.max(0, n10);
        n9 = n9 > 0 ? n9 : n3;
        n5 = n5 > 0 ? n5 : n2;
        int n11 = n5 * n;
        int n12 = n7 * n;
        switch (n8) {
            case 1: {
                break;
            }
            case 2: 
            case 4: 
            case 8: {
                int n13 = n11 & n8 - 1;
                if (n13 > 0) {
                    n11 += n8 - n13;
                }
                if ((n13 = n12 & n8 - 1) <= 0) break;
                n12 += n8 - n13;
                break;
            }
            default: {
                throw new GLException("Invalid alignment " + n8 + ", must be 2**n (1,2,4,8). Pls notify the maintainer in case this is our bug.");
            }
        }
        return n12 + (n10 + n4 - 1) * n9 * n11 + (n6 + n3 - 1) * n11 + n2 * n;
    }

    public static final int sizeof(GL gL, int[] nArray, int n, int n2, int n3, int n4, int n5, boolean bl) throws GLException {
        if (n3 < 0) {
            return 0;
        }
        if (n4 < 0) {
            return 0;
        }
        if (n5 < 0) {
            return 0;
        }
        int n6 = GLBuffers.bytesPerPixel(n, n2);
        return GLBuffers.sizeof(gL, nArray, n6, n3, n4, n5, bl);
    }

    public static final int bytesPerPixel(int n, int n2) throws GLException {
        int n3 = 0;
        int n4 = GLBuffers.componentCount(n);
        switch (n2) {
            case 6656: {
                if (6400 == n || 6401 == n) {
                    n3 = 1;
                }
            }
            case 5120: 
            case 5121: {
                n3 = 1;
                break;
            }
            case 5122: 
            case 5123: 
            case 5131: 
            case 36193: {
                n3 = 2;
                break;
            }
            case 5124: 
            case 5125: 
            case 5126: 
            case 5132: {
                n3 = 4;
                break;
            }
            case 5130: {
                n3 = 8;
                break;
            }
            case 32818: 
            case 33634: {
                n3 = 1;
                n4 = 1;
                break;
            }
            case 32819: 
            case 32820: 
            case 33635: 
            case 33636: 
            case 33637: 
            case 33638: {
                n3 = 2;
                n4 = 1;
                break;
            }
            case 34552: 
            case 34554: {
                n3 = 2;
                n4 = 2;
                break;
            }
            case 32821: 
            case 33639: 
            case 33640: 
            case 34042: 
            case 35899: 
            case 35902: 
            case 36342: {
                n3 = 4;
                n4 = 1;
                break;
            }
            case 36269: {
                n3 = 8;
                n4 = 1;
                break;
            }
            default: {
                throw new GLException("type 0x" + Integer.toHexString(n2) + "/" + "format 0x" + Integer.toHexString(n) + " not supported [yet], pls notify the maintainer in case this is our bug.");
            }
        }
        return n4 * n3;
    }

    public static final int componentCount(int n) throws GLException {
        int n2;
        switch (n) {
            case 6400: 
            case 6401: 
            case 6402: 
            case 6403: 
            case 6404: 
            case 6405: 
            case 6406: 
            case 6409: 
            case 34041: 
            case 36244: 
            case 36245: 
            case 36246: {
                n2 = 1;
                break;
            }
            case 6410: 
            case 33319: 
            case 33320: 
            case 34548: 
            case 34553: {
                n2 = 2;
                break;
            }
            case 6407: 
            case 32992: 
            case 36248: 
            case 36250: {
                n2 = 3;
                break;
            }
            case 6408: 
            case 32768: 
            case 32993: 
            case 36249: 
            case 36251: {
                n2 = 4;
                break;
            }
            default: {
                throw new GLException("format 0x" + Integer.toHexString(n) + " not supported [yet], pls notify the maintainer in case this is our bug.");
            }
        }
        return n2;
    }

    public static final int getNextPowerOf2(int n) {
        if ((n - 1 & n) == 0) {
            return n;
        }
        int n2 = 0;
        while (n > 0) {
            n >>= 1;
            ++n2;
        }
        return 1 << n2;
    }

    public static final float[] getFloatArray(double[] dArray) {
        int n = dArray.length;
        float[] fArray = new float[n--];
        while (n >= 0) {
            fArray[n] = (float)dArray[n];
            --n;
        }
        return fArray;
    }
}

