/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.egl;

import com.jogamp.common.nio.Buffers;
import com.jogamp.common.nio.PointerBuffer;
import com.jogamp.common.os.DynamicLookupHelper;
import com.jogamp.common.os.Platform;
import com.jogamp.common.util.ReflectionUtil;
import com.jogamp.nativewindow.egl.EGLGraphicsDevice;
import com.jogamp.opengl.GLRendererQuirks;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.media.nativewindow.AbstractGraphicsConfiguration;
import javax.media.nativewindow.AbstractGraphicsDevice;
import javax.media.nativewindow.AbstractGraphicsScreen;
import javax.media.nativewindow.DefaultGraphicsScreen;
import javax.media.nativewindow.MutableSurface;
import javax.media.nativewindow.NativeSurface;
import javax.media.nativewindow.NativeWindowFactory;
import javax.media.nativewindow.ProxySurface;
import javax.media.nativewindow.UpstreamSurfaceHook;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesChooser;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawable;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLException;
import javax.media.opengl.GLProfile;
import jogamp.nativewindow.WrappedSurface;
import jogamp.nativewindow.x11.X11Util;
import jogamp.opengl.Debug;
import jogamp.opengl.GLContextImpl;
import jogamp.opengl.GLDrawableFactoryImpl;
import jogamp.opengl.GLDrawableImpl;
import jogamp.opengl.GLDynamicLookupHelper;
import jogamp.opengl.GLGraphicsConfigurationUtil;
import jogamp.opengl.SharedResourceRunner;
import jogamp.opengl.egl.EGL;
import jogamp.opengl.egl.EGLContext;
import jogamp.opengl.egl.EGLDisplayUtil;
import jogamp.opengl.egl.EGLDrawable;
import jogamp.opengl.egl.EGLDummyUpstreamSurfaceHook;
import jogamp.opengl.egl.EGLES1DynamicLibraryBundleInfo;
import jogamp.opengl.egl.EGLES2DynamicLibraryBundleInfo;
import jogamp.opengl.egl.EGLExternalContext;
import jogamp.opengl.egl.EGLGraphicsConfiguration;
import jogamp.opengl.egl.EGLGraphicsConfigurationFactory;
import jogamp.opengl.egl.EGLOnscreenDrawable;
import jogamp.opengl.egl.EGLPbufferDrawable;
import jogamp.opengl.egl.EGLWrappedSurface;

public class EGLDrawableFactory
extends GLDrawableFactoryImpl {
    protected static final boolean DEBUG = GLDrawableFactoryImpl.DEBUG;
    static final boolean QUERY_EGL_ES_NATIVE_TK = Debug.isPropertyDefined("jogl.debug.EGLDrawableFactory.QueryNativeTK", true);
    private static GLDynamicLookupHelper eglES1DynamicLookupHelper = null;
    private static GLDynamicLookupHelper eglES2DynamicLookupHelper = null;
    private HashMap<String, SharedResource> sharedMap = null;
    private HashSet<String> sharedMapCreateAttempt = null;
    private EGLGraphicsDevice defaultDevice = null;
    private SharedResource defaultSharedResource = null;
    private boolean isANGLE = false;
    private boolean hasX11 = false;

    private static final boolean isANGLE(GLDynamicLookupHelper gLDynamicLookupHelper) {
        if (Platform.OSType.WINDOWS == Platform.OS_TYPE) {
            boolean bl = 0L != gLDynamicLookupHelper.dynamicLookupFunction("eglQuerySurfacePointerANGLE") || 0L != gLDynamicLookupHelper.dynamicLookupFunction("glBlitFramebufferANGLE") || 0L != gLDynamicLookupHelper.dynamicLookupFunction("glRenderbufferStorageMultisampleANGLE");
            return bl;
        }
        return false;
    }

    private static final boolean includesES1(GLDynamicLookupHelper gLDynamicLookupHelper) {
        return 0L != gLDynamicLookupHelper.dynamicLookupFunction("glLoadIdentity") && 0L != gLDynamicLookupHelper.dynamicLookupFunction("glEnableClientState") && 0L != gLDynamicLookupHelper.dynamicLookupFunction("glColorPointer");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EGLDrawableFactory() {
        EGLGraphicsConfigurationFactory.registerFactory();
        if (NativeWindowFactory.TYPE_X11 == NativeWindowFactory.getNativeWindowType(true)) {
            this.hasX11 = true;
            try {
                ReflectionUtil.createInstance((String)"jogamp.opengl.x11.glx.X11GLXGraphicsConfigurationFactory", (ClassLoader)EGLDrawableFactory.class.getClassLoader());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Class<EGLDrawableFactory> clazz = EGLDrawableFactory.class;
        synchronized (EGLDrawableFactory.class) {
            GLDynamicLookupHelper gLDynamicLookupHelper;
            boolean bl;
            boolean bl2 = bl = null != eglES2DynamicLookupHelper;
            if (!bl && null == eglES1DynamicLookupHelper) {
                block27: {
                    gLDynamicLookupHelper = null;
                    try {
                        gLDynamicLookupHelper = new GLDynamicLookupHelper(new EGLES1DynamicLibraryBundleInfo());
                    }
                    catch (GLException gLException) {
                        if (!DEBUG) break block27;
                        gLException.printStackTrace();
                    }
                }
                if (null != gLDynamicLookupHelper && gLDynamicLookupHelper.isLibComplete()) {
                    eglES1DynamicLookupHelper = gLDynamicLookupHelper;
                    EGL.resetProcAddressTable((DynamicLookupHelper)eglES1DynamicLookupHelper);
                    boolean bl3 = EGLDrawableFactory.isANGLE(eglES1DynamicLookupHelper);
                    this.isANGLE |= bl3;
                    if (DEBUG || GLProfile.DEBUG) {
                        System.err.println("Info: EGLDrawableFactory: EGL ES1 - OK, isANGLE: " + bl3);
                    }
                } else if (DEBUG || GLProfile.DEBUG) {
                    System.err.println("Info: EGLDrawableFactory: EGL ES1 - NOPE (ES1 lib)");
                }
            }
            if (!bl && null == eglES2DynamicLookupHelper) {
                block28: {
                    gLDynamicLookupHelper = null;
                    try {
                        gLDynamicLookupHelper = new GLDynamicLookupHelper(new EGLES2DynamicLibraryBundleInfo());
                    }
                    catch (GLException gLException) {
                        if (!DEBUG) break block28;
                        gLException.printStackTrace();
                    }
                }
                if (null != gLDynamicLookupHelper && gLDynamicLookupHelper.isLibComplete()) {
                    boolean bl4;
                    eglES2DynamicLookupHelper = gLDynamicLookupHelper;
                    EGL.resetProcAddressTable((DynamicLookupHelper)eglES2DynamicLookupHelper);
                    boolean bl5 = bl4 = null == eglES1DynamicLookupHelper && EGLDrawableFactory.includesES1(eglES2DynamicLookupHelper);
                    if (bl4) {
                        eglES1DynamicLookupHelper = gLDynamicLookupHelper;
                    }
                    boolean bl6 = EGLDrawableFactory.isANGLE(eglES2DynamicLookupHelper);
                    this.isANGLE |= bl6;
                    if (DEBUG || GLProfile.DEBUG) {
                        System.err.println("Info: EGLDrawableFactory: EGL ES2 - OK (includesES1 " + bl4 + ", isANGLE: " + bl6 + ")");
                        if (bl4) {
                            System.err.println("Info: EGLDrawableFactory: EGL ES1 - OK (ES2 lib)");
                        }
                    }
                } else if (DEBUG || GLProfile.DEBUG) {
                    System.err.println("Info: EGLDrawableFactory: EGL ES2 - NOPE");
                }
            }
            if (null != eglES2DynamicLookupHelper || null != eglES1DynamicLookupHelper) {
                if (this.isANGLE && !enableANGLE) {
                    if (DEBUG || GLProfile.DEBUG) {
                        System.err.println("Info: EGLDrawableFactory.init - EGL/ES2 ANGLE disabled");
                    }
                } else {
                    if (this.isANGLE && (DEBUG || GLProfile.DEBUG)) {
                        System.err.println("Info: EGLDrawableFactory.init - EGL/ES2 ANGLE enabled");
                    }
                    this.sharedMap = new HashMap();
                    this.sharedMapCreateAttempt = new HashSet();
                    this.defaultDevice = EGLDisplayUtil.eglCreateEGLGraphicsDevice(0L, "decon", 0);
                }
            }
            // ** MonitorExit[var1_2] (shouldn't be in output)
            return;
        }
    }

    @Override
    protected final boolean isComplete() {
        return null != this.sharedMap;
    }

    @Override
    protected final void destroy() {
        if (null != this.sharedMap) {
            if (DEBUG) {
                System.err.println("EGLDrawableFactory.destroy() .. ");
                this.dumpMap();
            }
            Collection<SharedResource> collection = this.sharedMap.values();
            for (SharedResource sharedResource : collection) {
                if (DEBUG) {
                    System.err.println("EGLDrawableFactory.destroy(): " + sharedResource.device.toString());
                }
                sharedResource.device.close();
            }
            this.sharedMap.clear();
            this.sharedMapCreateAttempt.clear();
            this.sharedMap = null;
            this.sharedMapCreateAttempt = null;
        }
        if (null != this.defaultSharedResource) {
            this.defaultSharedResource = null;
        }
        if (null != this.defaultDevice) {
            this.defaultDevice.close();
            this.defaultDevice = null;
        }
        if (null != eglES1DynamicLookupHelper) {
            eglES1DynamicLookupHelper = null;
        }
        if (null != eglES2DynamicLookupHelper) {
            eglES2DynamicLookupHelper = null;
        }
        EGLGraphicsConfigurationFactory.unregisterFactory();
        EGLDisplayUtil.shutdown(DEBUG);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpMap() {
        HashMap<String, SharedResource> hashMap = this.sharedMap;
        synchronized (hashMap) {
            System.err.println("EGLDrawableFactory.map " + this.sharedMap.size());
            int n = 0;
            Set<String> set = this.sharedMap.keySet();
            for (String string : set) {
                SharedResource sharedResource = this.sharedMap.get(string);
                System.err.println("EGLDrawableFactory.map[" + n + "] " + string + " -> " + sharedResource.getDevice() + ", " + "es1 [avail " + sharedResource.wasES1ContextCreated + ", pbuffer " + sharedResource.hasPBufferES1 + ", quirks " + sharedResource.rendererQuirksES1 + ", ctp " + EGLContext.getGLVersion(1, 0, sharedResource.ctpES1, null) + "], " + "es2 [avail " + sharedResource.wasES2ContextCreated + ", pbuffer " + sharedResource.hasPBufferES2 + ", quirks " + sharedResource.rendererQuirksES2 + ", ctp " + EGLContext.getGLVersion(2, 0, sharedResource.ctpES2, null) + "]");
                ++n;
            }
        }
    }

    @Override
    public final AbstractGraphicsDevice getDefaultDevice() {
        return this.defaultDevice;
    }

    @Override
    public final boolean getIsDeviceCompatible(AbstractGraphicsDevice abstractGraphicsDevice) {
        return null != this.sharedMap;
    }

    private static List<GLCapabilitiesImmutable> getAvailableEGLConfigs(EGLGraphicsDevice eGLGraphicsDevice, GLCapabilitiesImmutable gLCapabilitiesImmutable) {
        IntBuffer intBuffer = Buffers.newDirectIntBuffer((int)1);
        if (!EGL.eglGetConfigs(eGLGraphicsDevice.getHandle(), null, 0, intBuffer)) {
            throw new GLException("EGLDrawableFactory.getAvailableEGLConfigs: Get maxConfigs (eglGetConfigs) call failed, error " + EGLContext.toHexString(EGL.eglGetError()));
        }
        if (0 < intBuffer.get(0)) {
            PointerBuffer pointerBuffer = PointerBuffer.allocateDirect((int)intBuffer.get(0));
            IntBuffer intBuffer2 = EGLGraphicsConfiguration.GLCapabilities2AttribList(gLCapabilitiesImmutable);
            int n = GLGraphicsConfigurationUtil.getExclusiveWinAttributeBits(gLCapabilitiesImmutable);
            if (EGL.eglChooseConfig(eGLGraphicsDevice.getHandle(), intBuffer2, pointerBuffer, pointerBuffer.capacity(), intBuffer) && intBuffer.get(0) > 0) {
                return EGLGraphicsConfigurationFactory.eglConfigs2GLCaps(eGLGraphicsDevice, gLCapabilitiesImmutable.getGLProfile(), pointerBuffer, intBuffer.get(0), n, false);
            }
        }
        return new ArrayList<GLCapabilitiesImmutable>(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean mapAvailableEGLESConfig(AbstractGraphicsDevice abstractGraphicsDevice, int n, boolean[] blArray, GLRendererQuirks[] gLRendererQuirksArray, int[] nArray) {
        boolean bl;
        block46: {
            String string;
            switch (n) {
                case 1: {
                    string = "GLES1";
                    break;
                }
                default: {
                    string = "GLES2";
                }
            }
            if (!GLProfile.isAvailable(abstractGraphicsDevice, string)) {
                return false;
            }
            GLProfile gLProfile = GLProfile.get(abstractGraphicsDevice, string);
            GLDrawableFactoryImpl gLDrawableFactoryImpl = (GLDrawableFactoryImpl)GLDrawableFactory.getDesktopFactory();
            boolean bl2 = !QUERY_EGL_ES_NATIVE_TK || null == gLDrawableFactoryImpl || abstractGraphicsDevice instanceof EGLGraphicsDevice;
            EGLGraphicsDevice eGLGraphicsDevice = null;
            ProxySurface proxySurface = null;
            ProxySurface proxySurface2 = null;
            bl = false;
            boolean bl3 = false;
            try {
                Object object;
                List<GLCapabilitiesImmutable> list;
                Object object2;
                GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
                gLCapabilities.setRedBits(5);
                gLCapabilities.setGreenBits(5);
                gLCapabilities.setBlueBits(5);
                gLCapabilities.setAlphaBits(0);
                gLCapabilities.setDoubleBuffered(false);
                if (bl2) {
                    object2 = GLGraphicsConfigurationUtil.fixGLPBufferGLCapabilities(gLCapabilities);
                    list = EGLDrawableFactory.getAvailableEGLConfigs(this.defaultDevice, (GLCapabilitiesImmutable)object2);
                    boolean bl4 = blArray[0] = list.size() > 0;
                    if (abstractGraphicsDevice != this.defaultDevice) {
                        if (null == this.defaultSharedResource) {
                            boolean bl5 = false;
                            return bl5;
                        }
                        switch (n) {
                            case 1: {
                                gLRendererQuirksArray[0] = this.defaultSharedResource.rendererQuirksES1;
                                nArray[0] = this.defaultSharedResource.ctpES1;
                                break;
                            }
                            case 2: {
                                gLRendererQuirksArray[0] = this.defaultSharedResource.rendererQuirksES2;
                                nArray[0] = this.defaultSharedResource.ctpES2;
                            }
                        }
                        EGLContext.mapStaticGLVersion(abstractGraphicsDevice, n, 0, nArray[0]);
                        boolean bl6 = true;
                        return bl6;
                    }
                    eGLGraphicsDevice = this.defaultDevice;
                    if (blArray[0]) {
                        proxySurface2 = proxySurface = this.createDummySurfaceImpl(eGLGraphicsDevice, false, (GLCapabilitiesImmutable)object2, (GLCapabilitiesImmutable)object2, null, 64, 64);
                        proxySurface2.createNotify();
                        bl3 = false;
                    } else {
                        object = EGLDrawableFactory.getAvailableEGLConfigs(eGLGraphicsDevice, gLCapabilities);
                        if (object.size() > 0) {
                            GLCapabilitiesImmutable gLCapabilitiesImmutable = object.get(0);
                            EGLContext.mapStaticGLESVersion((AbstractGraphicsDevice)eGLGraphicsDevice, gLCapabilitiesImmutable);
                            bl = true;
                        }
                        if (DEBUG) {
                            System.err.println("EGLDrawableFactory.isEGLContextAvailable() no pbuffer config available, detected !pbuffer config: " + bl);
                            EGLGraphicsConfigurationFactory.printCaps("!PBufferCaps", object, System.err);
                        }
                    }
                } else {
                    proxySurface = gLDrawableFactoryImpl.createDummySurface(abstractGraphicsDevice, gLCapabilities, null, 64, 64);
                    ProxySurface proxySurface3 = proxySurface2 = proxySurface instanceof ProxySurface ? proxySurface : null;
                    if (null != proxySurface2) {
                        proxySurface2.createNotify();
                    }
                    eGLGraphicsDevice = EGLDisplayUtil.eglCreateEGLGraphicsDevice(proxySurface);
                    bl3 = true;
                    blArray[0] = true;
                }
                if (null == proxySurface) break block46;
                object2 = (EGLDrawable)this.createOnscreenDrawableImpl(proxySurface);
                ((GLDrawableImpl)object2).setRealized(true);
                list = (EGLContext)((EGLDrawable)object2).createContext(null);
                if (null != list) {
                    try {
                        ((GLContextImpl)((Object)list)).makeCurrent();
                        if (((GLContext)((Object)list)).isCurrent()) {
                            object = ((GLContextImpl)((Object)list)).getGL().glGetString(7938);
                            if (null != object) {
                                ((EGLContext)((Object)list)).mapCurrentAvailableGLVersion(eGLGraphicsDevice);
                                if (eGLGraphicsDevice != abstractGraphicsDevice) {
                                    ((EGLContext)((Object)list)).mapCurrentAvailableGLVersion(abstractGraphicsDevice);
                                }
                                gLRendererQuirksArray[0] = ((GLContext)((Object)list)).getRendererQuirks();
                                nArray[0] = ((EGLContext)((Object)list)).getContextOptions();
                                bl = true;
                            } else if (DEBUG) {
                                System.err.println("EGLDrawableFactory.isEGLContextAvailable: " + eGLGraphicsDevice + ", " + ((GLContext)((Object)list)).getGLVersion() + " - VERSION is null, dropping availability!");
                            }
                        }
                    }
                    catch (GLException gLException) {
                        if (DEBUG) {
                            System.err.println("EGLDrawableFactory.createShared: INFO: context create/makeCurrent failed");
                            gLException.printStackTrace();
                        }
                    }
                    finally {
                        ((GLContextImpl)((Object)list)).destroy();
                    }
                }
                ((GLDrawableImpl)object2).setRealized(false);
            }
            catch (Throwable throwable) {
                if (DEBUG) {
                    System.err.println("Catched Exception on thread " + EGLDrawableFactory.getThreadName());
                    throwable.printStackTrace();
                }
                bl = false;
            }
            finally {
                if (eGLGraphicsDevice == this.defaultDevice) {
                    if (null != proxySurface2) {
                        proxySurface2.destroyNotify();
                    }
                } else if (bl3) {
                    if (null != eGLGraphicsDevice) {
                        eGLGraphicsDevice.close();
                    }
                    if (null != proxySurface2) {
                        proxySurface2.destroyNotify();
                    }
                } else {
                    if (null != proxySurface2) {
                        proxySurface2.destroyNotify();
                    }
                    if (null != eGLGraphicsDevice) {
                        eGLGraphicsDevice.close();
                    }
                }
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean needsToCreateSharedResource(String string, SharedResource[] sharedResourceArray) {
        HashMap<String, SharedResource> hashMap = this.sharedMap;
        synchronized (hashMap) {
            SharedResource sharedResource = this.sharedMap.get(string);
            if (null == sharedResource) {
                boolean bl = this.sharedMapCreateAttempt.contains(string);
                if (!bl) {
                    this.sharedMapCreateAttempt.add(string);
                }
                return !bl;
            }
            if (null != sharedResourceArray) {
                sharedResourceArray[0] = sharedResource;
            }
            return false;
        }
    }

    @Override
    protected final SharedResource getOrCreateSharedResourceImpl(AbstractGraphicsDevice abstractGraphicsDevice) {
        if (null == this.sharedMap) {
            return null;
        }
        if (this.needsToCreateSharedResource(this.defaultDevice.getUniqueID(), null)) {
            if (DEBUG) {
                System.err.println("EGLDrawableFactory.createShared: (defaultDevice): req. device: " + abstractGraphicsDevice + ", defaultDevice " + this.defaultDevice);
                Thread.dumpStack();
            }
            if (null != this.defaultSharedResource) {
                this.dumpMap();
                throw new InternalError("defaultSharedResource already exist: " + this.defaultSharedResource);
            }
            this.defaultSharedResource = this.createEGLSharedResourceImpl(this.defaultDevice);
        }
        String string = abstractGraphicsDevice.getUniqueID();
        if (this.defaultDevice.getUniqueID().equals(string)) {
            return this.defaultSharedResource;
        }
        if (null == this.defaultSharedResource) {
            this.dumpMap();
            throw new InternalError("defaultSharedResource does not exist");
        }
        SharedResource[] sharedResourceArray = new SharedResource[]{null};
        if (!this.needsToCreateSharedResource(string, sharedResourceArray)) {
            return sharedResourceArray[0];
        }
        return this.createEGLSharedResourceImpl(abstractGraphicsDevice);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SharedResource createEGLSharedResourceImpl(AbstractGraphicsDevice abstractGraphicsDevice) {
        boolean[] blArray = new boolean[]{false};
        boolean[] blArray2 = new boolean[]{false};
        GLRendererQuirks[] gLRendererQuirksArray = new GLRendererQuirks[]{null};
        GLRendererQuirks[] gLRendererQuirksArray2 = new GLRendererQuirks[]{null};
        int[] nArray = new int[]{-1};
        int[] nArray2 = new int[]{-1};
        if (DEBUG) {
            System.err.println("EGLDrawableFactory.createShared(): device " + abstractGraphicsDevice);
        }
        boolean bl = null != eglES1DynamicLookupHelper ? this.mapAvailableEGLESConfig(abstractGraphicsDevice, 1, blArray, gLRendererQuirksArray, nArray) : false;
        boolean bl2 = null != eglES2DynamicLookupHelper ? this.mapAvailableEGLESConfig(abstractGraphicsDevice, 2, blArray2, gLRendererQuirksArray2, nArray2) : false;
        if (!EGLContext.getAvailableGLVersionsSet(abstractGraphicsDevice)) {
            EGLContext.setAvailableGLVersionsSet(abstractGraphicsDevice);
        }
        if (this.hasX11) {
            this.handleDontCloseX11DisplayQuirk(gLRendererQuirksArray[0]);
            this.handleDontCloseX11DisplayQuirk(gLRendererQuirksArray2[0]);
        }
        SharedResource sharedResource = new SharedResource(this.defaultDevice, bl, blArray[0], gLRendererQuirksArray[0], nArray[0], bl2, blArray2[0], gLRendererQuirksArray2[0], nArray2[0]);
        HashMap<String, SharedResource> hashMap = this.sharedMap;
        synchronized (hashMap) {
            this.sharedMap.put(abstractGraphicsDevice.getUniqueID(), sharedResource);
        }
        if (DEBUG) {
            System.err.println("EGLDrawableFactory.createShared: devices: queried nativeTK " + QUERY_EGL_ES_NATIVE_TK + ", adevice " + abstractGraphicsDevice + ", defaultDevice " + this.defaultDevice);
            System.err.println("EGLDrawableFactory.createShared: context ES1: " + bl + ", hasPBuffer " + blArray[0]);
            System.err.println("EGLDrawableFactory.createShared: context ES2: " + bl2 + ", hasPBuffer " + blArray2[0]);
            this.dumpMap();
        }
        return sharedResource;
    }

    private void handleDontCloseX11DisplayQuirk(GLRendererQuirks gLRendererQuirks) {
        if (null != gLRendererQuirks && gLRendererQuirks.exist(8)) {
            X11Util.markAllDisplaysUnclosable();
        }
    }

    @Override
    protected final Thread getSharedResourceThread() {
        return null;
    }

    public final boolean isANGLE() {
        return this.isANGLE;
    }

    @Override
    public GLDynamicLookupHelper getGLDynamicLookupHelper(int n) {
        if (2 == n) {
            return eglES2DynamicLookupHelper;
        }
        if (1 == n) {
            return eglES1DynamicLookupHelper;
        }
        throw new GLException("Unsupported: ES" + n);
    }

    @Override
    protected List<GLCapabilitiesImmutable> getAvailableCapabilitiesImpl(AbstractGraphicsDevice abstractGraphicsDevice) {
        if (null == this.sharedMap) {
            return new ArrayList<GLCapabilitiesImmutable>();
        }
        return EGLGraphicsConfigurationFactory.getAvailableCapabilities(this, abstractGraphicsDevice);
    }

    @Override
    protected GLDrawableImpl createOnscreenDrawableImpl(NativeSurface nativeSurface) {
        if (nativeSurface == null) {
            throw new IllegalArgumentException("Null target");
        }
        return new EGLOnscreenDrawable(this, EGLWrappedSurface.get(nativeSurface));
    }

    @Override
    protected GLDrawableImpl createOffscreenDrawableImpl(NativeSurface nativeSurface) {
        if (nativeSurface == null) {
            throw new IllegalArgumentException("Null target");
        }
        AbstractGraphicsConfiguration abstractGraphicsConfiguration = nativeSurface.getGraphicsConfiguration();
        GLCapabilitiesImmutable gLCapabilitiesImmutable = (GLCapabilitiesImmutable)abstractGraphicsConfiguration.getChosenCapabilities();
        if (!gLCapabilitiesImmutable.isPBuffer()) {
            throw new GLException("Non pbuffer not yet implemented");
        }
        return new EGLPbufferDrawable(this, EGLWrappedSurface.get(nativeSurface));
    }

    @Override
    public boolean canCreateGLPbuffer(AbstractGraphicsDevice abstractGraphicsDevice) {
        return true;
    }

    @Override
    protected ProxySurface createMutableSurfaceImpl(AbstractGraphicsDevice abstractGraphicsDevice, boolean bl, GLCapabilitiesImmutable gLCapabilitiesImmutable, GLCapabilitiesImmutable gLCapabilitiesImmutable2, GLCapabilitiesChooser gLCapabilitiesChooser, UpstreamSurfaceHook upstreamSurfaceHook) {
        boolean bl2;
        EGLGraphicsDevice eGLGraphicsDevice;
        if (bl || !(abstractGraphicsDevice instanceof EGLGraphicsDevice)) {
            long l = abstractGraphicsDevice instanceof EGLGraphicsDevice ? ((EGLGraphicsDevice)abstractGraphicsDevice).getNativeDisplayID() : abstractGraphicsDevice.getHandle();
            eGLGraphicsDevice = EGLDisplayUtil.eglCreateEGLGraphicsDevice(l, abstractGraphicsDevice.getConnection(), abstractGraphicsDevice.getUnitID());
            bl2 = true;
        } else {
            eGLGraphicsDevice = (EGLGraphicsDevice)abstractGraphicsDevice;
            bl2 = false;
        }
        DefaultGraphicsScreen defaultGraphicsScreen = new DefaultGraphicsScreen(eGLGraphicsDevice, 0);
        EGLGraphicsConfiguration eGLGraphicsConfiguration = EGLGraphicsConfigurationFactory.chooseGraphicsConfigurationStatic(gLCapabilitiesImmutable, gLCapabilitiesImmutable2, gLCapabilitiesChooser, defaultGraphicsScreen, 0, false);
        if (null == eGLGraphicsConfiguration) {
            throw new GLException("Choosing GraphicsConfiguration failed w/ " + gLCapabilitiesImmutable + " on " + defaultGraphicsScreen);
        }
        return new WrappedSurface(eGLGraphicsConfiguration, 0L, upstreamSurfaceHook, bl2);
    }

    @Override
    public final ProxySurface createDummySurfaceImpl(AbstractGraphicsDevice abstractGraphicsDevice, boolean bl, GLCapabilitiesImmutable gLCapabilitiesImmutable, GLCapabilitiesImmutable gLCapabilitiesImmutable2, GLCapabilitiesChooser gLCapabilitiesChooser, int n, int n2) {
        gLCapabilitiesImmutable = GLGraphicsConfigurationUtil.fixOffscreenBitOnly(gLCapabilitiesImmutable);
        return this.createMutableSurfaceImpl(abstractGraphicsDevice, bl, gLCapabilitiesImmutable, gLCapabilitiesImmutable2, gLCapabilitiesChooser, new EGLDummyUpstreamSurfaceHook(n, n2));
    }

    protected static MutableSurface createPBufferSurfaceImpl(MutableSurface mutableSurface, boolean bl) {
        return null;
    }

    protected static long createPBufferSurfaceImpl(EGLGraphicsConfiguration eGLGraphicsConfiguration, int n, int n2, boolean bl) {
        EGLGraphicsDevice eGLGraphicsDevice = (EGLGraphicsDevice)eGLGraphicsConfiguration.getScreen().getDevice();
        GLCapabilitiesImmutable gLCapabilitiesImmutable = (GLCapabilitiesImmutable)eGLGraphicsConfiguration.getChosenCapabilities();
        int n3 = bl ? (gLCapabilitiesImmutable.getAlphaBits() > 0 ? 12382 : 12381) : 12380;
        if (DEBUG) {
            System.out.println("Pbuffer config: " + eGLGraphicsConfiguration);
        }
        IntBuffer intBuffer = EGLGraphicsConfiguration.CreatePBufferSurfaceAttribList(n, n2, n3);
        long l = EGL.eglCreatePbufferSurface(eGLGraphicsDevice.getHandle(), eGLGraphicsConfiguration.getNativeConfig(), intBuffer);
        if (0L == l) {
            throw new GLException("Creation of window surface (eglCreatePbufferSurface) failed, dim " + n + "x" + n2 + ", " + eGLGraphicsDevice + ", " + eGLGraphicsConfiguration + ", error 0x" + Integer.toHexString(EGL.eglGetError()));
        }
        if (DEBUG) {
            System.err.println("PBuffer setSurface result: eglSurface 0x" + Long.toHexString(l));
        }
        return l;
    }

    @Override
    protected ProxySurface createProxySurfaceImpl(AbstractGraphicsDevice abstractGraphicsDevice, int n, long l, GLCapabilitiesImmutable gLCapabilitiesImmutable, GLCapabilitiesChooser gLCapabilitiesChooser, UpstreamSurfaceHook upstreamSurfaceHook) {
        EGLGraphicsDevice eGLGraphicsDevice = (EGLGraphicsDevice)abstractGraphicsDevice;
        EGLGraphicsDevice eGLGraphicsDevice2 = EGLDisplayUtil.eglCreateEGLGraphicsDevice(eGLGraphicsDevice.getNativeDisplayID(), abstractGraphicsDevice.getConnection(), abstractGraphicsDevice.getUnitID());
        DefaultGraphicsScreen defaultGraphicsScreen = new DefaultGraphicsScreen(eGLGraphicsDevice2, n);
        EGLGraphicsConfiguration eGLGraphicsConfiguration = EGLGraphicsConfigurationFactory.chooseGraphicsConfigurationStatic(gLCapabilitiesImmutable, gLCapabilitiesImmutable, gLCapabilitiesChooser, defaultGraphicsScreen, 0, false);
        return new WrappedSurface(eGLGraphicsConfiguration, l, upstreamSurfaceHook, true);
    }

    @Override
    protected GLContext createExternalGLContextImpl() {
        AbstractGraphicsScreen abstractGraphicsScreen = DefaultGraphicsScreen.createDefault(NativeWindowFactory.TYPE_EGL);
        return new EGLExternalContext(abstractGraphicsScreen);
    }

    @Override
    public boolean canCreateExternalGLDrawable(AbstractGraphicsDevice abstractGraphicsDevice) {
        return false;
    }

    @Override
    protected GLDrawable createExternalGLDrawableImpl() {
        throw new GLException("Not yet implemented");
    }

    static class SharedResource
    implements SharedResourceRunner.Resource {
        private final EGLGraphicsDevice device;
        private final GLRendererQuirks rendererQuirksES1;
        private final GLRendererQuirks rendererQuirksES2;
        private final int ctpES1;
        private final int ctpES2;
        private final boolean wasES1ContextCreated;
        private final boolean wasES2ContextCreated;
        private final boolean hasPBufferES1;
        private final boolean hasPBufferES2;

        SharedResource(EGLGraphicsDevice eGLGraphicsDevice, boolean bl, boolean bl2, GLRendererQuirks gLRendererQuirks, int n, boolean bl3, boolean bl4, GLRendererQuirks gLRendererQuirks2, int n2) {
            this.device = eGLGraphicsDevice;
            this.rendererQuirksES1 = gLRendererQuirks;
            this.rendererQuirksES2 = gLRendererQuirks2;
            this.ctpES1 = n;
            this.ctpES2 = n2;
            this.wasES1ContextCreated = bl;
            this.wasES2ContextCreated = bl3;
            this.hasPBufferES1 = bl2;
            this.hasPBufferES2 = bl4;
        }

        @Override
        public final boolean isValid() {
            return this.wasES1ContextCreated || this.wasES2ContextCreated;
        }

        @Override
        public final EGLGraphicsDevice getDevice() {
            return this.device;
        }

        @Override
        public AbstractGraphicsScreen getScreen() {
            return null;
        }

        @Override
        public GLDrawableImpl getDrawable() {
            return null;
        }

        @Override
        public GLContextImpl getContext() {
            return null;
        }

        @Override
        public GLRendererQuirks getRendererQuirks() {
            return null != this.rendererQuirksES2 ? this.rendererQuirksES2 : this.rendererQuirksES1;
        }
    }
}

