/*
 * Decompiled with CFR 0.152.
 */
package processing.data;

import java.io.BufferedReader;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import processing.core.PApplet;
import processing.data.Sort;

public class StringDict {
    protected int count;
    protected String[] keys;
    protected String[] values;
    private HashMap<String, Integer> indices = new HashMap();

    public StringDict() {
        this.count = 0;
        this.keys = new String[10];
        this.values = new String[10];
    }

    public StringDict(int length) {
        this.count = 0;
        this.keys = new String[length];
        this.values = new String[length];
    }

    public StringDict(BufferedReader reader) {
        String[] lines = PApplet.loadStrings(reader);
        this.keys = new String[lines.length];
        this.values = new String[lines.length];
        for (int i = 0; i < lines.length; ++i) {
            String[] pieces = PApplet.split(lines[i], '\t');
            if (pieces.length != 2) continue;
            this.keys[this.count] = pieces[0];
            this.values[this.count] = pieces[1];
            ++this.count;
        }
    }

    public StringDict(String[] keys, String[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("key and value arrays must be the same length");
        }
        this.keys = keys;
        this.values = values;
        this.count = keys.length;
        for (int i = 0; i < this.count; ++i) {
            this.indices.put(keys[i], i);
        }
    }

    public int size() {
        return this.count;
    }

    public void clear() {
        this.count = 0;
        this.indices = new HashMap();
    }

    public String key(int index) {
        return this.keys[index];
    }

    protected void crop() {
        if (this.count != this.keys.length) {
            this.keys = PApplet.subset(this.keys, 0, this.count);
            this.values = PApplet.subset(this.values, 0, this.count);
        }
    }

    public Iterable<String> keys() {
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return new Iterator<String>(){
                    int index = -1;

                    @Override
                    public void remove() {
                        StringDict.this.removeIndex(this.index);
                    }

                    @Override
                    public String next() {
                        return StringDict.this.key(++this.index);
                    }

                    @Override
                    public boolean hasNext() {
                        return this.index + 1 < StringDict.this.size();
                    }
                };
            }
        };
    }

    public String[] keyArray() {
        return this.keyArray(null);
    }

    public String[] keyArray(String[] outgoing) {
        if (outgoing == null || outgoing.length != this.count) {
            outgoing = new String[this.count];
        }
        System.arraycopy(this.keys, 0, outgoing, 0, this.count);
        return outgoing;
    }

    public String value(int index) {
        return this.values[index];
    }

    public Iterable<String> values() {
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return new Iterator<String>(){
                    int index = -1;

                    @Override
                    public void remove() {
                        StringDict.this.removeIndex(this.index);
                    }

                    @Override
                    public String next() {
                        return StringDict.this.value(++this.index);
                    }

                    @Override
                    public boolean hasNext() {
                        return this.index + 1 < StringDict.this.size();
                    }
                };
            }
        };
    }

    public String[] valueArray() {
        return this.valueArray(null);
    }

    public String[] valueArray(String[] array) {
        if (array == null || array.length != this.size()) {
            array = new String[this.count];
        }
        System.arraycopy(this.values, 0, array, 0, this.count);
        return array;
    }

    public String get(String key) {
        int index = this.index(key);
        if (index == -1) {
            return null;
        }
        return this.values[index];
    }

    public void set(String key, String amount) {
        int index = this.index(key);
        if (index == -1) {
            this.create(key, amount);
        } else {
            this.values[index] = amount;
        }
    }

    public int index(String what) {
        Integer found = this.indices.get(what);
        return found == null ? -1 : found;
    }

    public boolean hasKey(String key) {
        return this.index(key) != -1;
    }

    protected void create(String key, String value) {
        if (this.count == this.keys.length) {
            this.keys = PApplet.expand(this.keys);
            this.values = PApplet.expand(this.values);
        }
        this.indices.put(key, new Integer(this.count));
        this.keys[this.count] = key;
        this.values[this.count] = value;
        ++this.count;
    }

    public int remove(String key) {
        int index = this.index(key);
        if (index != -1) {
            this.removeIndex(index);
        }
        return index;
    }

    public String removeIndex(int index) {
        if (index < 0 || index >= this.count) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        String key = this.keys[index];
        this.indices.remove(key);
        for (int i = index; i < this.count - 1; ++i) {
            this.keys[i] = this.keys[i + 1];
            this.values[i] = this.values[i + 1];
            this.indices.put(this.keys[i], i);
        }
        --this.count;
        this.keys[this.count] = null;
        this.values[this.count] = null;
        return key;
    }

    protected void swap(int a, int b) {
        String tkey = this.keys[a];
        String tvalue = this.values[a];
        this.keys[a] = this.keys[b];
        this.values[a] = this.values[b];
        this.keys[b] = tkey;
        this.values[b] = tvalue;
        this.indices.put(this.keys[a], new Integer(a));
        this.indices.put(this.keys[b], new Integer(b));
    }

    public void sortKeys() {
        this.sortImpl(true, false);
    }

    public void sortKeysReverse() {
        this.sortImpl(true, true);
    }

    public void sortValues() {
        this.sortImpl(false, false);
    }

    public void sortValuesReverse() {
        this.sortImpl(false, true);
    }

    protected void sortImpl(final boolean useKeys, final boolean reverse) {
        Sort s = new Sort(){

            @Override
            public int size() {
                return StringDict.this.count;
            }

            @Override
            public float compare(int a, int b) {
                int diff = 0;
                if (useKeys) {
                    diff = StringDict.this.keys[a].compareToIgnoreCase(StringDict.this.keys[b]);
                    if (diff == 0) {
                        diff = StringDict.this.values[a].compareToIgnoreCase(StringDict.this.values[b]);
                    }
                } else {
                    diff = StringDict.this.values[a].compareToIgnoreCase(StringDict.this.values[b]);
                    if (diff == 0) {
                        diff = StringDict.this.keys[a].compareToIgnoreCase(StringDict.this.keys[b]);
                    }
                }
                return reverse ? (float)(-diff) : (float)diff;
            }

            @Override
            public void swap(int a, int b) {
                StringDict.this.swap(a, b);
            }
        };
        s.run();
    }

    public StringDict copy() {
        StringDict outgoing = new StringDict(this.count);
        System.arraycopy(this.keys, 0, outgoing.keys, 0, this.count);
        System.arraycopy(this.values, 0, outgoing.values, 0, this.count);
        for (int i = 0; i < this.count; ++i) {
            outgoing.indices.put(this.keys[i], i);
        }
        outgoing.count = this.count;
        return outgoing;
    }

    public void write(PrintWriter writer) {
        for (int i = 0; i < this.count; ++i) {
            writer.println(this.keys[i] + "\t" + this.values[i]);
        }
        writer.flush();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName() + " size=" + this.size() + " { ");
        for (int i = 0; i < this.size(); ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append("\"" + this.keys[i] + "\": \"" + this.values[i] + "\"");
        }
        sb.append(" }");
        return sb.toString();
    }
}

