
import java.io.*;
import java.awt.FileDialog;
import java.awt.Frame;

void setup() {
  String[] params = loadStrings(sketchPath("params.txt"));
  WavFile baseFileA = WavFile.readFromFilePath(sketchPath(params[1]));
  WavFile baseFileB = WavFile.readFromFilePath(sketchPath(params[3]));
  float[][] waveFormA = baseFileA.samplesAsFloat();
  float[][] waveFormB = baseFileB.samplesAsFloat();
  float[][] newWaveForm = new float[2][max(waveFormA[0].length, waveFormB[0].length)];
  int kernelLength=Integer.parseInt(params[5]);
  int kernelCenter=floor((float)kernelLength/2);
  int blockSizeA=Integer.parseInt(params[7]);
  int blockSizeB=Integer.parseInt(params[9]);
  float[] window = new float[kernelLength];
  for (int k=0;k<kernelLength;k++) {
    float position = (float)(k-kernelCenter)/kernelCenter;
    window[k] = 1.369982685*cos(position) + 0.4054102674*cos(2*position) - 0.03542758202*cos(3*position);// Nuttall window
  }
  for (int c=0;c<newWaveForm.length;c++) {
    for (int s=0;s<newWaveForm[c].length;s++) {
      newWaveForm[c][s] = 0;
      for (int k=0;k<kernelLength;k++) {
        int thisChA = c%waveFormA.length;
        int sPosAA = floor((float)s/blockSizeA)*blockSizeA;
        int sPosAB = sPosAA+blockSizeA;
        float blockPosA = (float)(s-sPosAA)/blockSizeA;
        float sampleAA = waveFormA[thisChA][(sPosAA+k-kernelCenter+waveFormA[thisChA].length)%waveFormA[thisChA].length];
        float sampleAB = waveFormA[thisChA][(sPosAB+k-kernelCenter+waveFormA[thisChA].length)%waveFormA[thisChA].length];
        float sampleA = sampleAA*(1-blockPosA) + sampleAB*blockPosA;
        int thisChB = c%waveFormB.length;
        int sPosBA = floor((float)s/blockSizeB)*blockSizeB;
        int sPosBB = sPosBA+blockSizeB;
        float blockPosB = (float)(s-sPosBA)/blockSizeB;
        float sampleBA = waveFormB[thisChB][(sPosBA+k-kernelCenter+waveFormB[thisChB].length)%waveFormB[thisChB].length];
        float sampleBB = waveFormB[thisChB][(sPosBB+k-kernelCenter+waveFormB[thisChB].length)%waveFormB[thisChB].length];
        float sampleB = sampleBA*(1-blockPosB) + sampleBB*blockPosB;
        newWaveForm[c][s] += sampleA * sampleB * window[k];
      }
    }
  }
  float highest=0;
  for (int c=0;c<newWaveForm.length;c++) {
    for (int i=0;i<newWaveForm[c].length;i++) highest=max((float)highest, abs((float)newWaveForm[c][i]));
  }
  for (int c=0;c<newWaveForm.length;c++) {
    for (int i=0;i<newWaveForm[c].length;i++) newWaveForm[c][i]=newWaveForm[c][i]/highest;
  }
  baseFileA.setSamplesFromFloat(newWaveForm);
  baseFileA.writeToFilePath(sketchPath("result.wav"));
}

void draw() {
}

