
import krister.Ess.*;
import java.awt.FileDialog;

float[] fWF;// final generated waveform
float[] oWF;// original waveform to imitate

int population=8;// population in each generation
int generations=256;// number of generations

int sampleRate=44100;

FMSynth origFmSynth = new FMSynth();// final FM synth
FMSynth bestFmSynth = new FMSynth();// final FM synth

DFT origDFT = new DFT();

void setup() {

  frameRate(5);

  colorMode(HSB);

  size(500,300);

  Ess.start(this);//start ess
  AudioChannel sLoad = new AudioChannel();
  sLoad.loadSound(dataPath("load.wav"));
  oWF=new float[sLoad.samples.length];
  for (int i=0;i<oWF.length;i++) {
    oWF[i]=sLoad.samples[i];
  }

  // make a DFT of the original
  origDFT.computeDFT(oWF);

  saveSample(oWF,"original");

  // generates a random fm synth as a starting point
  bestFmSynth.setRandomValues();

  // generate children
  FMSynth[] children = new FMSynth[population];

  // genetiv part
  for (int g = 0; g < generations;g++) {
    println("generation : "+g);
    for (int p = 0; p < population;p++) {
      println("child : "+p);
      if (p==0) {
        children[p]=bestFmSynth;
      }
      else {
        children[p]=bestFmSynth.makeAChild(g);
      }
    }
    bestFmSynth=children[defineBestChild(children)];
    // record this try
    float[] tWF=bestFmSynth.genSample(oWF.length);
    saveSample(tWF,"try"+g);
  }

  // generates a waveform
  fWF=bestFmSynth.genSample(oWF.length);

  // record a file
  saveSample(fWF,"best");

  // stop Ess  
  Ess.stop();
}

void draw() {
}

int defineBestChild(FMSynth[] children) {
  // make children DFTs  
  DFT[] childDFT = new DFT[children.length];
  int bestDFTIndex=0;
  for (int i=0;i<children.length;i++) {
    println("DFT on child "+i);
    childDFT[i]=new DFT();
    // generates a waveform fomr the synth
    childDFT[i].computeDFT(children[i].genSample(oWF.length));
    if (i>0) {
      // compare with the best found result so far
      if (childDFT[i].differentFrom(origDFT)<childDFT[bestDFTIndex].differentFrom(origDFT)) {
        // make it the best if it is
        bestDFTIndex=i;
      }
    }
  }
  return bestDFTIndex;
}

void testEnveloppe() {
  background(0);
  stroke(0xFF);
  Enveloppe envTest= new Enveloppe();
  envTest.setRandomValues(1);
  for (int i=0;i<width;i++) {
    point(i,envTest.getValueForTime((float)i/width)*height);
  }
}

class DFT {

  int wLength = 500;//window length
  int nbParts;
  int nbHarm;
  float[][] sinPart;
  float[][] cosPart;
  float[][] freq;
  float[][] magn;
  float[][] phas;

  DFT () {
  }

  void initLength(int sampleLength) {
    nbParts=ceil(sampleLength/wLength);
    nbHarm=ceil(wLength/2);
    sinPart = new float[nbHarm][nbParts];
    cosPart = new float[nbHarm][nbParts];
    freq = new float[nbHarm][nbParts];
    magn = new float[nbHarm][nbParts];
    phas = new float[nbHarm][nbParts];
  }

  void computeDFT(float[] sample) {
    //discrete fourier transform  
    int dataLength=sample.length;
    initLength(dataLength);
    for (int partial=0;partial<nbHarm;partial++) {
      for (int part=0;part<nbParts;part++) {
        sinPart[partial][part]=0;
        cosPart[partial][part]=0;
        for (int i=0;i<wLength;i++) {
          float phasor=(float)(i+part*wLength)*partial*TWO_PI/wLength;
          sinPart[partial][part]+=sample[(i+part*wLength)%dataLength]*sin(phasor);
          cosPart[partial][part]+=sample[(i+part*wLength)%dataLength]*cos(phasor);
        }
      }
    }
    //getting frequency magnitude and phase
    for (int partial=0;partial<nbHarm;partial++) {
      for (int part=0;part<nbParts;part++) {
        freq[partial][part]=(float)partial*sampleRate/((float)wLength);
        magn[partial][part]=2.0*sqrt(sq(sinPart[partial][part])+sq(cosPart[partial][part]))/(float)wLength;
        // value in db is 20.0*log10(magn[partial][part])
        phas[partial][part]=atan2(sinPart[partial][part],cosPart[partial][part]);
      }
    }
  }

  void displayDFT() {
    background(0);
    int nbHarm = freq.length;
    int nbParts = freq[0].length;
    for (int partial=0;partial<nbHarm;partial++) {
      for (int part=0;part<nbParts;part++) {
        stroke(map(phas[partial][part],0,TWO_PI,0,0xFF),0xE0,magn[partial][part]*0xFF);
        line(part*width/nbParts,height-partial,(part+1)*width/nbParts,height-partial);
      }
    }
  }

  float differentFrom(DFT toMatch) {
    // returns the differences bewteen two DFT's magnitudes
    float result=0;
    for (int p=0;p<nbParts;p++) {
      for (int h=0;h<nbHarm;h++) {
        result+=abs(magn[h][p]-toMatch.magn[h][p]);
      }
    }
    return result;
  }
}

void displayWF(float[] wF) {
  // displays a waveform on the screen
  background(0);
  stroke(0xFF,0x0A);
  for (int i=0;i<wF.length-1;i++) {
    line((float)i*width/wF.length,(wF[i]+1)*height/2,(float)(i+1)*width/wF.length,(wF[(i+1)]+1)*height/2);
  }
}

float[] generateSaw() {
  // returns a saw wave
  float[] result = new float[100000];
  for (int i=0;i<result.length;i++) {
    result[i]=(((float)i/500)%2)-1;
  }
  return result;
}

class FMSynth {
  int nbOps=5;// number of operators

  Enveloppe[] gains = new Enveloppe[nbOps];// volume enveloppes for each operator
  Enveloppe[] freqs = new Enveloppe[nbOps];// frequency enveloppe for each operator

  FMSynth() {
    for (int i=0;i<nbOps;i++) {
      gains[i]=new Enveloppe();
      freqs[i]=new Enveloppe();
    }
  }

  void setRandomValues() {
    // sets random values as a starting point
    for (int i=0;i<nbOps;i++) {
      if (i==0) {
        gains[i].setRandomValues(1);
        freqs[i].setRandomValues(1);
      }
      else {
        gains[i].setRandomValues(0.05);
        freqs[i].setRandomValues(1);
      }
    }
  }

  float[] genSample(int sLength) {
    // generates a sample out of the synth
    float[] result = new float[sLength];
    float[] basePhasor= new float[nbOps];
    for (int op=0;op<nbOps;op++) {
      basePhasor[op]=0;
    }
    for (int i=0;i<sLength;i++) {
      float thisValue=0;
      float currentPos=((float)i)/sLength;
      for (int op=0;op<nbOps;op++) {
        float realFreq = sq(sq(sq(freqs[op].getValueForTime(currentPos))))*20000;
        float phasorLength = (float)sampleRate/realFreq;   
        basePhasor[op] = (basePhasor[op]+(TWO_PI/phasorLength))%TWO_PI;
        float phaseMod = thisValue*PI;
        float gain = gains[op].getValueForTime(currentPos);
        thisValue=sin(basePhasor[op]+phaseMod)*gain;
      }
      result[i]=thisValue;
    }
    return result;
  }

  FMSynth makeAChild(int generation) {
    FMSynth result = new FMSynth();
    float marge=(float)1/((((float)generation/gains[0].nbPoints)+2)/2); 
    for (int op=0;op<nbOps;op++) {
      result.gains[op]=gains[op].evolveWithMarge(marge,generation);
      result.freqs[op]=freqs[op].evolveWithMarge(marge,generation);
    }
    return result;
  }
}

class Enveloppe {
  int nbPoints=32;// number of enveloppe points
  float[] points = new float[nbPoints];

  Enveloppe() {
  }

  void setRandomValues(float maxi) {
    // set random values beween 0 and 1 to each point
    for (int i=0;i<nbPoints;i++) {
      points[i]=random(maxi);
    }
  }

  float getValueForTime(float f) {
    // use interpolation between point to find the current enveloppe value
    float scaledPos=f*((float)nbPoints-1);// scaled position
    int lastPoint=floor(scaledPos);
    float proportionToNext=(float)scaledPos-lastPoint;
    float result=map(proportionToNext,0,1,points[lastPoint],points[lastPoint+1]);
    return result;
  }

  Enveloppe evolveWithMarge(float marge) {
    Enveloppe result= new Enveloppe();
    float[] newValues = new float[nbPoints];
    for (int i=0;i<nbPoints;i++) {
      newValues[i] = constrain(points[i]+random(-marge,marge),0,1);
    }
    result.setPoints(newValues);    
    return result;
  }

  Enveloppe evolveWithMarge(float marge, int generation) {
    Enveloppe result = new Enveloppe();
    float[] newValues = new float[nbPoints];
    for (int i=0;i<nbPoints;i++) {
      if (i==generation%nbPoints) {
        newValues[i] = constrain(points[i]+random(-marge,marge),0,1);
      }
      else {
        newValues[i] = points[i];
      }
    }
    result.setPoints(newValues);    
    return result;
  }

  void setPoints(float[] values) {
    points=values;
  }
}

void saveSample(float[] sample, String name) {
  AudioChannel sampleOutput = new AudioChannel();  
  sampleOutput.initChannel(sample.length);
  for (int i=0;i<sample.length;i++) {
    sampleOutput.samples[i]=sample[i];
  }
  sampleOutput.saveSound(dataPath(name+".wav"));
  sampleOutput.destroy();
}

