/*
 * Decompiled with CFR 0.152.
 */
import processing.core.PApplet;
import processing.core.PImage;

public class sketch_mar02a
extends PApplet {
    int tileSize = 16;
    int nbTilesX = 30;
    int nbTilesY = 30;
    int nbOfNonCross = 8;
    PImage tileset;
    boolean[][] crossable = new boolean[this.nbTilesX][this.nbTilesY];
    int[][] highness = new int[this.nbTilesX][this.nbTilesY];
    int[][][] id = new int[this.nbTilesX][this.nbTilesY][4];

    public void setup() {
        this.size(this.nbTilesX * this.tileSize, this.nbTilesY * this.tileSize);
        this.generateHighness();
        this.generateCrossable();
        this.setsRightIds();
        this.tileset = this.loadImage("tileset.png");
    }

    private void setsRightIds() {
        int n;
        int n2 = 0;
        while (n2 < this.nbTilesX) {
            n = 0;
            while (n < this.nbTilesY) {
                int n3 = 0;
                while (n3 < 4) {
                    this.id[n2][n][n3] = this.nbOfNonCross + this.highness[n2][n];
                    ++n3;
                }
                ++n;
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < this.nbTilesX) {
            n = 0;
            while (n < this.nbTilesY) {
                if (!this.crossable[n2][n]) {
                    this.id[n2][n] = this.findGoodWallFor(n2, n);
                }
                ++n;
            }
            ++n2;
        }
    }

    private int[] findGoodWallFor(int n, int n2) {
        int[] nArray = new int[4];
        boolean[][] blArray = new boolean[3][3];
        int n3 = -1;
        while (n3 < 2) {
            int n4 = -1;
            while (n4 < 2) {
                blArray[n3 + 1][n4 + 1] = n + n3 >= 0 && n2 + n4 >= 0 && n + n3 < this.nbTilesX && n2 + n4 < this.nbTilesY ? this.crossable[n3 + n][n4 + n2] : true;
                ++n4;
            }
            ++n3;
        }
        if (!(blArray[0][0] || blArray[1][0] || blArray[0][1])) {
            nArray[0] = 0;
        }
        if (blArray[0][0] && !blArray[1][0] && !blArray[0][1]) {
            nArray[0] = 1;
        }
        if (blArray[1][0] && blArray[0][1]) {
            nArray[0] = 2;
        }
        if (!blArray[1][0] && blArray[0][1]) {
            nArray[0] = 3;
        }
        if (blArray[1][0] && !blArray[0][1]) {
            nArray[0] = 4;
        }
        if (!(blArray[2][0] || blArray[1][0] || blArray[2][1])) {
            nArray[1] = 0;
        }
        if (blArray[2][0] && !blArray[1][0] && !blArray[2][1]) {
            nArray[1] = 1;
        }
        if (blArray[1][0] && blArray[2][1]) {
            nArray[1] = 2;
        }
        if (!blArray[1][0] && blArray[2][1]) {
            nArray[1] = 3;
        }
        if (blArray[1][0] && !blArray[2][1]) {
            nArray[1] = 4;
        }
        if (!(blArray[0][2] || blArray[1][2] || blArray[0][1])) {
            nArray[2] = 0;
        }
        if (blArray[0][2] && !blArray[1][2] && !blArray[0][1]) {
            nArray[2] = 1;
        }
        if (blArray[1][2] && blArray[0][1]) {
            nArray[2] = 2;
        }
        if (!blArray[1][2] && blArray[0][1]) {
            nArray[2] = 3;
        }
        if (blArray[1][2] && !blArray[0][1]) {
            nArray[2] = 4;
        }
        if (!(blArray[2][2] || blArray[1][2] || blArray[2][1])) {
            nArray[3] = 0;
        }
        if (blArray[2][2] && !blArray[1][2] && !blArray[2][1]) {
            nArray[3] = 1;
        }
        if (blArray[1][2] && blArray[2][1]) {
            nArray[3] = 2;
        }
        if (!blArray[1][2] && blArray[2][1]) {
            nArray[3] = 3;
        }
        if (blArray[1][2] && !blArray[2][1]) {
            nArray[3] = 4;
        }
        return nArray;
    }

    private Integer booleanToInt(boolean bl) {
        if (bl) {
            return 1;
        }
        return 0;
    }

    private void generateCrossable() {
        int n;
        int n2;
        int n3 = 0;
        while (n3 < this.nbTilesX) {
            n2 = 0;
            while (n2 < this.nbTilesY) {
                this.crossable[n3][n2] = n3 == 0 || n2 == 0 || n3 == this.nbTilesX - 1 || n2 == this.nbTilesY - 1 ? true : true;
                ++n2;
            }
            ++n3;
        }
        float f = this.random(0.02f);
        n2 = 0;
        while (n2 < this.nbTilesX) {
            n = 0;
            while (n < this.nbTilesY) {
                if (this.random(1.0f) < f && this.flatAround(n2, n) > 4) {
                    this.crossable[n2][n] = false;
                }
                ++n;
            }
            ++n2;
        }
        n2 = 10;
        n = 0;
        while (n < n2) {
            int n4 = 0;
            while (n4 < this.nbTilesX) {
                int n5 = 0;
                while (n5 < this.nbTilesY) {
                    if ((float)this.nbSurroundingWallsOf(n4, n5) >= this.random(10.0f) && (float)this.flatAround(n4, n5) >= this.random(10.0f)) {
                        this.crossable[n4][n5] = false;
                    }
                    ++n5;
                }
                ++n4;
            }
            ++n;
        }
    }

    private int flatAround(int n, int n2) {
        int n3 = 0;
        int n4 = -1;
        while (n4 < 2) {
            int n5 = -1;
            while (n5 < 2) {
                if ((n4 != 0 || n5 != 0) && n + n4 >= 0 && n2 + n5 >= 0 && n + n4 < this.nbTilesX && n2 + n5 < this.nbTilesY && this.highness[n4 + 1][n5 + 1] == this.highness[n][n2]) {
                    ++n3;
                }
                ++n5;
            }
            ++n4;
        }
        return n3;
    }

    private int nbSurroundingWallsOf(int n, int n2) {
        int n3 = 0;
        int n4 = -1;
        while (n4 < 2) {
            int n5 = -1;
            while (n5 < 2) {
                if (!(n4 == 0 && n5 == 0 || n + n4 < 0 || n2 + n5 < 0 || n + n4 >= this.nbTilesX || n2 + n5 >= this.nbTilesY || this.crossable[n + n4][n2 + n5])) {
                    ++n3;
                }
                ++n5;
            }
            ++n4;
        }
        return n3;
    }

    private void displayHighness() {
        this.background(0);
        int n = 0;
        while (n < this.nbTilesX) {
            int n2 = 0;
            while (n2 < this.nbTilesY) {
                this.stroke(this.highness[n][n2] * 255 / 8);
                this.point(n, n2);
                ++n2;
            }
            ++n;
        }
    }

    private void displayCrossable() {
        this.background(0);
        int n = 0;
        while (n < this.nbTilesX) {
            int n2 = 0;
            while (n2 < this.nbTilesY) {
                if (this.crossable[n][n2]) {
                    this.stroke(255);
                } else {
                    this.stroke(0);
                }
                this.point(n, n2);
                ++n2;
            }
            ++n;
        }
    }

    private void generateHighness() {
        float f = 0.15f;
        this.noiseDetail((int)this.random(10.0f), this.random(1.0f));
        this.noiseSeed((int)this.random(255.0f));
        int n = 0;
        while (n < this.nbTilesX) {
            int n2 = 0;
            while (n2 < this.nbTilesY) {
                this.highness[n][n2] = (int)(this.noise((float)n * f, (float)n2 * f) * 8.0f);
                this.highness[n][n2] = sketch_mar02a.constrain(this.highness[n][n2], 0, 7);
                ++n2;
            }
            ++n;
        }
    }

    public void draw() {
        this.displayTiles();
    }

    private void displayTiles() {
        int n = 0;
        while (n < this.nbTilesX) {
            int n2 = 0;
            while (n2 < this.nbTilesY) {
                int n3 = 0;
                while (n3 < 4) {
                    int n4 = 0;
                    while (n4 < this.tileSize / 2) {
                        int n5 = 0;
                        while (n5 < this.tileSize / 2) {
                            this.stroke(this.tileset.get(this.id[n][n2][n3] / 4 * this.tileSize + n4 + n3 % 2 * this.tileSize / 2, this.id[n][n2][n3] % 4 * this.tileSize + n5 + n3 / 2 * this.tileSize / 2));
                            this.point(n * this.tileSize + n4 + n3 % 2 * this.tileSize / 2, n2 * this.tileSize + n5 + n3 / 2 * this.tileSize / 2);
                            ++n5;
                        }
                        ++n4;
                    }
                    ++n3;
                }
                ++n2;
            }
            ++n;
        }
    }

    public void mousePressed() {
        this.generateHighness();
        this.generateCrossable();
        this.setsRightIds();
    }

    public static void main(String[] stringArray) {
        PApplet.main(new String[]{"--bgcolor=#D4D0C8", "sketch_mar02a"});
    }
}

