/*
 * Decompiled with CFR 0.152.
 */
public class FFT {
    public static Complex[] fft(Complex[] complexArray) {
        int n = complexArray.length;
        if (n == 1) {
            return new Complex[]{complexArray[0]};
        }
        if (n % 2 != 0) {
            throw new RuntimeException("N is not a power of 2");
        }
        Complex[] complexArray2 = new Complex[n / 2];
        int n2 = 0;
        while (n2 < n / 2) {
            complexArray2[n2] = complexArray[2 * n2];
            ++n2;
        }
        Complex[] complexArray3 = FFT.fft(complexArray2);
        Complex[] complexArray4 = complexArray2;
        int n3 = 0;
        while (n3 < n / 2) {
            complexArray4[n3] = complexArray[2 * n3 + 1];
            ++n3;
        }
        Complex[] complexArray5 = FFT.fft(complexArray4);
        Complex[] complexArray6 = new Complex[n];
        int n4 = 0;
        while (n4 < n / 2) {
            double d = (double)(-2 * n4) * Math.PI / (double)n;
            Complex complex = new Complex(Math.cos(d), Math.sin(d));
            complexArray6[n4] = complexArray3[n4].plus(complex.times(complexArray5[n4]));
            complexArray6[n4 + n / 2] = complexArray3[n4].minus(complex.times(complexArray5[n4]));
            ++n4;
        }
        return complexArray6;
    }

    public static Complex[] ifft(Complex[] complexArray) {
        int n = complexArray.length;
        Complex[] complexArray2 = new Complex[n];
        int n2 = 0;
        while (n2 < n) {
            complexArray2[n2] = complexArray[n2].conjugate();
            ++n2;
        }
        complexArray2 = FFT.fft(complexArray2);
        n2 = 0;
        while (n2 < n) {
            complexArray2[n2] = complexArray2[n2].conjugate();
            ++n2;
        }
        n2 = 0;
        while (n2 < n) {
            complexArray2[n2] = complexArray2[n2].times(1.0 / (double)n);
            ++n2;
        }
        return complexArray2;
    }

    public static Complex[] cconvolve(Complex[] complexArray, Complex[] complexArray2) {
        if (complexArray.length != complexArray2.length) {
            throw new RuntimeException("Dimensions don't agree");
        }
        int n = complexArray.length;
        Complex[] complexArray3 = FFT.fft(complexArray);
        Complex[] complexArray4 = FFT.fft(complexArray2);
        Complex[] complexArray5 = new Complex[n];
        int n2 = 0;
        while (n2 < n) {
            complexArray5[n2] = complexArray3[n2].times(complexArray4[n2]);
            ++n2;
        }
        return FFT.ifft(complexArray5);
    }

    public static Complex[] convolve(Complex[] complexArray, Complex[] complexArray2) {
        Complex complex = new Complex(0.0, 0.0);
        Complex[] complexArray3 = new Complex[2 * complexArray.length];
        int n = 0;
        while (n < complexArray.length) {
            complexArray3[n] = complexArray[n];
            ++n;
        }
        n = complexArray.length;
        while (n < 2 * complexArray.length) {
            complexArray3[n] = complex;
            ++n;
        }
        Complex[] complexArray4 = new Complex[2 * complexArray2.length];
        int n2 = 0;
        while (n2 < complexArray2.length) {
            complexArray4[n2] = complexArray2[n2];
            ++n2;
        }
        n2 = complexArray2.length;
        while (n2 < 2 * complexArray2.length) {
            complexArray4[n2] = complex;
            ++n2;
        }
        return FFT.cconvolve(complexArray3, complexArray4);
    }

    public static void show(Complex[] complexArray, String string) {
        System.out.println(string);
        System.out.println("-------------------");
        int n = 0;
        while (n < complexArray.length) {
            System.out.println(complexArray[n]);
            ++n;
        }
        System.out.println();
    }

    public static void main(String[] stringArray) {
        int n = Integer.parseInt(stringArray[0]);
        Complex[] complexArray = new Complex[n];
        int n2 = 0;
        while (n2 < n) {
            complexArray[n2] = new Complex(n2, 0.0);
            complexArray[n2] = new Complex(-2.0 * Math.random() + 1.0, 0.0);
            ++n2;
        }
        FFT.show(complexArray, "x");
        Complex[] complexArray2 = FFT.fft(complexArray);
        FFT.show(complexArray2, "y = fft(x)");
        Complex[] complexArray3 = FFT.ifft(complexArray2);
        FFT.show(complexArray3, "z = ifft(y)");
        Complex[] complexArray4 = FFT.cconvolve(complexArray, complexArray);
        FFT.show(complexArray4, "c = cconvolve(x, x)");
        Complex[] complexArray5 = FFT.convolve(complexArray, complexArray);
        FFT.show(complexArray5, "d = convolve(x, x)");
    }
}

