/*
 * Decompiled with CFR 0.152.
 */
import processing.core.PApplet;

public class coll05
extends PApplet {
    float sizx = 600.0f;
    float sizy = 600.0f;
    int iPlace = 0;
    int nbBoules = 1;
    int nbTriangles = 2;
    int nbLevels = 1;
    int nbSorties = 1;
    Boule[] bou = new Boule[this.nbBoules];
    Triangle[] tri = new Triangle[this.nbTriangles];
    Level[] lev = new Level[this.nbLevels];
    int levelActuel = 0;
    Sortie[] sor = new Sortie[this.nbSorties];

    public void setup() {
        this.size((int)this.sizx, (int)this.sizy);
        this.frameRate(30.0f);
        this.smooth();
        this.fill(255);
        this.stroke(127);
        int n = 0;
        while (n < this.nbTriangles) {
            this.tri[n] = new Triangle(n);
            ++n;
        }
        n = 0;
        while (n < this.nbBoules) {
            this.bou[n] = new Boule(n);
            ++n;
        }
        n = 0;
        while (n < this.nbSorties) {
            this.sor[n] = new Sortie(n);
            ++n;
        }
        n = 0;
        while (n < this.nbLevels) {
            this.lev[n] = new Level(n);
            ++n;
        }
        this.initLevels();
        this.chargeLv(0);
    }

    public void draw() {
        this.background(0);
        int n = 0;
        while (n < this.nbSorties) {
            this.sor[n].dessine();
            ++n;
        }
        n = 0;
        while (n < this.nbBoules) {
            this.bou[n].agit();
            this.bou[n].dessine();
            ++n;
        }
        n = 0;
        while (n < this.nbTriangles) {
            this.tri[n].dessine();
            this.tri[n].agit();
            ++n;
        }
        if (this.mousePressed) {
            n = 1;
            float f = this.random(-this.bou[this.iPlace].r, this.bou[this.iPlace].r);
            int n2 = 0;
            while (n2 < this.nbBoules) {
                if (this.longueur((float)this.mouseX + f, this.mouseY, this.bou[n2].x, this.bou[n2].y) <= this.bou[n2].r + this.bou[this.iPlace].r + this.bou[this.iPlace].v) {
                    n = 0;
                }
                ++n2;
            }
            n2 = 0;
            while (n2 < this.nbTriangles) {
                ColBouPol colBouPol = new ColBouPol(this.tri[n2].nbCotes, this.tri[n2].x, this.tri[n2].y, (float)this.mouseX + f, this.mouseY, this.bou[this.iPlace].r);
                if (colBouPol.collision) {
                    n = 0;
                }
                ++n2;
            }
            if (n != 0) {
                this.bou[this.iPlace].place((float)this.mouseX + f, this.mouseY, 1.5707964f);
                this.iPlace = (this.iPlace + 1) % this.nbBoules;
            }
        }
    }

    public float longueur(float f, float f2, float f3, float f4) {
        return coll05.sqrt(coll05.sq(f3 - f) + coll05.sq(f4 - f2));
    }

    public boolean iPol(float f, float f2, float[] fArray, float[] fArray2) {
        int n = 0;
        int n2 = 0;
        int n3 = fArray.length - 1;
        while (n2 < fArray.length) {
            if ((fArray2[n2] <= f2 && f2 < fArray2[n3] || fArray2[n3] <= f2 && f2 < fArray2[n2]) && f < (fArray[n3] - fArray[n2]) * (f2 - fArray2[n2]) / (fArray2[n3] - fArray2[n2]) + fArray[n2]) {
                n = (n + 1) % 2;
            }
            n3 = n2++;
        }
        return n == 1;
    }

    public void keyPressed() {
        if (this.keyCode == 8) {
            int n = 0;
            while (n < this.nbTriangles) {
                this.tri[n] = new Triangle(n);
                ++n;
            }
            n = 0;
            while (n < this.nbBoules) {
                this.bou[n] = new Boule(n);
                ++n;
            }
            n = 0;
            while (n < this.nbSorties) {
                this.sor[n] = new Sortie(n);
                ++n;
            }
        } else {
            int n = 0;
            while (n < this.nbTriangles) {
                this.tri[n].type = this.tri[n].type == 0 ? 1 : 0;
                ++n;
            }
        }
    }

    public void chargeLv(int n) {
        this.nbBoules = this.lev[n].nbBoules;
        this.nbTriangles = this.lev[n].nbTriangles;
        this.nbSorties = this.lev[n].nbSorties;
        this.bou = new Boule[this.nbBoules];
        this.tri = new Triangle[this.nbTriangles];
        this.sor = new Sortie[this.nbSorties];
        int n2 = 0;
        while (n2 < this.nbBoules) {
            this.bou[n2] = this.lev[n].bou[n2];
            ++n2;
        }
        n2 = 0;
        while (n2 < this.nbTriangles) {
            this.tri[n2] = this.lev[n].tri[n2];
            ++n2;
        }
        n2 = 0;
        while (n2 < this.nbSorties) {
            this.sor[n2] = this.lev[n].sor[n2];
            ++n2;
        }
    }

    public void initLevels() {
        float f = this.sizx / 100.0f;
        float f2 = this.sizy / 100.0f;
        this.lev[0].nbBoules = 1;
        this.lev[0].nbTriangles = 2;
        this.lev[0].nbSorties = 1;
        this.lev[0].setObj();
        this.lev[0].sor[0].x = f * 50.0f;
        this.lev[0].sor[0].y = f2 * 78.0f;
        this.lev[0].sor[0].r = (f + f2) / 1.7f;
        this.lev[0].bou[0].x = f * 10.0f;
        this.lev[0].bou[0].y = f2 * 10.0f;
        this.lev[0].bou[0].r = (f + f2) / 2.0f;
        this.lev[0].tri[0].nbCotes = 6;
        this.lev[0].tri[0].type = 0;
        this.lev[0].tri[0].x = new float[10];
        this.lev[0].tri[0].y = new float[10];
        this.lev[0].tri[0].x[0] = f * 1.0f;
        this.lev[0].tri[0].y[0] = f2 * 21.0f;
        this.lev[0].tri[0].x[1] = f * 50.0f;
        this.lev[0].tri[0].y[1] = f2 * 30.0f;
        this.lev[0].tri[0].x[2] = f * 99.0f;
        this.lev[0].tri[0].y[2] = f2 * 21.0f;
        this.lev[0].tri[0].x[3] = f * 99.0f;
        this.lev[0].tri[0].y[3] = f2 * 50.0f;
        this.lev[0].tri[0].x[4] = f * 50.0f;
        this.lev[0].tri[0].y[4] = f2 * 60.0f;
        this.lev[0].tri[0].x[5] = f * 1.0f;
        this.lev[0].tri[0].y[5] = f2 * 50.0f;
        this.lev[0].tri[1].nbCotes = 6;
        this.lev[0].tri[1].type = 1;
        this.lev[0].tri[1].x = new float[10];
        this.lev[0].tri[1].y = new float[10];
        this.lev[0].tri[1].x[0] = f * 1.0f;
        this.lev[0].tri[1].y[0] = f2 * 71.0f;
        this.lev[0].tri[1].x[1] = f * 50.0f;
        this.lev[0].tri[1].y[1] = f2 * 80.0f;
        this.lev[0].tri[1].x[2] = f * 99.0f;
        this.lev[0].tri[1].y[2] = f2 * 71.0f;
        this.lev[0].tri[1].x[3] = f * 99.0f;
        this.lev[0].tri[1].y[3] = f2 * 80.0f;
        this.lev[0].tri[1].x[4] = f * 50.0f;
        this.lev[0].tri[1].y[4] = f2 * 90.0f;
        this.lev[0].tri[1].x[5] = f * 1.0f;
        this.lev[0].tri[1].y[5] = f2 * 80.0f;
    }

    public static void main(String[] stringArray) {
        PApplet.main(new String[]{"--bgcolor=#D4D0C8", "coll05"});
    }

    class Boule {
        float x;
        float y;
        float r;
        float v;
        float a;
        int nb;
        int type;
        boolean sortie = false;

        Boule(int n) {
            this.nb = n;
            this.type = n % 2 == 0 ? 0 : 1;
            this.r = coll05.this.random(10.0f) + 2.0f;
            this.v = coll05.this.random(5.0f) + 1.0f;
            this.a = coll05.this.random((float)Math.PI * 2);
            boolean bl = false;
            while (!bl) {
                this.x = coll05.this.random(coll05.this.width);
                this.y = coll05.this.random(coll05.this.height);
                bl = true;
                int n2 = 0;
                while (n2 < n) {
                    if (coll05.this.longueur(this.x, this.y, coll05.this.bou[n2].x, coll05.this.bou[n2].y) < this.r + coll05.this.bou[n2].r) {
                        bl = false;
                    }
                    ++n2;
                }
                n2 = 0;
                while (n2 < coll05.this.nbTriangles) {
                    ColBouPol colBouPol = new ColBouPol(coll05.this.tri[n2].nbCotes, coll05.this.tri[n2].x, coll05.this.tri[n2].y, this.x, this.y, this.r);
                    if (colBouPol.collision) {
                        bl = false;
                    }
                    ++n2;
                }
            }
        }

        public void gravite() {
            float f = 0.1f;
            float f2 = 0.5f;
            float f3 = 10.0f;
            float f4 = this.y + coll05.sin(this.a) * this.v + f2;
            float f5 = this.x + coll05.cos(this.a) * this.v;
            boolean bl = true;
            int n = 0;
            while (n < coll05.this.nbTriangles) {
                ColBouPol colBouPol = new ColBouPol(coll05.this.tri[n].nbCotes, coll05.this.tri[n].x, coll05.this.tri[n].y, f5, f4, this.r);
                if (colBouPol.collision && this.type == coll05.this.tri[n].type) {
                    bl = false;
                }
                ++n;
            }
            n = 0;
            while (n < coll05.this.nbBoules) {
                if (n != this.nb && coll05.this.longueur(this.x, this.y, coll05.this.bou[n].x, coll05.this.bou[n].y) < this.r + coll05.this.bou[n].r) {
                    bl = false;
                }
                ++n;
            }
            if (bl) {
                this.a = coll05.atan2(f4 - this.y, f5 - this.x);
                this.v = coll05.constrain(coll05.this.longueur(this.x, this.y, f5, f4), 0.0f, f3);
            }
            this.v = coll05.constrain(this.v - f, 0.0f, f3);
        }

        public void rebondBalles(float f) {
            float f2 = this.y + coll05.sin(this.a) * f;
            float f3 = this.x + coll05.cos(this.a) * f;
            int n = 0;
            while (n < coll05.this.nbBoules) {
                if (n != this.nb && coll05.this.longueur(f3, f2, coll05.this.bou[n].x, coll05.this.bou[n].y) < this.r + coll05.this.bou[n].r) {
                    float f4 = coll05.atan2(coll05.this.bou[n].y - f2, coll05.this.bou[n].x - f3);
                    if (coll05.this.longueur(f3, f2, coll05.this.bou[n].x, coll05.this.bou[n].y) > coll05.this.longueur(f3 + coll05.cos(this.a), f2 + coll05.sin(this.a), coll05.this.bou[n].x, coll05.this.bou[n].y)) {
                        this.a = this.a + (f4 - this.a) * 2.0f - (float)Math.PI;
                    }
                    if (coll05.this.longueur(f3, f2, coll05.this.bou[n].x, coll05.this.bou[n].y) > coll05.this.longueur(f3, f2, coll05.this.bou[n].x + coll05.cos(coll05.this.bou[n].a), coll05.this.bou[n].y + coll05.sin(coll05.this.bou[n].a))) {
                        coll05.this.bou[n].a = coll05.this.bou[n].a + (f4 + (float)Math.PI - coll05.this.bou[n].a) * 2.0f - (float)Math.PI;
                    }
                }
                ++n;
            }
        }

        public void rebondTriangles(float f) {
            float f2 = this.y + coll05.sin(this.a) * f;
            float f3 = this.x + coll05.cos(this.a) * f;
            int n = 0;
            while (n < coll05.this.nbTriangles) {
                ColBouPol colBouPol = new ColBouPol(coll05.this.tri[n].nbCotes, coll05.this.tri[n].x, coll05.this.tri[n].y, f3, f2, this.r);
                if (colBouPol.collision && this.type == coll05.this.tri[n].type) {
                    ColBouPol colBouPol2 = new ColBouPol(coll05.this.tri[n].nbCotes, coll05.this.tri[n].x, coll05.this.tri[n].y, f3 + coll05.cos(this.a), f2 + coll05.sin(this.a), this.r);
                    if (colBouPol.penetration > colBouPol2.penetration) {
                        float f4 = 0.0f;
                        this.a = this.a + (colBouPol.angle - this.a) * 2.0f - (float)Math.PI;
                        this.v *= 1.0f - f4;
                        if (this.v < 1.0f) {
                            this.a = coll05.min((colBouPol.angle + 1.5707964f + (float)Math.PI * 2) % ((float)Math.PI * 2), (colBouPol.angle + 1.5707964f + (float)Math.PI + (float)Math.PI * 2) % ((float)Math.PI * 2));
                            this.a = coll05.atan2(coll05.sin(this.a) - 1.0f, coll05.cos(this.a));
                        }
                    }
                }
                ++n;
            }
        }

        public void agit() {
            if (!this.sortie) {
                this.gravite();
                int n = 0;
                while ((float)n < this.v) {
                    this.rebondBalles(1.0f);
                    this.rebondTriangles(1.0f);
                    this.x += coll05.cos(this.a);
                    this.y += coll05.sin(this.a);
                    ++n;
                }
                this.rebondBalles(this.v - (float)n);
                this.rebondTriangles(this.v - (float)n);
                this.x += coll05.cos(this.a) * (this.v - (float)n);
                this.y += coll05.sin(this.a) * (this.v - (float)n);
                this.x = (this.x + (float)coll05.this.width) % (float)coll05.this.width;
                this.y = (this.y + (float)coll05.this.height) % (float)coll05.this.height;
            }
            this.vaSortie();
        }

        public void vaSortie() {
            this.sortie = false;
            int n = 0;
            while (n < coll05.this.nbSorties) {
                if (coll05.this.longueur(this.x, this.y, coll05.this.sor[n].x, coll05.this.sor[n].y) <= this.r + coll05.this.sor[n].r) {
                    this.x = (this.x + coll05.this.sor[n].x) / 2.0f;
                    this.y = (this.y + coll05.this.sor[n].y) / 2.0f;
                    this.sortie = true;
                }
                ++n;
            }
        }

        public void dessine() {
            if (this.type == 0) {
                coll05.this.stroke(127.0f, 0.0f, 0.0f);
                coll05.this.fill(255.0f, 0.0f, 0.0f, 127.0f);
            } else if (this.type == 1) {
                coll05.this.stroke(0.0f, 127.0f, 127.0f);
                coll05.this.fill(0.0f, 255.0f, 255.0f, 127.0f);
            }
            coll05.this.ellipse(this.x, this.y, this.r * 2.0f, this.r * 2.0f);
        }

        public void place(float f, float f2, float f3) {
            this.x = f;
            this.y = f2;
            this.a = 1.5707964f;
        }
    }

    class ColBouPol {
        boolean collision;
        float angle;
        float penetration;

        ColBouPol(int n, float[] fArray, float[] fArray2, float f, float f2, float f3) {
            int n2 = 0;
            float f4 = coll05.this.longueur(f, f2, fArray[0], fArray2[0]);
            float f5 = -f4;
            this.angle = coll05.atan2(fArray2[0] - f2, fArray[0] - f);
            int n3 = 0;
            while (n3 < n) {
                float f6 = coll05.this.longueur(f, f2, fArray[n3], fArray2[n3]);
                if (f6 < f4) {
                    n2 = n3;
                    f4 = f6;
                    this.angle = coll05.atan2(fArray2[n2] - f2, fArray[n2] - f);
                    f5 = -f6;
                }
                ++n3;
            }
            n3 = 0;
            while (n3 < n) {
                int n4 = (n3 + 1) % n;
                float f7 = coll05.this.longueur(f, f2, fArray[n3], fArray2[n3]);
                float f8 = coll05.atan2(fArray2[n3] - f2, fArray[n3] - f);
                float f9 = coll05.atan2(fArray2[n3] - fArray2[n4], fArray[n3] - fArray[n4]);
                float f10 = f9 + 1.5707964f;
                float f11 = coll05.cos(f10 - f8) * f7;
                if (coll05.this.iPol(f, f2, fArray, fArray2)) {
                    if (f11 > 0.0f) {
                        f10 += (float)Math.PI;
                        f11 *= -1.0f;
                    }
                } else if (f11 < 0.0f) {
                    f10 += (float)Math.PI;
                    f11 *= -1.0f;
                }
                float f12 = f + coll05.cos(f10 %= (float)Math.PI * 2) * f11;
                float f13 = f2 + coll05.sin(f10) * f11;
                if (coll05.abs(f11) < coll05.abs(f4)) {
                    boolean bl;
                    float f14 = coll05.this.longueur(fArray[n3], fArray2[n3], fArray[n4], fArray2[n4]);
                    boolean bl2 = f14 > coll05.this.longueur(fArray[n3], fArray2[n3], f12, f13);
                    boolean bl3 = bl = f14 > coll05.this.longueur(fArray[n4], fArray2[n4], f12, f13);
                    if (bl2 && bl) {
                        n2 = n3;
                        f4 = f11;
                        f5 = -f11;
                        this.angle = f10;
                    }
                }
                ++n3;
            }
            this.collision = f5 > -f3;
            this.penetration = -(f5 + f3);
        }
    }

    class Level {
        int nb;
        int nbBoules;
        int nbTriangles;
        int nbSorties;
        Boule[] bou;
        Triangle[] tri;
        Sortie[] sor;

        Level(int n) {
            this.nb = n;
        }

        public void setObj() {
            this.bou = new Boule[this.nbBoules];
            this.tri = new Triangle[this.nbTriangles];
            this.sor = new Sortie[this.nbSorties];
            int n = 0;
            while (n < this.nbTriangles) {
                this.tri[n] = new Triangle(n);
                ++n;
            }
            n = 0;
            while (n < this.nbBoules) {
                this.bou[n] = new Boule(n);
                ++n;
            }
            n = 0;
            while (n < this.nbSorties) {
                this.sor[n] = new Sortie(n);
                ++n;
            }
        }
    }

    class Sortie {
        float x;
        float y;
        float r;
        int nb;

        Sortie(int n) {
            this.nb = n;
            this.x = coll05.this.random(coll05.this.sizx);
            this.y = coll05.this.random(coll05.this.sizy);
            this.r = coll05.this.random(10.0f) + 2.0f;
        }

        public void dessine() {
            coll05.this.stroke(127);
            coll05.this.fill(255);
            coll05.this.ellipse(this.x, this.y, this.r * 2.0f, this.r * 2.0f);
        }
    }

    class Triangle {
        int nbCotes = 5;
        int nb;
        float[] x = new float[this.nbCotes];
        float[] y = new float[this.nbCotes];
        int type;

        Triangle(int n) {
            this.nb = n;
            this.type = n % 2 == 0 ? 0 : 1;
            int n2 = 0;
            while (n2 < this.nbCotes) {
                this.x[n2] = coll05.this.random(coll05.this.sizx);
                this.y[n2] = coll05.this.random(coll05.this.sizy * 4.0f / 5.0f);
                ++n2;
            }
        }

        public void agit() {
        }

        public void dessine() {
            coll05.this.noStroke();
            if (this.type == 0) {
                coll05.this.fill(255.0f, 0.0f, 0.0f, 127.0f);
            } else if (this.type == 1) {
                coll05.this.fill(0.0f, 255.0f, 255.0f, 63.0f);
            }
            coll05.this.beginShape();
            int n = 0;
            while (n < this.nbCotes) {
                coll05.this.vertex(this.x[n], this.y[n]);
                ++n;
            }
            coll05.this.endShape();
        }
    }
}

