
int nbSt = 500;
PImage[] ims = new PImage[nbSt];
int stSize=30;
int nbX=20;
int nbY=20;
int[][] rot = new int[nbX][nbY];
int[][] id = new int[nbX][nbY];
int clipboard=0;

void setup() {
  size(nbX*stSize, nbY*stSize);
  for (int i=0;i<nbSt;i++) {
    ims[i]=loadImage(dataPath(nf(i, 3)+".png"));
  }
  for (int x=0;x<nbX;x++) {
    for (int y=0;y<nbY;y++) {
      rot[x][y]=0;
      id[x][y]=nbSt;
    }
  }
}

void draw() {
  background(0);
  for (int x=0;x<nbX;x++) {
    for (int y=0;y<nbY;y++) {
      if (id[x][y]==nbSt) {
        // nothing
      } 
      else {
        pushMatrix();
        translate(x*stSize+stSize/2, y*stSize+stSize/2);
        rotate(rot[x][y]*HALF_PI);
        image(ims[id[x][y]], -stSize/2, -stSize/2);
        popMatrix();
      }
    }
  }
  if (editO) {
    id[cIDX][cIDY]=floor(baseId+((float)mouseY-baseMY)/10);
    int maxi = nbSt+1;
    while (id[cIDX][cIDY]<0 || id[cIDX][cIDY]>=maxi) id[cIDX][cIDY] = (id[cIDX][cIDY]+maxi) % maxi;
    clipboard = id[cIDX][cIDY];
  }
}

int baseMX=0;
int baseMY=0;
int cIDX=0;
int cIDY=0;
int baseId=0;
boolean editO=false;

void mousePressed() {
  int x=floor(mouseX/stSize);
  int y=floor(mouseY/stSize);
  baseMX=mouseX;
  baseMY=mouseY;
  baseId=clipboard;
  cIDX=x;
  cIDY=y;
  if (mouseButton==LEFT) editO=true;
  if (mouseButton==RIGHT) rot[x][y]=(rot[x][y]+1)%(4);
}

void mouseReleased() {
  editO=false;
}

void keyPressed() {
  if (keyCode==ENTER) {
    save("result.png");
    String[] out = new String[nbSt];
    int[] nb = new int[nbSt];
    for (int i=0;i<nbSt;i++) {
      nb[i]=0;
    }
    for (int x=0;x<nbX;x++) {
      for (int y=0;y<nbY;y++) {
        if (id[x][y]<nbSt) nb[id[x][y]]++;
      }
    }
    for (int i=0;i<nbSt;i++) out[i] = str(nb[i]);
    saveStrings("out.txt", out);
  }
  if (keyCode==DELETE) {
    id[cIDX][cIDY]=nbSt;
  }
  if (keyCode==RIGHT) {
    int tmpId = id[(cIDX+1)%nbX][cIDY];
    id[(cIDX+1)%nbX][cIDY] = id[cIDX][cIDY];
    id[cIDX][cIDY] = tmpId;
    cIDX=(cIDX+1+nbX)%nbX;
  }  
  if (keyCode==LEFT) {
    int tmpId = id[(cIDX-1+nbX)%nbX][cIDY];
    id[(cIDX-1+nbX)%nbX][cIDY] = id[cIDX][cIDY];
    id[cIDX][cIDY] = tmpId;
    cIDX=(cIDX-1+nbX)%nbX;
  }  
  if (keyCode==DOWN) {
    int tmpId = id[cIDX][(cIDY+1)%nbY];
    id[cIDX][(cIDY+1)%nbY] = id[cIDX][cIDY];
    id[cIDX][cIDY] = tmpId;
    cIDY=(cIDY+1+nbY)%nbY;
  }  
  if (keyCode==UP) {
    int tmpId = id[cIDX][(cIDY-1+nbY)%nbY];
    id[cIDX][(cIDY-1+nbY)%nbY] = id[cIDX][cIDY];
    id[cIDX][cIDY] = tmpId;
    cIDY=(cIDY-1+nbY)%nbY;
  }
}

