
int nbSt = 500;
Tile[][] ims = new Tile[nbSt][nbSt];
int stSize=30;
int nbX=20;
int nbY=20;
int[][] rot = new int[nbX][nbY];
PVector[][] id = new PVector[nbX][nbY];
PVector clipboard = new PVector(0, 0);

int[] kernel = {
  -1, 0, 
  0, -1, 
  1, 0, 
  0, 1
};

int[] kernelPourLeFiltre = {
  -1, -1, +0, -1, +1, -1, 
  -1, +0, +0, +0, +1, +0, 
  -1, +1, +0, +1, +1, +1
};

float[] kernelSharpen = {
  -1, -1, -1, 
  -1, +9, -1, 
  -1, -1, -1
};

float divSharpFactor = 5.0/5.0;

boolean isFilter = false;

PVector[][] crouteBuffer;

PGraphics PGTemp;

class Tile {
  public color c1;
  public color c2;
  public color c3;
  public color c4;  
  Tile (color c1, color c2, color c3, color c4) {
    this.c1=c1;
    this.c2=c2;
    this.c3=c3;
    this.c4=c4;
  }
}

void setup() {
  size(nbX*stSize, nbY*stSize);
  colorMode(HSB);
  PGTemp = createGraphics(width, height, P2D);
  crouteBuffer = new PVector[nbX * nbY][2];
  MitRomney(crouteBuffer);

  color[][] baseC = new color[ceil(nbSt/2)+1][ceil(nbSt/2)+1];

  for (int x=0;x<ceil(nbSt/2)+1;x++) {
    for (int y=0;y<ceil(nbSt/2)+1;y++) {
      baseC[x][y] = color((x*7+y*8)%0xFF, (x*9+y*10)%0xFF, (x*11+y*12)%0xFF);
    }
  }

  for (int x=0;x<nbSt;x++) {
    for (int y=0;y<nbSt;y++) {
      if (x%2==0) {
        if (y%2==0) {
          // TODO
        } 
        else {
          // TODO
        }
      } 
      else {
        if (y%2==0) {
          // TODO
        } 
        else {
          // TODO
        }
      }
      ims[x][y] = new Tile(
      baseC[floor(x/2)][floor(y/2)], 
      baseC[floor(x/2)][floor((y+1)/2)], 
      baseC[floor((x+1)/2)][floor(y/2)], 
      baseC[floor((x+1)/2)][floor((y+1)/2)]);
    }
  }

  for (int x=0;x<nbX;x++) {
    for (int y=0;y<nbY;y++) {      
      rot[x][y] = 0;
      id[x][y] = new PVector(nbSt, nbSt);
    }
  }
}

void draw() {
  background(0);
  PGTemp.beginDraw();
  PGTemp.background(0);
  for (int x=0;x<nbX;x++) {
    for (int y=0;y<nbY;y++) {
      if (id[x][y].x==nbSt || id[x][y].y==nbSt) {
        // nothing
      } 
      else {
        PGTemp.pushMatrix();
        PGTemp.translate(x*stSize+stSize/2, y*stSize+stSize/2);
        PGTemp.rotate(rot[x][y]*HALF_PI);
        PGTemp.noStroke();
        PGTemp.fill(ims[(int)id[x][y].x][(int)id[x][y].y].c1);
        PGTemp.triangle(-stSize/2, -stSize/2, 0, 0, stSize/2, -stSize/2);
        PGTemp.fill(ims[(int)id[x][y].x][(int)id[x][y].y].c2);
        PGTemp.triangle( stSize/2, -stSize/2, 0, 0, stSize/2, stSize/2);
        PGTemp.fill(ims[(int)id[x][y].x][(int)id[x][y].y].c3);
        PGTemp.triangle( stSize/2, stSize/2, 0, 0, -stSize/2, stSize/2);
        PGTemp.fill(ims[(int)id[x][y].x][(int)id[x][y].y].c4);
        PGTemp.triangle(-stSize/2, stSize/2, 0, 0, -stSize/2, -stSize/2);
        PGTemp.popMatrix();
      }
    }
  }
  if (editO) {
    id[cIDX][cIDY] = new PVector(floor(baseId.x+((float)mouseX-baseMX)/10), floor(baseId.y+((float)mouseY-baseMY)/10));
    int maxi = nbSt+1;
    while (id[cIDX][cIDY].x<0 || id[cIDX][cIDY].y<0 || id[cIDX][cIDY].x>=maxi || id[cIDX][cIDY].y>=maxi) {
      id[cIDX][cIDY].x = (id[cIDX][cIDY].x+maxi) % maxi;
      id[cIDX][cIDY].y = (id[cIDX][cIDY].y+maxi) % maxi;
    }
    clipboard = id[cIDX][cIDY];
  }
  PGTemp.endDraw();

  if (isFilter)
  {
    loadPixels();
    PGTemp.loadPixels();
    for (int x = 0; x < width; ++x)
    {
      for (int y = 0; y < height; ++y)
      {        
        float sumR = 0;
        float sumG = 0;
        float sumB = 0;
        for (int k = 0; k < kernelPourLeFiltre.length; k+=2)
        {
          int dx = constrain(x + kernelPourLeFiltre[k + 0], 0, width - 1);
          int dy = constrain(y + kernelPourLeFiltre[k + 1], 0, height - 1);
          color aroundColor = PGTemp.pixels[dy * width + dx];
          sumR += red(aroundColor) * kernelSharpen[k/2];
          sumG += green(aroundColor) * kernelSharpen[k/2];
          sumB += blue(aroundColor) * kernelSharpen[k/2];
        }
        pixels[y * width + x] = color(constrain(sumR*divSharpFactor, 0, 255), 
        constrain(sumG*divSharpFactor, 0, 255), 
        constrain(sumB*divSharpFactor, 0, 255));
      }
    }  
    updatePixels();
    PGTemp.updatePixels();
  }
  else
  {
    image(PGTemp, 0, 0);
  }
}

int baseMX=0;
int baseMY=0;
int cIDX=0;
int cIDY=0;
PVector baseId = new PVector(0, 0);
boolean editO=false;

void mousePressed() {
  int x=floor(mouseX/stSize);
  int y=floor(mouseY/stSize);
  baseMX=mouseX;
  baseMY=mouseY;
  baseId=clipboard;
  cIDX=x;
  cIDY=y;
  if (mouseButton==LEFT) editO=true;
  if (mouseButton==RIGHT) {
    rot[x][y]=(rot[x][y]+1)%(4);
    clipboard = id[x][y];
  }
}

void mouseReleased() {
  editO=false;
}

void keyPressed() {
  if (keyCode==ENTER) {
    save("result.png");
  }
  if (keyCode==DELETE) {
    id[cIDX][cIDY]=new PVector(nbSt, nbSt);
  }
  if (keyCode==RIGHT) {
    PVector tmpId = id[(cIDX+1)%nbX][cIDY];
    id[(cIDX+1)%nbX][cIDY] = id[cIDX][cIDY];
    id[cIDX][cIDY] = tmpId;
    cIDX=(cIDX+1+nbX)%nbX;
  }  
  if (keyCode==LEFT) {
    PVector tmpId = id[(cIDX-1+nbX)%nbX][cIDY];
    id[(cIDX-1+nbX)%nbX][cIDY] = id[cIDX][cIDY];
    id[cIDX][cIDY] = tmpId;
    cIDX=(cIDX-1+nbX)%nbX;
  }  
  if (keyCode==DOWN) {
    PVector tmpId = id[cIDX][(cIDY+1)%nbY];
    id[cIDX][(cIDY+1)%nbY] = id[cIDX][cIDY];
    id[cIDX][cIDY] = tmpId;
    cIDY=(cIDY+1+nbY)%nbY;
  }  
  if (keyCode==UP) {
    PVector tmpId = id[cIDX][(cIDY-1+nbY)%nbY];
    id[cIDX][(cIDY-1+nbY)%nbY] = id[cIDX][cIDY];
    id[cIDX][cIDY] = tmpId;
    cIDY=(cIDY-1+nbY)%nbY;
  }
  if (key == 'A' || key == 'a')
  {
    MitRomney(crouteBuffer);
    InitialiseWithMitRomney();
  }
  if (key == 'F' || key == 'f')
  {
    isFilter = !isFilter;
  }
}

void InitialiseWithMitRomney()
{
  for (int x=0;x<nbX;x++) {
    for (int y=0;y<nbY;y++) {
      int meOU = y * nbX + x;      
      rot[x][y] = (int)crouteBuffer[meOU][0].x;
      id[x][y] = crouteBuffer[meOU][1];
    }
  }
}

void MitRomney(PVector[][] buffer)
{
  for (int j = 0; j < buffer.length; ++j)
  {
    buffer[j][0] = new PVector(0, 0);
    buffer[j][1] = new PVector(500, 500);
  }

  int RandomBGNumber = 16;
  int startIndex = (int)random(0, 124);
  startIndex *= 4;  

  println("/-----------------------------------------------------------------------------------------/");
  println("start : " + startIndex);

  for (int rd = 0; rd < RandomBGNumber; ++rd)
  {    
    int cx = (int)random(0, nbX);
    int cy = (int)random(0, nbY);
    if (buffer[cy * nbX + cx][1].x == 500)
    {
      buffer[cy * nbX + cx][1].x = startIndex + (rd%2)*2;
      buffer[cy * nbX + cx][1].y = buffer[cy * nbX + cx][1].x + (rd%8);
    }
    else
    {
      rd--;
    }
  }

  //copie du buffet
  PVector[][] tempBuffer = new PVector[buffer.length][2];
  CopyMitRomney(buffer, tempBuffer);
  int emptyCell = nbX * nbY;
  int it = 0;  

  while (emptyCell > 0)
  {
    it++;
    emptyCell = nbX * nbY;

    for (int x = 0; x < nbX; ++x)
    { 
      for (int y = 0; y < nbY; ++y)
      { 
        int meOU = y * nbX + x;  
        if (buffer[meOU][1].x != 500)
        {
          emptyCell--;
          for (int a = 0; a < kernel.length; a += 2)
          {
            int extX = ((x + kernel[a + 0]) + nbX) % nbX;
            int extY = ((y + kernel[a + 1]) + nbY) % nbY;

            if (random(0.00, 1.00) > 0.8 && buffer[extY * nbX + extX][1].x == 500)
            {
              tempBuffer[extY * nbX + extX][1] = buffer[meOU][1];
            }
          }
        }
      }
    }
    //println("buffer : " + emptyCell + ", iteration : " + it);
    CopyMitRomney(tempBuffer, buffer);
  }
  //diagonal
  for (int x = 0; x < nbX; ++x)
  {
    for (int y = 0; y < nbY; ++y)
    {      
      int meOU = y * nbX + x;
      if (tempBuffer[meOU][1].x == startIndex)
      {
        int[] shem = {
          0, 0, 0, 0
        };
        for (int a = 0; a < kernel.length / 2; a++)
        {
          int extX = x + kernel[a * 2 + 0];
          int extY = y + kernel[a * 2 + 1];

          if (extX >= 0 && extX < nbX && extY >= 0 && extY < nbY)
          {
            if (tempBuffer[extY * nbX + extX][1].x == startIndex)
            {
              shem[a] = 0;
            }
            else
            {
              shem[a] = 1;
            }
          }
        }
        //println("shem : " + shem[0] + ", " + shem[1] + ", " + shem[2] + ", " + shem[3]);
        if (shem[0] == 1 && shem[1] == 1 && shem[2] != 1 && shem[3] != 1)
        {
          buffer[meOU][1].x = startIndex + 1;
          buffer[meOU][0].x = 2;
          //println("A");
        }
        if (shem[0] != 1 && shem[1] == 1 && shem[2] == 1 && shem[3] != 1)
        {
          buffer[meOU][1].x = startIndex + 1;
          buffer[meOU][0].x = 3;
          //println("B");
        }
        if (shem[0] != 1 && shem[1] != 1 && shem[2] == 1 && shem[3] == 1)
        {
          buffer[meOU][1].x = startIndex + 1;
          buffer[meOU][0].x = 0;
          //println("C");
        }
        if (shem[0] == 1 && shem[1] != 1 && shem[2] != 1 && shem[3] == 1)
        {
          buffer[meOU][1].x = startIndex + 1;
          buffer[meOU][0].x = 1;
          //println("D");
        }
      }
    }
  }

  int youssoundourRamequinMax = (int)constrain(random(-1, 12), 0, 5);
  for (int i = 0; i < youssoundourRamequinMax; ++i)
  {
    float a = random(0.00, 1.00);
    if (a < 0.3333)
    {
      Youssoundour(buffer);
    }
    else if (a > 0.6666)
    {
      Ramequin(buffer);
    }
  }
}

void Ramequin(PVector[][] buffer)
{
  int xpos = (int)random(0, nbX);
  int ypos = (int)random(0, nbY);
  int colorOffset = (int)(buffer[ypos * nbX + xpos][1].x / 2);
  colorOffset = colorOffset * 2;
  if (random(0.00, 1.00) > 0.5)
  {
    colorOffset = (int)random(0, 249);
    colorOffset *= 2;
  }
  int[] idRamequins = {
    ypos * nbX + xpos, 
    ypos * nbX + ((xpos + 1) % nbX), 
    ((ypos+1) % nbY) * nbX + ((xpos + 1) % nbX), 
    ((ypos+1) % nbY) * nbX + xpos
  };

  int[][] motifs = {
    {
      0, 1, 2, 3
    }
    , {
      1, 0, 3, 2
    }
    , {
      1, 0, 2, 3
    }
  };

  buffer[idRamequins[0]][1].x = colorOffset + 1;
  buffer[idRamequins[1]][1].x = colorOffset + 1;
  buffer[idRamequins[2]][1].x = colorOffset + 1;
  buffer[idRamequins[3]][1].x = colorOffset + 1;

  int offsetRotation = (int)random(0, 4);
  int motif = (int)random(0, 3);
  buffer[idRamequins[0]][0].x = motifs[motif][0] + offsetRotation;
  buffer[idRamequins[1]][0].x = motifs[motif][1] + offsetRotation;
  buffer[idRamequins[2]][0].x = motifs[motif][2] + offsetRotation;
  buffer[idRamequins[3]][0].x = motifs[motif][3] + offsetRotation;
}

void Youssoundour(PVector[][] buffer)
{  
  int sSize = (int)random(1, 4);
  int hSize = (int)random(4, nbY);
  int sNbX = nbY;
  int sNbY = nbX;
  int xpos = (int)random(0, nbX);
  int ypos = (int)random(0, nbY);
  int colorOffset = (int)random(0, 125);

  boolean orientation = false;

  if (random(0.00, 1.00) >= 0.5)
  {
    sNbX = nbX;
    sNbY = nbY;
    hSize = (int)random(4, nbX);
    xpos = (int)random(0, nbY);
    ypos = (int)random(0, nbX);
    orientation = true;
  }
  int cf = 0;
  if (random(0.00, 1.00) >= 0.5)
  {
    cf = 2;
  }

  for (int x = 0; x < sSize; ++x)
  {
    for (int y = 0; y < hSize; ++y)
    {
      int ix = (x+xpos) % sNbX;
      int iy = (y+ypos) % sNbY;
      int meOU;
      if (!orientation)
      {
        meOU = iy * sNbX + ix;
      }
      else
      {
        meOU = ix * sNbY + iy;
      }
      buffer[meOU][1].x = (buffer[meOU][1].x + colorOffset * 4 + cf) % 500;
    }
  }
}

void CopyMitRomney(PVector[][] from, PVector[][] to)
{  
  for (int i = 0; i < to.length; ++i)
  {
    for (int j = 0; j < to[i].length; ++j)
    {
      to[i][j] = from[i][j];
    }
  }
}

