
abstract class Behaviour {
  Member member;
  void setPic(PImage pic) {
  }
  void extract(color backColor, float threshold) {
  }
  void draw() {
  }
  void move() {
  }
  void setPosition(float x, float y, float w, float h) {
  }
  PVector getPosition() {
    return null;
  }
  void setAnchor(Member grabbed, int grabbedIndex, int grabberIndex) {
  }
  void setAnchors(PVector[] anchors) {
  }
  PVector getAnchor(int i) {
    return null;
  }
  void setInertia(float inertia) {
  }
  void rotatePic(float rot) {
  }
  void transformPic(int type) {
  }
  void setRotation(float rot) {
  }
  void setBaseRotation(float rot) {
  }
  void setRelativeRotation(boolean b) {
  }
  Float getRotation() {
    return null;
  }
  void setDirection(PVector dir) {
  }
  PVector getDirection() {
    return null;
  }
  PVector[] getAnchors() {
    return null;
  }
  void setParallax(float p) {
  }
  void commitSize() {
  }
  void scalePic(float s) {
  }
  ArrayList<Member> generateLevelObjects() {
    return null;
  }
  boolean hasCollisionMask() {
    return false;
  }
  void computeRadius() {
  }
  Float getCollisionRadius() {
    return null;
  }
  void setCollisionsChecks(boolean a, boolean b) {
  }
  void setGravityAmount(float g) {
  }
  void exportData() {
  }
  void setRadius(float radius) {
  }
  boolean isCollidingWith(Member m) {
    return false;
  }
}

class B_drawn extends Behaviour {
  B_drawn(Member member) {
    this.member=member;
  }
  void setPic(PImage pic) {
    this.member.pic = pic;
  }
}

class B_background extends Behaviour {
  PVector pos = new PVector();
  PVector coverSize = new PVector();
  float parallax=1;
  B_background(Member member) {
    this.member=member;
  }
  void draw() {
    pushMatrix();
    translate(-cameraPosition.x*(1-parallax), -cameraPosition.y*(1-parallax));
    float thisCameraZoom = 1 + (cameraZoom-1) * (1-parallax);
    PVector screenSize = new PVector(coverSize.x/thisCameraZoom, coverSize.y/thisCameraZoom);
    copy(member.pic, 0, 0, floor(member.pic.width/thisCameraZoom), floor(member.pic.height/thisCameraZoom), floor(pos.x*thisCameraZoom), floor(pos.y*thisCameraZoom), floor(screenSize.x*thisCameraZoom), floor(screenSize.y*thisCameraZoom));
    popMatrix();
  }
  void setPosition(float x, float y, float w, float h) {
    pos.x=x;
    pos.y=y;
    coverSize.x=w;
    coverSize.y=h;
  }
  PVector getPosition() {
    return pos;
  };
  void setParallax(float p) {
    this.parallax=p;
  }
}

class B_articulation extends Behaviour {
  PVector pos = new PVector();
  PVector[] anchor;
  float rotation = 0;
  float baseRotation = 0;
  int grabberIndex = 0;
  float parallax=0;
  B_articulation(Member member) {
    this.member=member;
  }
  void draw() {
    pushMatrix();
    translate(-cameraPosition.x*(1-parallax), -cameraPosition.y*(1-parallax));
    scale(cameraZoom);
    pushMatrix();
    translate(pos.x+anchor[grabberIndex].x, pos.y+anchor[grabberIndex].y);
    rotate(rotation);
    translate(-pos.x-anchor[grabberIndex].x, -pos.y-anchor[grabberIndex].y);
    image(member.pic, pos.x, pos.y);
    popMatrix();
    // show anchors
    /*
    stroke(0);
     fill(0xFF);
     for (int i=0;i<anchor.length;i++) ellipse(pos.x+getAnchor(i).x, pos.y+getAnchor(i).y, 5, 5);
     */
    popMatrix();
  }
  void move() {
  }
  void setPosition(float x, float y, float w, float h) {
    pos.x=x;
    pos.y=y;
  }
  PVector getPosition() {
    return pos;
  };  
  PVector getAnchor(int i) {
    if (anchor.length>i) {
      if (anchor[i]!=null) {
        float distance = dist(anchor[grabberIndex].x, anchor[grabberIndex].y, anchor[i].x, anchor[i].y);
        float angle = atan2(anchor[grabberIndex].y-anchor[i].y, anchor[grabberIndex].x-anchor[i].x)+PI;
        return new PVector(anchor[grabberIndex].x+distance*cos(angle+rotation), anchor[grabberIndex].y+distance*sin(angle+rotation));
      }
    }
    return null;
  }
  void setRotation(float rot) {
    rotation = rot;
  }
  void setBaseRotation(float rot) {
    baseRotation = rot;
  }
  Float getRotation() {
    return new Float(rotation);
  }
  PVector[] getAnchors() {
    return anchor;
  };
  void setAnchors(PVector[] anchor) {
    this.anchor = anchor;
  };   
  void setParallax(float p) {
    this.parallax=p;
  }
}

class B_mouseFollower extends B_articulation {
  B_mouseFollower(Member member) {
    super(member);
  }
  void move() {
    rotation = baseRotation;
    pos.x=mouseX-getAnchor(grabberIndex).x;
    pos.y=mouseY-getAnchor(grabberIndex).y;
  }
}

class B_gravity extends B_articulation {
  PVector dir = new PVector(0, 0);
  float airFriction = 0.001;
  float gravityAmount=1;
  B_gravity(Member member) {
    super(member);
  }
  void move() {
    pos.x+=dir.x;
    pos.y+=dir.y;
    dir.y+=gravityAmount;
    // friction
    dir.y*=1-airFriction;
    dir.x*=1-airFriction;
    rotation += (dir.x)/200;
    rotation /= 1.5;
  }
  void setDirection(PVector dir) {
    this.dir=dir;
  }
  PVector getDirection() {
    return dir;
  }
  void setGravityAmount(float g) {
    gravityAmount=g;
  }
}

class B_collider extends Behaviour {
  boolean boundaries;
  boolean masks;
  B_collider(Member member) {
    this.member=member;
  }
  void move() {
    // collide with borders of the world
    if (boundaries) {
      int precision =1;
      for (int i=0;i<min(member.getAnchors().length,precision);i++) {
        PVector pos = new PVector(member.getPosition().x + member.getAnchor(i).x, member.getPosition().y + member.getAnchor(i).y);
        if (pos.x<0||pos.x>worldBoundaries.x||pos.y<0||pos.y>worldBoundaries.y) {
          alertCrossWorldBoundaries(member, new PVector(min(0, pos.x)+max(pos.x-worldBoundaries.x, 0), min(0, pos.y)+max(pos.y-worldBoundaries.y, 0)));
        }
      }
    }
    // collide with other objects
    if (masks) {
      for (int m=0;m<members.size();m++) {
        if (members.get(m).hasCollisionMask()) {
          if (members.get(m).getAnchors()!=null) {
            if (isCollidingWith(members.get(m))) alertCollision(member, members.get(m));
          }
        }
      }
    }
  }
  boolean isCollidingWith(Member m) {
    PVector aPos = new PVector(member.getPosition().x + member.getAnchor(0).x, member.getPosition().y + member.getAnchor(0).y);
    PVector bPos = new PVector(m.getPosition().x + m.getAnchor(0).x, m.getPosition().y + m.getAnchor(0).y);
    if (member.hasCollisionMask()) {
      if (PVector.dist(aPos, bPos)<m.getCollisionRadius()+member.getCollisionRadius()) {
        return true;
      }
    }
    else {
      if (PVector.dist(aPos, bPos)<m.getCollisionRadius()) {
        return true;
      }
    }
    return false;
  }
  void setCollisionsChecks(boolean boundaries, boolean masks) {
    this.boundaries=boundaries;
    this.masks=masks;
  }
}

class B_collisionMaskCircle extends Behaviour {
  float radius;
  B_collisionMaskCircle(Member member) {
    this.member=member;
  }
  boolean hasCollisionMask() {
    return true;
  }
  void draw() {
    // show mask
    /*
    pushMatrix();
     translate(-cameraPosition.x, -cameraPosition.y);
     scale(cameraZoom);
     noFill();
     stroke(0, 0xFF, 0);
     strokeWeight(3);
     ellipse(member.getPosition().x + member.getAnchor(0).x, member.getPosition().y + member.getAnchor(0).y, radius*2, radius*2);
     popMatrix();
     */
  }
  Float getCollisionRadius() {
    return new Float(radius);
  }
  void setRadius(float radius) {
    this.radius=radius;
  }
}

class B_articulationGrabber extends B_articulation {
  Member grabbed;
  int grabbedIndex = 0;
  float inertiaTr = 0.01f;
  boolean relativeRotation = false;
  B_articulationGrabber(Member member) {
    super(member);
  }
  void move() {
    PVector grabbedPos = new PVector(grabbed.getPosition().x+grabbed.getAnchor(grabbedIndex).x, grabbed.getPosition().y+grabbed.getAnchor(grabbedIndex).y);
    float builtRotation = atan2(getAnchor(0).y-getAnchor(grabberIndex).y, getAnchor(0).x-getAnchor(grabberIndex).x);
    float newRotation = atan2((pos.y+getAnchor(0).y)-grabbedPos.y, (pos.x+getAnchor(0).x)-grabbedPos.x) - builtRotation + baseRotation;
    if (relativeRotation) newRotation += grabbed.getRotation();
    rotation += vrMax(rotation, newRotation, TWO_PI)/2;
    pos.x = pos.x*inertiaTr + (grabbedPos.x-anchor[grabberIndex].x)*(1-inertiaTr);
    pos.y = pos.y*inertiaTr + (grabbedPos.y-anchor[grabberIndex].y)*(1-inertiaTr);
  }
  void setAnchor(Member grabbed, int grabbedIndex, int grabberIndex) {
    this.grabbed = grabbed;
    this.grabberIndex = grabberIndex;
    this.grabbedIndex = grabbedIndex;
  }
  void setInertia(float inertia) {
    inertiaTr=inertia;
  };
  void setRelativeRotation(boolean b) {
    relativeRotation=b;
  };
}

class B_level extends Behaviour {
  int levelW=10;
  int levelH=50;
  B_level(Member member) {
    this.member=member;
  }
  ArrayList<Member> generateLevelObjects() {
    ArrayList<Member> objects = new ArrayList<Member>();
    PImage levelPic = member.pic.get();
    levelPic.resize(levelW, levelH);
    int[][] levelTiles = new int[levelW][levelH];
    for (int x=0;x<levelW;x++) {
      for (int y=0;y<levelH;y++) {
        color thisColor = levelPic.get(x, y);
        if (brightness(thisColor)<250) {
          Member block = new Member(member.parent, "block");
          block.behaviours.add(new B_drawn(block));
          block.behaviours.add(new B_collisionMaskCircle(block));
          float[] amounts =  new float[3];
          float thisHue = hue(thisColor);
          amounts[0]=abs(vrMax(thisHue, 238, 256));
          amounts[1]=abs(vrMax(thisHue, 157, 256));
          amounts[2]=abs(vrMax(thisHue, 38, 256));
          String tag="generic";
          if (amounts[0]<amounts[1]&&amounts[0]<amounts[2]) {
            tag="fire";
            block.behaviours.add(new B_articulation(block));
          }
          if (amounts[1]<amounts[0]&&amounts[1]<amounts[2]) {
            tag="block";
            block.behaviours.add(new B_articulation(block));
          }
          if (amounts[2]<amounts[0]&&amounts[2]<amounts[1]) {
            tag="ring";
            block.behaviours.add(new B_gravity(block));
            block.setGravityAmount(0);
            block.behaviours.add(new B_collider(block));
            block.setCollisionsChecks(true, true);
          }
          block.setPosition(x*worldBoundaries.x/levelW, y*worldBoundaries.y/levelH, 0, 0);
          block.setDirection(new PVector(0, 0));
          block.tags.add(tag);
          objects.add(block);
        }
      }
    }
    return objects;
  }
}

