
class Extractor {
  String name;
  PImage picture;
  PVector[] anchor = new PVector[0];
  float radius;
  int type;//0=backgrounds 1=articulations
  Extractor() {
  }
  void setPic(PImage pic, int x, int y, int xB, int yB, int type, String name) {
    int w=xB-x;
    int h=yB-y;
    picture = createImage(w, h, ARGB);
    for (int x2=0 ; x2<pic.width ; x2++) {
      for (int y2=0 ; y2<pic.height ; y2++) {
        picture.set(x2, y2, pic.get(x2+x, y2+y));
      }
    }
    this.type=type;
    this.name=name;
  }
  void extract(color backColor, float threshold) {
    PImage pic = picture;
    PVector boundaryTL= new PVector(pic.width, pic.height);
    PVector boundaryBR= new PVector(0, 0);
    pic.loadPixels();
    boolean[][] shape = new boolean[pic.width][pic.height];
    for (int x=0 ; x<pic.width ; x++) {
      for (int y=0 ; y<pic.height ; y++) {
        shape[x][y] = !(colorDifference(pic.pixels[x + y * pic.width], backColor)<threshold);
      }
    }
    int nbExtensions = 3;
    for (int i=0;i<nbExtensions;i++) {
      boolean[][] extendedShape = new boolean[pic.width][pic.height];
      for (int x=0 ; x<pic.width ; x++) {
        for (int y=0 ; y<pic.height ; y++) {
          extendedShape[x][y] = (x>0&&x<pic.width-1&&y>0&&y<pic.height-1) ? shape[x+1][y] & shape[x+1][y] & shape[x][y-1] & shape[x][y+1] : false;
        }
      }
      shape = extendedShape;
    }
    for (int x=0 ; x<pic.width ; x++) {
      for (int y=0 ; y<pic.height ; y++) {
        if (!shape[x][y]) {
          int loc = x + y * pic.width;
          pic.pixels[loc] = pic.pixels[loc] & 0x00FFFFFF;
        } 
        else {
          boundaryTL.x=min(boundaryTL.x, x);
          boundaryTL.y=min(boundaryTL.y, y);
          boundaryBR.x=max(boundaryBR.x, x);
          boundaryBR.y=max(boundaryBR.y, y);
        }
      }
    }
    pic.updatePixels();
    PImage tempPic = createImage((int)boundaryBR.x-(int)boundaryTL.x, (int)boundaryBR.y-(int)boundaryTL.y, ARGB);
    for (int x=0 ; x<tempPic.width ; x++) {
      for (int y=0 ; y<tempPic.height ; y++) {
        tempPic.set(x, y, pic.get((int)boundaryTL.x+x, (int)boundaryTL.y+y));
      }
    }
    this.picture = tempPic;
    if (type==0) extractForBackground(backColor, threshold);
    if (type==1) extractForArticulation(backColor, threshold);
  }
  void transformPic(int type) {
    if (type==1) {
      PImage tmpPic = createImage(this.picture.width, this.picture.height, ARGB);
      for (int x=0;x<this.picture.width;x++) {
        for (int y=0;y<this.picture.height;y++) {
          tmpPic.set(x, y, this.picture.get(this.picture.width-x-1, y));
        }
      }
      this.picture=tmpPic;
    }
  }
  void scalePic(float s) {
    this.picture.resize(floor(this.picture.width*s), floor(this.picture.height*s));
  }
  void extractForBackground(color backColor, float threshold) {
    PImage pic = this.picture;
    color current = pic.get(pic.width-1, pic.height-1);
    for (int y=0 ; y<pic.height ; y++) {
      for (int x=0 ; x<pic.width ; x++) {
        if (alpha(pic.get(x, y))==0) {
          pic.set(x, y, current);
        }
        else {
          current = pic.get(x, y);
        }
      }
    }
  }
  void extractForArticulation(color backColor, float threshold) {
    PImage pic = this.picture;
    int topY=pic.height;
    int bottomY=0;
    for (int y=0 ; y<pic.height ; y++) {
      boolean someShapeHere = false;
      for (int x=0 ; x<pic.width ; x++) {
        if (alpha(pic.get(x, y))>0) {
          someShapeHere=true;
        }
      }
      if (someShapeHere) {
        topY = y<topY ? y : topY;
        bottomY = y>bottomY ? y : bottomY;
      }
    } 
    anchor = new PVector[13];
    int TLX=pic.width;
    int TRX=0;
    int BLX=pic.width;
    int BRX=0;
    for (int x=0;x<pic.width;x++) {
      if (alpha(pic.get(x, topY))>0) {
        TLX = x<TLX ? x : TLX;
        TRX = x>TRX ? x : TRX;
      }      
      if (alpha(pic.get(x, bottomY))>0) {
        BLX = x<BLX ? x : BLX;
        BRX = x>BRX ? x : BRX;
      }
    }
    anchor[0] = new PVector((float)pic.width/2, (float)pic.height/2);// center
    anchor[1] = new PVector(((float)TLX+TRX)/2.0f, topY);// top center
    anchor[2] = new PVector(((float)BLX+BRX)/2.0f, bottomY);// bottom center
    anchor[3] = new PVector(((float)TLX+BLX)/2.0f, topY+bottomY/2.0f);// left center
    anchor[4] = new PVector(((float)TRX+BRX)/2.0f, topY+bottomY/2.0f);// right center
    anchor[5] = new PVector(((float)TLX+BLX)/2.0f, topY+bottomY/5.0f);// left arm
    anchor[6] = new PVector(((float)TRX+BRX)/2.0f, topY+bottomY/5.0f);// right arm
    anchor[7] = new PVector(BRX+((float)BLX-BRX)/5.0f, bottomY);// right leg
    anchor[8] = new PVector(BLX-((float)BLX-BRX)/5.0f, bottomY);// left leg
    for (int i=0;i<4;i++) {
      float thisAngle = ((float)i)*TWO_PI/4;
      boolean found=false;
      for (int le=pic.width+pic.height;le>=0&&!found;le--) {
        PVector thisPos = new PVector(anchor[0].x+cos(thisAngle)*le, anchor[0].y+sin(thisAngle)*le);
        if (round(thisPos.x)>=0&&round(thisPos.x)<pic.width&&round(thisPos.y)>=0&&round(thisPos.y)<pic.height) {
          if (alpha(pic.get(round(thisPos.x), round(thisPos.y)))>0 || le==0) {
            found=true;
            if (i==0) anchor[10]=thisPos;// top left
            if (i==1) anchor[9]=thisPos;// top right 
            if (i==2) anchor[11]=thisPos;// bottom left
            if (i==3) anchor[12]=thisPos;// bottom right
          }
        }
      }
    }
  }  
  void commitSize(PVector coverSize) {
    float scale = 1;
    PImage newPic = createImage(floor(coverSize.x/scale), floor(coverSize.y/scale), RGB);
    for (int x=0;x<newPic.width;x+=this.picture.width) {
      for (int y=0;y<newPic.height;y+=this.picture.height) {
        PVector cropped = new PVector(min(this.picture.width, coverSize.x-x), min(this.picture.height, coverSize.y-y));
        newPic.copy(this.picture, 0, 0, floor(cropped.x), floor(cropped.y), x, y, floor(cropped.x), floor(cropped.y));
      }
    }
    this.picture = newPic;
  }
  void computeRadius() {
    radius=0;
    PVector[] anchors = this.anchor;
    for (int i=9;i<13;i++) {
      radius += PVector.dist(anchors[0], anchors[i])/4;
    }
  }
  void exportData() {
    picture.save(dataPath("export/"+name+".png"));
    if (anchor.length>0) {
      String[] anchorsTxt = new String[13*2];
      for (int i=0;i<13;i+=1) {
        anchorsTxt[i*2] = str(anchor[i].x);
        anchorsTxt[i*2+1] = str(anchor[i].y);
      }
      saveStrings(dataPath("export/"+name+"Anchors.txt"), anchorsTxt);
    }
  }
}

