
import processing.video.*;

ArrayList<Member> members = new ArrayList<Member>();

Capture cam, camHead;

boolean gameLoaded = false;

PImage picModel;

boolean useCam = false;

int gamePhase = 1;
int lifes;
int timer;
// 0 = menu
// 1 = attente de tir
// 2 = en mouvement
Member body;

PImage planche, headPic;
boolean picturesStartedLoading=false;

void setup() {
  size(1000, 800);
  colorMode(RGB);
  frameRate(25);
  if (useCam) {
    String[] cameras = Capture.list();
    println(cameras);
    cam = new Capture(this, cameras[0]);
    cam.start();
    camHead = new Capture(this, cameras[88]);
    camHead.start();
  }
}

PVector worldBoundaries = new PVector(2000, 10000);
PVector cameraPosition = new PVector(0, 0);
float cameraZoom = 0.5f;
float minCameraZoom = 0.3;
float cameraZoomTarget = 1;
void draw() {
  if (gameLoaded) {
    if (gamePhase==0) {
      background(0, 0, 0xFF);
      text(lifes+" points", width/2, height/2);
      text(timer+" timer", 50, 150);
    }
    else {
      setNewZoom(cameraZoom*29/30+cameraZoomTarget*1/30);
      cameraZoomTarget = constrain(cameraZoomTarget*0.95, minCameraZoom, 1);
      background(0, 0, 0xFF);
      tint(0xFF, 0xFF, 0xFF, 0xFF);
      for (int i=0;i<members.size();i++) members.get(i).move();
      cameraPosition.x = (cameraPosition.x)*9/10+(body.getPosition().x*cameraZoom-width/2)*1/10;
      cameraPosition.y = (cameraPosition.y)*9/10+(body.getPosition().y*cameraZoom-height/2)*1/10;
      for (int i=0;i<members.size();i++) members.get(i).draw();
      noFill();
      stroke(0xFF, 0, 0);
      strokeWeight(3/cameraZoom);
      pushMatrix();
      translate(-cameraPosition.x, -cameraPosition.y);
      scale(cameraZoom);
      rect(0, 0, worldBoundaries.x, worldBoundaries.y);
      if (gamePhase==1) {
        PVector bodyCenter = new PVector(body.getAnchor(0).x+body.getPosition().x, body.getAnchor(0).y+body.getPosition().y);
        line(bodyCenter.x, bodyCenter.y, (mouseX+cameraPosition.x)/cameraZoom, (mouseY+cameraPosition.y)/cameraZoom);
      }
      popMatrix();
      fill(0);
      textSize(30);
      if (gamePhase==1) text("jouez", 50, 50);
      if (gamePhase==2) text("attendez", 50, 50); 
      text(lifes+" points", 50, 90);
      text(timer+" timer", 50, 150);
      generalGameLogic();
    }
  }
  else {
    if (useCam) {
      if (cam.available() == true) {
        cam.read();
        tint(0xFF, 0xFF, 0xFF, 0xFF);
        PImage preview = createImage(cam.width, cam.height, RGB);
        for (int x=0;x<cam.width;x++) {
          for (int y=0;y<cam.height;y++) {
            preview.set(x, y, cam.get(cam.width-x-1, y));
          }
        }
        image(preview, 0, 0, width, height);
        tint(0xFF, 0xFF, 0xFF, 0x50);
        image(picModel, 0, 0, width, height);
      }
    }
    else {
      if (!picturesStartedLoading) {
        planche=loadImage(dataPath("images/test01.png"));
        headPic=loadImage(dataPath("images/head01.png"));
        picturesStartedLoading=true;
      }
      if (planche.width>0 && headPic.width>0) loadGame();
    }
  }
}

void keyPressed() {
  if (keyCode==ENTER) {
    if (!gameLoaded) loadGame();
  }
}

void setNewZoom(float newZoom) {
  cameraPosition = new PVector(cameraPosition.x*(newZoom/cameraZoom), cameraPosition.y*(newZoom/cameraZoom));
  cameraZoom = newZoom;
}

void mousePressed() {
  if (gamePhase==1) {
    PVector bodyCenter = new PVector(body.getAnchor(0).x+body.getPosition().x, body.getAnchor(0).y+body.getPosition().y);
    body.setDirection(new PVector(((mouseX+cameraPosition.x)/cameraZoom-bodyCenter.x)/10, ((mouseY+cameraPosition.y)/cameraZoom-bodyCenter.y)/10));
    cameraZoomTarget=1f;
    gamePhase=2;
  }
  if (gamePhase==0) {
    loadGame();
    gamePhase=1;
  }
}

PVector crossWorldBoudaries = new PVector(0, 0);// TODO put that in a behaviour
void alertCrossWorldBoundaries(Member member, PVector cross) {
  if (member.hasTag("player")) {
    if (abs(cross.x)>abs(crossWorldBoudaries.x)) crossWorldBoudaries.x = cross.x;
    if (abs(cross.y)>abs(crossWorldBoudaries.y)) crossWorldBoudaries.y = cross.y;
  }
  if (member.hasTag("ring")) {
    if (cross.x<0) member.setDirection(new PVector(abs(member.getDirection().x)*1, member.getDirection().y));
    if (cross.x>0) member.setDirection(new PVector(abs(member.getDirection().x)*-1, member.getDirection().y));
    if (cross.y<0) {
      lifes++;
      members.remove(member);
    }
    if (cross.y>0) member.setDirection(new PVector(member.getDirection().x, abs(member.getDirection().y)*-1));
  }
}

void alertCollision(Member a, Member b) {
  if (a.hasTag("ring") && b.hasTag("fire")) {
    members.remove(b);
    members.remove(a);
  }
  if (a.hasTag("player") && b.hasTag("fire")) {
    lifes--;
    members.remove(b);
  }
  if (a.hasTag("player") && b.hasTag("ring")) {
    b.setDirection(new PVector(body.getDirection().x, min(body.getDirection().y, b.getDirection().y)));
  }
  if (a.hasTag("foot") && b.hasTag("block")) {
    if (body.getDirection().y>0) {
      if (a.getPosition().y<b.getPosition().y) {
        body.setDirection(new PVector(0, 0));
        while (a.isCollidingWith (b)) {
          a.setPosition(a.getPosition().x, a.getPosition().y-1, 0, 0);
          body.setPosition(body.getPosition().x, body.getPosition().y-1, 0, 0);
        }
      }
    }
  }
}

void generalGameLogic() {
  if (abs(crossWorldBoudaries.x)>0||abs(crossWorldBoudaries.y)>0) {
    body.setPosition(body.getPosition().x-crossWorldBoudaries.x, body.getPosition().y-crossWorldBoudaries.y, 0, 0);
    PVector bounceFriction = new PVector(1.2, 1.8);
    if (gamePhase==1) bounceFriction = new PVector(5, 5);
    if (abs(crossWorldBoudaries.x)>0) body.setDirection(new PVector(abs(body.getDirection().x)/bounceFriction.x*(-constrain(crossWorldBoudaries.x, -1, 1)), body.getDirection().y/bounceFriction.y));
    if (abs(crossWorldBoudaries.y)>0) body.setDirection(new PVector(body.getDirection().x/bounceFriction.x, abs(body.getDirection().y)/bounceFriction.y*(-constrain(crossWorldBoudaries.y, -1, 1))));
    crossWorldBoudaries=new PVector(0, 0);
  }
  if (body.getDirection().magSq()<150) {
    body.setDirection(new PVector(body.getDirection().x, max(body.getDirection().y, -1)));
    getMemberByName(members, "shoeR").setRotation(0);
    getMemberByName(members, "shoeL").setRotation(0);
    gamePhase=1;
  }
  if (gamePhase==2) timer=max(0, timer-1);
  if (timer==0) gamePhase=0;
}

void loadGame() {

  if (useCam) {
    cam.read();
    planche = createImage(cam.width, cam.height, RGB);
    for (int x=0;x<cam.width;x++) {
      for (int y=0;y<cam.height;y++) {
        planche.set(x, y, cam.get(cam.width-x-1, y));
      }
    }

    camHead.read();
    headPic = camHead.get();
  }

  headPic.resize(200, 200);  
  planche.resize(1200, 849);

  color backColor = lerpColor(planche.get(50, 50), planche.get(1150, 800), 0.5);

  // separate the big picture into many small ones
  Extractor[] extPics = new Extractor[20];
  for (int i=0;i<extPics.length;i++) extPics[i] = new Extractor(); 
  extPics[0].setPic(planche, 333, 507, 564, 739, 0, "sky");
  extPics[1].setPic(planche, 70, 507, 302, 738, 0, "floor");
  extPics[2].setPic(planche, 70, 59, 372, 275, 0, "title");
  extPics[3].setPic(planche, 70, 338, 400, 440, 0, "name");
  extPics[4].setPic(planche, 890, 97, 1059, 221, 1, "hat");
  extPics[5].setPic(planche, 649, 338, 813, 584, 1, "body");
  extPics[6].setPic(planche, 870, 338, 960, 582, 1, "legL");
  extPics[7].setPic(planche, 870, 338, 960, 582, 1, "legR");
  extPics[8].setPic(planche, 1005, 338, 1087, 582, 1, "armL");
  extPics[9].setPic(planche, 1005, 338, 1087, 582, 1, "armR");
  extPics[10].setPic(planche, 792, 672, 933, 767, 1, "shoeL");
  extPics[11].setPic(planche, 792, 672, 933, 767, 1, "shoeR");
  extPics[12].setPic(planche, 990, 672, 1134, 769, 1, "handL");
  extPics[13].setPic(planche, 990, 672, 1134, 769, 1, "handR");
  extPics[14].setPic(planche, 609, 659, 666, 703, 1, "block");
  extPics[15].setPic(planche, 685, 659, 741, 703, 1, "ring");
  extPics[16].setPic(planche, 609, 724, 666, 766, 1, "fire");
  extPics[17].setPic(planche, 685, 724, 741, 766, 1, "generic");
  extPics[18].setPic(headPic, 0, 0, headPic.width, headPic.height, 1, "head");
  extPics[19].setPic(planche, 414, 60, 571, 439, 0, "level");

  // transform and extract (TODO adapt it to the new Extractor class)
  extPics[14].scalePic(5);
  extPics[15].scalePic(5);
  extPics[16].scalePic(5);
  extPics[17].scalePic(5);
  extPics[10].transformPic(1);
  extPics[12].transformPic(1);
  extPics[2].scalePic(3);
  extPics[3].scalePic(3);
  for (int i=0;i<extPics.length;i++) extPics[i].extract(backColor, 100);
  extPics[10].computeRadius();
  extPics[11].computeRadius();
  extPics[14].computeRadius();
  extPics[15].computeRadius();
  extPics[16].computeRadius();
  extPics[17].computeRadius();
  extPics[1].commitSize(new PVector(worldBoundaries.x, worldBoundaries.y+100));
  extPics[0].commitSize(new PVector(width, height));

  for (int i=0;i<extPics.length;i++) extPics[i].exportData(); 

  members = new ArrayList<Member>();

  Member level = new Member(this, "level");
  level.behaviours.add(new B_drawn(level));
  level.behaviours.add(new B_level(level));
  level.setPic(extPics[19].picture);
  ArrayList<Member> blocks = level.generateLevelObjects();

  Member sky = new Member(this, "sky");
  Member floor = new Member(this, "floor");
  Member title = new Member(this, "title");
  Member name = new Member(this, "name");
  Member head = new Member(this, "head");
  Member hat = new Member(this, "hat");
  body = new Member(this, "body");
  Member legL = new Member(this, "legL");
  Member legR = new Member(this, "legR");
  Member armL = new Member(this, "armL");
  Member armR = new Member(this, "armR");
  Member shoeL = new Member(this, "shoeL");
  Member shoeR = new Member(this, "shoeR");
  Member handL = new Member(this, "handL");
  Member handR = new Member(this, "handR");

  sky.behaviours.add(new B_drawn(sky));
  floor.behaviours.add(new B_drawn(floor));
  title.behaviours.add(new B_drawn(title));
  name.behaviours.add(new B_drawn(name));
  head.behaviours.add(new B_drawn(head));
  hat.behaviours.add(new B_drawn(hat));
  body.behaviours.add(new B_drawn(body));
  legL.behaviours.add(new B_drawn(legL));
  legR.behaviours.add(new B_drawn(legR));
  armL.behaviours.add(new B_drawn(armL));
  armR.behaviours.add(new B_drawn(armR));
  shoeL.behaviours.add(new B_drawn(shoeL));
  shoeR.behaviours.add(new B_drawn(shoeR));
  handL.behaviours.add(new B_drawn(handL));
  handR.behaviours.add(new B_drawn(handR));

  title.behaviours.add(new B_background(title));
  name.behaviours.add(new B_background(name));

  sky.behaviours.add(new B_background(sky));
  floor.behaviours.add(new B_background(floor));

  floor.setParallax(0f);

  body.behaviours.add(new B_gravity(body));

  hat.behaviours.add(new B_articulationGrabber(hat));
  head.behaviours.add(new B_articulationGrabber(head));
  legL.behaviours.add(new B_articulationGrabber(legL));
  legR.behaviours.add(new B_articulationGrabber(legR));
  armL.behaviours.add(new B_articulationGrabber(armL));
  armR.behaviours.add(new B_articulationGrabber(armR));
  shoeL.behaviours.add(new B_articulationGrabber(shoeL));
  shoeR.behaviours.add(new B_articulationGrabber(shoeR));
  handL.behaviours.add(new B_articulationGrabber(handL));
  handR.behaviours.add(new B_articulationGrabber(handR));

  hat.tags.add("player");
  head.tags.add("player");
  legL.tags.add("player");
  legR.tags.add("player");
  armL.tags.add("player");
  armR.tags.add("player");
  shoeL.tags.add("player");
  shoeR.tags.add("player");
  shoeL.tags.add("foot");
  shoeR.tags.add("foot");
  handL.tags.add("player");
  handR.tags.add("player");

  shoeL.behaviours.add(new B_collider(shoeL));
  shoeR.behaviours.add(new B_collider(shoeR));
  shoeL.behaviours.add(new B_collisionMaskCircle(shoeL));
  shoeR.behaviours.add(new B_collisionMaskCircle(shoeR));
  shoeL.setRadius(extPics[10].radius);
  shoeR.setRadius(extPics[11].radius);
  handL.behaviours.add(new B_collider(handL));
  handR.behaviours.add(new B_collider(handR));
  shoeL.setCollisionsChecks(true, true);
  shoeR.setCollisionsChecks(true, true);
  handL.setCollisionsChecks(true, true);
  handR.setCollisionsChecks(true, true);

  head.setPic(extPics[18].picture);
  head.setAnchors(extPics[18].anchor);

  sky.setPic(extPics[0].picture);
  floor.setPic(extPics[1].picture);

  title.setPic(extPics[2].picture);
  name.setPic(extPics[3].picture);  
  hat.setPic(extPics[4].picture);
  body.setPic(extPics[5].picture);
  legL.setPic(extPics[6].picture);
  legR.setPic(extPics[7].picture);
  armL.setPic(extPics[8].picture);
  armR.setPic(extPics[9].picture);
  shoeL.setPic(extPics[10].picture);
  shoeR.setPic(extPics[11].picture);
  handL.setPic(extPics[12].picture);
  handR.setPic(extPics[13].picture);

  hat.setAnchors(extPics[4].anchor);
  body.setAnchors(extPics[5].anchor);
  legL.setAnchors(extPics[6].anchor);
  legR.setAnchors(extPics[7].anchor);
  armL.setAnchors(extPics[8].anchor);
  armR.setAnchors(extPics[9].anchor);
  shoeL.setAnchors(extPics[10].anchor);
  shoeR.setAnchors(extPics[11].anchor);
  handL.setAnchors(extPics[12].anchor);
  handR.setAnchors(extPics[13].anchor);

  for (int i=0;i<blocks.size();i++) {
    if (blocks.get(i).hasTag("block")) {
      blocks.get(i).setAnchors(extPics[14].anchor);
      blocks.get(i).setPic(extPics[14].picture);
      blocks.get(i).setRadius(extPics[14].radius);
    }
    if (blocks.get(i).hasTag("ring")) {
      blocks.get(i).setAnchors(extPics[15].anchor);
      blocks.get(i).setPic(extPics[15].picture);
      blocks.get(i).setRadius(extPics[15].radius);
    }
    if (blocks.get(i).hasTag("fire")) {
      blocks.get(i).setAnchors(extPics[16].anchor);
      blocks.get(i).setPic(extPics[16].picture);
      blocks.get(i).setRadius(extPics[16].radius);
    }
    if (blocks.get(i).hasTag("generic")) {
      blocks.get(i).setAnchors(extPics[17].anchor);
      blocks.get(i).setPic(extPics[17].picture);
      blocks.get(i).setRadius(extPics[17].radius);
    }
  }

  floor.setPosition(0, worldBoundaries.y, worldBoundaries.x, worldBoundaries.y+100);
  sky.setPosition(0, 0, width, height);

  title.setParallax(0);
  name.setParallax(0);
  title.setPosition(0, -title.pic.height, title.pic.width, title.pic.height);
  name.setPosition(title.pic.width, -name.pic.height, name.pic.width, name.pic.height);

  members.add(sky);
  members.add(floor);
  for (int i=0;i<blocks.size();i++) members.add(blocks.get(i));
  members.add(title);
  members.add(name);
  members.add(head);
  members.add(hat);
  members.add(legL);
  members.add(legR);
  members.add(armL);
  members.add(armR);
  members.add(body);
  members.add(shoeL);
  members.add(shoeR);
  members.add(handL);
  members.add(handR);

  armL.setBaseRotation(PI*2/3);
  armR.setBaseRotation(-PI*2/3);
  handL.setBaseRotation(PI*3/4);
  handR.setBaseRotation(-PI*3/4);
  legL.setBaseRotation(-PI/5);
  legR.setBaseRotation(PI/5);

  hat.setAnchor(head, 1, 2);
  head.setAnchor(body, 1, 2);
  legL.setAnchor(body, 7, 1);
  legR.setAnchor(body, 8, 1);
  armL.setAnchor(body, 5, 1);
  armR.setAnchor(body, 6, 1);
  handL.setAnchor(armL, 2, 1);
  handR.setAnchor(armR, 2, 1);
  shoeL.setAnchor(legL, 2, 1);
  shoeR.setAnchor(legR, 2, 1);

  hat.setInertia(0.8f/1);

  head.setRelativeRotation(true);

  body.setPosition(worldBoundaries.x/10, worldBoundaries.y*9/10, 0, 0);

  for (int i=0;i<members.size();i++) members.get(i).exportData();

  lifes = 5;
  timer = 500;

  gameLoaded=true;
}

