
/*
drag and drop a picture
this sketch is blurring each pixel according to the brightness level and some randomness
*/

import sojamo.drop.*;

SDrop drop;
int type=0;

void setup() {
  size(500,500);
  drop= new SDrop(this);
}

void draw() {

}

void dropEvent(DropEvent theDropEvent) {
  PImage im = loadImage(theDropEvent.file().toString());
  image(im,0,0);  
  PGraphics im2 = createGraphics(im.width,im.height,JAVA2D);
  im2.beginDraw();
  im2.noStroke();
  im2.image(im,0,0);
  for (int x=0;x<im.width;x++) {
    println(x*100/im.width+" %");    
    for (int y=0;y<im.height;y++) {
      if (type==0) {
        im2.fill(im.get(x,y),min(brightness(im.get(x,y)),alpha(im.get(x,y)))/2);
        float r=saturation(im.get(x,y))*random(20)/256;        
        im2.ellipse(x,y,r,r);
      }
      else if (type==1) {
        im2.stroke(im.get(x,y),alpha(im.get(x,y))*2/3);
        float r=saturation(im.get(x,y))*random(-2,5)/256;
        im2.line(x,y,x,y+r);
      }
    }
  }
  im2.endDraw();
  image(im2,0,0);
  println("fini !");
  im2.save("blah.png");
}






