
int sizx=400;
int sizy=400;
int div=50;

boolean tranche;

float espx=sizx/div;
float espy=sizy/div;

int nbMetaballs=20;

Coords[][] coord=new Coords[div][div];
Metaballs[] metaball=new Metaballs[nbMetaballs];

class Metaballs{
  float x;
  float y;
  float vx;
  float vy;
  Metaballs() {
    this.x=random(width);
    this.y=random(height);
    this.vx=random(-5,5);
    this.vy=random(-5,5);
  }
}

class Coords{
  float x;
  float y;
  float v;

  Coords(float x, float y) {
    this.x=x;
    this.y=y;
  }

  void dessine() {
    if (tranche) {
      fill(255);
      ellipse(x+espx/2,y+espy/2,espx*v,espy*v);
    }
    else {
      fill(255-(v*255));
      ellipse(x+espx/2,y+espy/2,espx,espy);
    }
  }
}

void setup() {
  smooth();
  noStroke();
  background(0);
  fill(0);
  frameRate(30);
  size(sizx,sizy);
  for (int x=0;x<div;x++) {
    for (int y=0;y<div;y++) {
      coord[x][y]=new Coords(x*espx,y*espy);
    }
  }
  for (int i=0;i<nbMetaballs;i++) {  
    metaball[i]=new Metaballs();
  }
}

void draw() {
  background(0);
  bouge();
  calcule();
  dessine();
}

void bouge() {
  for (int i=0;i<nbMetaballs;i++) {
    metaball[i].x+=metaball[i].vx;
    metaball[i].y+=metaball[i].vy;
    if (metaball[i].x<0 || metaball[i].x>width) {
      metaball[i].vx=-metaball[i].vx;
    }
    if (metaball[i].y<0 || metaball[i].y>height) {
      metaball[i].vy=-metaball[i].vy;
    }
  }
}

void calcule() {
  float vMax=0;
  float vMin=nbMetaballs;
  for (int x=0;x<div;x++) {
    for (int y=0;y<div;y++) {
      coord[x][y].v=0;
      for (int i=0;i<nbMetaballs;i++) {      
        coord[x][y].v=max(coord[x][y].v,1-(longueur(coord[x][y].x,coord[x][y].y,metaball[i].x,metaball[i].y)/(longueur(0,0,width,height))));
        //        coord[x][y].v+=1-(longueur(coord[x][y].x,coord[x][y].y,metaball[i].x,metaball[i].y)/(longueur(0,0,width,height)));        
      }
      vMax=max(vMax,coord[x][y].v);
      vMin=min(vMin,coord[x][y].v);
    }
  }
  for (int x=0;x<div;x++) {
    for (int y=0;y<div;y++) {
      coord[x][y].v=constrain((coord[x][y].v-vMin)/(vMax-vMin),0,1);
    }
  }
}

void dessine() {
  for (int x=0;x<div;x++) {
    for (int y=0;y<div;y++) {
      coord[x][y].dessine();
    }
  }
}

float longueur(float x, float y, float x2, float y2) {
  return sqrt(sq(x2-x)+sq(y2-y));
}

void keyPressed() {
  if (tranche) {
    tranche=false;
  }
  else{
    tranche=true;      
  }
}
