
float sizx=600;
float sizy=600;

int iPlace=0;
int nbBoules=1;
int nbTriangles=2;
int nbLevels=1;
int nbSorties=1;
Boule[] bou = new Boule[nbBoules];
Triangle[] tri = new Triangle[nbTriangles];
Level[] lev = new Level[nbLevels];
int levelActuel = 0;
Sortie[] sor= new Sortie[nbSorties];

class Sortie {
  float x;
  float y;
  float r;
  int nb;
  Sortie (int nb) {
    this.nb=nb;
    x=random(sizx);
    y=random(sizy);
    r=random(10)+2;
  }
  void dessine() {
    stroke(127);
    fill(255);
    ellipse (x,y,r*2,r*2);
  }
}

class Level {
  int nb;
  int nbBoules;
  int nbTriangles;
  int nbSorties;  
  Boule[] bou;
  Triangle[] tri;
  Sortie[] sor;
  Level(int nb) {    
    this.nb=nb;
  }
  void setObj() {
    bou = new Boule[nbBoules];
    tri = new Triangle[nbTriangles];
    sor = new Sortie[nbSorties];
    for (int i=0;i<nbTriangles;i++) {
      tri[i] = new Triangle(i);
    }  
    for (int i=0;i<nbBoules;i++) {
      bou[i] = new Boule(i);
    }
    for (int i=0;i<nbSorties;i++) {
      sor[i] = new Sortie(i);
    }
  }
}

class Triangle {
  int nbCotes=5;
  int nb;
  float[] x = new float[nbCotes];
  float[] y = new float[nbCotes];
  int type;
  Triangle (int nb) {
    this.nb=nb;
    if (nb%2==0) {
      type=0;
    }
    else{
      type=1;
    }
    for (int i=0;i<nbCotes;i++) {
      x[i]=random(sizx);
      y[i]=random(sizy*4/5);
    }
  }
  void agit() {
  }
  void dessine() {
    noStroke();
    if (type==0){
      fill(255,0,0,127);
    }
    else if (type==1){
      fill(0,255,255,63);
    }
    beginShape();
    for (int i=0;i<nbCotes;i++) {
      vertex(x[i],y[i]);
    }
    endShape();
  }
}

class Boule {
  float x;
  float y;
  float r;
  float v;
  float a;
  int nb;
  int type;
  boolean sortie=false;
  Boule (int nb) {
    this.nb=nb;
    if (nb%2==0) {
      type=0;
    }
    else{
      type=1;
    }    
    r=random(10)+2;
    v=random(5)+1;
    a=random(TWO_PI);
    boolean placeLibre=false;
    while (!placeLibre) {
      x=random(width);
      y=random(height);
      placeLibre=true;
      for (int i=0;i<nb;i++) {
        if (longueur(x,y,bou[i].x,bou[i].y)<r+bou[i].r) {
          placeLibre=false;
        }
      }
      for (int i=0;i<nbTriangles;i++) {
        ColBouPol co=new ColBouPol(tri[i].nbCotes, tri[i].x, tri[i].y, x, y, r);
        if (co.collision) {
          placeLibre=false;
        }
      }
    }
  }
  void gravite() {
    float frictionAir=0.1;
    float forceGrav=0.5;
    float vMax=10;
    float yTmp=y+sin(a)*v+forceGrav;
    float xTmp=x+cos(a)*v;    
    boolean libre=true;
    for (int i=0;i<nbTriangles;i++) {
      ColBouPol co=new ColBouPol(tri[i].nbCotes, tri[i].x, tri[i].y, xTmp, yTmp, r);
      if (co.collision) {
        if (type==tri[i].type) {        
          libre=false;
        }
      }
    }
    for (int i=0;i<nbBoules;i++) {
      if (i!=nb) {
        if (longueur(x,y,bou[i].x,bou[i].y)<r+bou[i].r) {
          libre=false;
        }
      }
    }
    if (libre) {
      a=atan2(yTmp-y,xTmp-x);
      v=constrain(longueur(x,y,xTmp,yTmp),0,vMax);
    }
    v=constrain(v-frictionAir,0,vMax);    
  }
  void rebondBalles(float vTmp) {
    float yTmp=y+sin(a)*vTmp;
    float xTmp=x+cos(a)*vTmp;    
    for (int i=0;i<nbBoules;i++) {
      if (i!=nb) {
        if (longueur(xTmp,yTmp,bou[i].x,bou[i].y)<r+bou[i].r) {
          float angle=atan2(bou[i].y-yTmp,bou[i].x-xTmp);
          if (longueur(xTmp,yTmp,bou[i].x,bou[i].y)>longueur(xTmp+cos(a),yTmp+sin(a),bou[i].x,bou[i].y)) {//si ça ne va pas faire empirer les choses
            a=(a+(angle-a)*2)-PI;//rebond
          }
          if (longueur(xTmp,yTmp,bou[i].x,bou[i].y)>longueur(xTmp,yTmp,bou[i].x+cos(bou[i].a),bou[i].y+sin(bou[i].a))) {//si ça ne va pas faire empirer les choses
            bou[i].a=(bou[i].a+((angle+PI)-bou[i].a)*2)-PI;//rebond
          }
        }
      }
    }
  }
  void rebondTriangles(float vTmp) {
    float yTmp=y+sin(a)*vTmp;
    float xTmp=x+cos(a)*vTmp;    
    for (int i=0;i<nbTriangles;i++) {
      ColBouPol co=new ColBouPol(tri[i].nbCotes, tri[i].x, tri[i].y, xTmp, yTmp, r);
      if (co.collision) {
        if (type==tri[i].type) {
          ColBouPol co2 = new ColBouPol(tri[i].nbCotes, tri[i].x, tri[i].y, xTmp+cos(a), yTmp+sin(a), r);
          if (co.penetration>co2.penetration) {//si ça ne va pas faire empirer les choses
            float absorb=0;
            a=(a+(co.angle-a)*2)-PI;//rebond
            v*=1-absorb;
            if (v<1) {
              a=min((co.angle+HALF_PI+TWO_PI)%TWO_PI,(co.angle+HALF_PI+PI+TWO_PI)%TWO_PI);
              a=atan2(sin(a)-1,cos(a));
            }
          }
        }
      }
    }
  }  
  void agit() {
    if (!sortie) {
      gravite();
      int surplus;
      for (surplus=0;surplus<v;surplus++) {
        rebondBalles(1);
        rebondTriangles(1);
        x+=cos(a);
        y+=sin(a);
      }
      rebondBalles(v-surplus);
      rebondTriangles(v-surplus);
      x+=cos(a)*(v-surplus);
      y+=sin(a)*(v-surplus);
      x=(x+width)%width;
      y=(y+height)%height;
    }
    vaSortie();
  }
  void vaSortie() {
    sortie=false;
    for (int i=0;i<nbSorties;i++) {
      if (longueur(x,y,sor[i].x,sor[i].y)<=r+sor[i].r) {
        x=(x+sor[i].x)/2;
        y=(y+sor[i].y)/2;
        sortie=true;
      }
    }
  }
  void dessine() {
    if (type==0){
      stroke(127,0,0);
      fill(255,0,0,127);
    }
    else if (type==1){
      stroke(0,127,127);
      fill(0,255,255,127);
    }
    ellipse (x,y,r*2,r*2);
  }
  void place(float x, float y, float a) {
    this.x=x;
    this.y=y;
    this.a=HALF_PI;
  }
}

class ColBouPol {//collision entre une boule et un polygone
  boolean collision;
  float angle;
  float penetration;
  ColBouPol (int nbCotes, float[] pX, float[] pY, float bX, float bY, float bR) {
    //vérifie la position de la boule par rapport au voronoi du polygone
    int noPProche=0;//index du sommet (ou segment) proche
    float tmpLPProche=longueur(bX,bY,pX[0],pY[0]);
    float penCentre=-tmpLPProche;
    angle=atan2(pY[0]-bY,pX[0]-bX);        
    for (int i=0;i<nbCotes;i++) {
      float tmpLAct=longueur(bX,bY,pX[i],pY[i]);
      if (tmpLAct<tmpLPProche) {
        noPProche=i;
        tmpLPProche=tmpLAct;
        angle=atan2(pY[noPProche]-bY,pX[noPProche]-bX);        
        penCentre=-tmpLAct;
      }      
    }
    //vérifie la position de la boule par rapport au voronoi des cotés du polygone
    boolean procheCote=false;//deviendra vrai si la boule est plus proche d'un coté que d'un sommet
    for (int i=0;i<nbCotes;i++) {
      // A = sommet i
      // B = boule
      // C = sommet i+1
      // D = projection de C sur AB
      int i2=(i+1)%nbCotes;
      float lBA=longueur(bX,bY,pX[i],pY[i]);
      float aBA=atan2(pY[i]-bY,pX[i]-bX);
      float aCA=atan2(pY[i]-pY[i2],pX[i]-pX[i2]);
      float aBD=aCA+HALF_PI;//pour le moment mais on va paufiner ça
      float lBD=cos(aBD-aBA)*lBA;
      if (iPol(bX,bY,pX,pY)) {
        if (lBD>0) {
          aBD+=PI;
          lBD*=-1;
        }
      }
      else{
        if (lBD<0) {
          aBD+=PI;
          lBD*=-1;
        }      
      }
      aBD=aBD%TWO_PI;//juste au cas où
      float dX=bX+cos(aBD)*lBD;
      float dY=bY+sin(aBD)*lBD;
      if (abs(lBD)<abs(tmpLPProche)) {
        float lAC=longueur(pX[i],pY[i],pX[i2],pY[i2]);
        boolean inclusA = lAC>longueur(pX[i],pY[i],dX,dY);
        boolean inclusB = lAC>longueur(pX[i2],pY[i2],dX,dY);
        if (inclusA && inclusB) {
          noPProche=i;
          tmpLPProche=lBD;
          penCentre=-lBD;
          angle=aBD;
          procheCote=true;
        }
      }
    }
    //définit l'angle de collision
    //définit la longueur entre le centre de la boule et le polygone (penCentre)
    //(tout ça c'est fait)
    //regarde si cette longueur est inférieure au rayon de la boule
    if (penCentre>-bR) {
      collision=true;
    }
    else {
      collision=false;
    }
    //la pénétration = distance entre les points en surface de la boule et du polygone
    penetration=-(penCentre+bR);
  }
}

void setup() {
  size((int)sizx,(int)sizy);
  frameRate(30);  
  smooth();
  fill(255);
  stroke(127);
  for (int i=0;i<nbTriangles;i++) {
    tri[i] = new Triangle(i);
  }  
  for (int i=0;i<nbBoules;i++) {
    bou[i] = new Boule(i);
  }
  for (int i=0;i<nbSorties;i++) {
    sor[i] = new Sortie(i);
  }
  for (int i=0;i<nbLevels;i++) {
    lev[i] = new Level(i);
  }  
  initLevels();
  chargeLv(0);
}

void draw() {
  background(0);
  for (int i=0;i<nbSorties;i++) {
    sor[i].dessine();
  }  
  for (int i=0;i<nbBoules;i++) {
    bou[i].agit();
    bou[i].dessine();
  }
  for (int i=0;i<nbTriangles;i++) {
    tri[i].dessine();
    tri[i].agit();    
  }
  if (mousePressed) {
    boolean placeLibre=true;
    float randX=random(-bou[iPlace].r,bou[iPlace].r);
    for (int i=0;i<nbBoules;i++) {
      if (longueur(mouseX+randX,mouseY,bou[i].x,bou[i].y)<=bou[i].r+bou[iPlace].r+bou[iPlace].v) {
        placeLibre=false;
      }
    }
    for (int i=0;i<nbTriangles;i++) {
      ColBouPol co=new ColBouPol(tri[i].nbCotes, tri[i].x, tri[i].y, mouseX+randX, mouseY, bou[iPlace].r);
      if (co.collision) {
        placeLibre=false;
      }
    }    
    if (placeLibre) {
      bou[iPlace].place(mouseX+randX,mouseY,HALF_PI);
      iPlace=(iPlace+1)%nbBoules;
    }
  }  
}

float longueur(float x, float y, float x2, float y2) {
  return sqrt(sq(x2-x)+sq(y2-y));
}

boolean iPol (float x, float y, float[] x2, float[] y2) {//inside polygon
  int i, j, c = 0;  
  for (i = 0, j = x2.length-1; i < x2.length; j = i++) {  
    if ((((y2[i] <= y) && (y < y2[j])) || ((y2[j] <= y) && (y < y2[i]))) && (x < (x2[j] - x2[i]) * (y - y2[i]) / (y2[j] - y2[i]) + x2[i])) c = (c+1)%2;  
  }  
  return c==1;  
}

void keyPressed() {
  if (keyCode==BACKSPACE) {
    for (int i=0;i<nbTriangles;i++) {
      tri[i] = new Triangle(i);
    }  
    for (int i=0;i<nbBoules;i++) {
      bou[i] = new Boule(i);
    }
    for (int i=0;i<nbSorties;i++) {
      sor[i] = new Sortie(i);
    }
  }
  else{
    for (int i=0;i<nbTriangles;i++) {
      if (tri[i].type==0) {
        tri[i].type=1;
      }
      else{
        tri[i].type=0;        
      }
    }    
  }
}

void chargeLv(int nb) {
  nbBoules=lev[nb].nbBoules;
  nbTriangles=lev[nb].nbTriangles;
  nbSorties=lev[nb].nbSorties;
  bou = new Boule[nbBoules];  
  tri = new Triangle[nbTriangles];
  sor= new Sortie[nbSorties];
  for (int i=0;i<nbBoules;i++) {
    bou[i]=lev[nb].bou[i];
  }
  for (int i=0;i<nbTriangles;i++) {
    tri[i]=lev[nb].tri[i];
  }
  for (int i=0;i<nbSorties;i++) {
    sor[i]=lev[nb].sor[i];
  }
}

void initLevels() {
  float bX=sizx/100;
  float bY=sizy/100;
  lev[0].nbBoules=1;
  lev[0].nbTriangles=2;
  lev[0].nbSorties=1;
  lev[0].setObj();
  lev[0].sor[0].x=bX*50;
  lev[0].sor[0].y=bY*78;
  lev[0].sor[0].r=(bX+bY)/1.7;
  lev[0].bou[0].x=bX*10;
  lev[0].bou[0].y=bY*10;
  lev[0].bou[0].r=(bX+bY)/2;
  lev[0].tri[0].nbCotes=6;
  lev[0].tri[0].type=0;
  lev[0].tri[0].x=new float[10];
  lev[0].tri[0].y=new float[10];  
  lev[0].tri[0].x[0]=bX*1;
  lev[0].tri[0].y[0]=bY*21;
  lev[0].tri[0].x[1]=bX*50;
  lev[0].tri[0].y[1]=bY*30;
  lev[0].tri[0].x[2]=bX*99;
  lev[0].tri[0].y[2]=bY*21;
  lev[0].tri[0].x[3]=bX*99;
  lev[0].tri[0].y[3]=bY*50;
  lev[0].tri[0].x[4]=bX*50;
  lev[0].tri[0].y[4]=bY*60;
  lev[0].tri[0].x[5]=bX*1;
  lev[0].tri[0].y[5]=bY*50;
  lev[0].tri[1].nbCotes=6;
  lev[0].tri[1].type=1;
  lev[0].tri[1].x=new float[10];
  lev[0].tri[1].y=new float[10];  
  lev[0].tri[1].x[0]=bX*1;
  lev[0].tri[1].y[0]=bY*71;
  lev[0].tri[1].x[1]=bX*50;
  lev[0].tri[1].y[1]=bY*80;
  lev[0].tri[1].x[2]=bX*99;
  lev[0].tri[1].y[2]=bY*71;
  lev[0].tri[1].x[3]=bX*99;
  lev[0].tri[1].y[3]=bY*80;
  lev[0].tri[1].x[4]=bX*50;
  lev[0].tri[1].y[4]=bY*90;
  lev[0].tri[1].x[5]=bX*1;
  lev[0].tri[1].y[5]=bY*80;
}
