
import krister.Ess.*;

int nbCan=5;
int slMin=50000;
int slMax=100000;
int ordre=2;
int fs=500;
float[] son= new float[fs];
int tx=0;

AudioChannel[] chan1 =new AudioChannel[nbCan];
Reverb rev;
Envelope env;
EPoint[] envp=new EPoint[3];

void setup() {
  frameRate(30);
  Ess.start(this);
  stroke(255);
  fill(0,10);

  for (int i = 0;i<nbCan;i++) {
    chan1[i]=new AudioChannel();
    chan1[i].initChannel(floor(random(slMin,slMax)));
    chan1[i].play();
  }

  envp[0]=new EPoint(0,0);
  envp[1]=new EPoint(1,1);
  envp[2]=new EPoint(100,0.5);

}

void draw() {
  rect(0,0,width,height);
  tx=(tx+1)%width;
}

void audioChannelDone(AudioChannel ch) {
  int iee=0;
  fs=floor(random(10,300));
  point(tx,fs*width/300);
  for (int i=0;i<fs;i++) {
    son[i]=random(-1,1);
  }
  while (iee<(ch.size-fs)) {
    for (int i=0;i<fs;i++) {
      for (int i2=1;i2<ordre;i2++) {
        son[i]+=son[(i-i2+fs)%fs];
      }
      son[i]/=(float)ordre;
    }
    for (int i=0;i<fs;i++) {
      ch.samples[iee+i]=son[i];
    }
    iee+=fs;
  }
  env=new Envelope(envp);  
  env.filter(ch);
  rev=new Reverb(random(1),0,random(0.5,1));
  rev.filter(ch,0,ch.frames(2000));
  ch.play();
}

public void stop() {
  Ess.stop();
  super.stop();
}
