
int nbPoints = 5;
int nbBzPoints = 10;

PVector[] points = new PVector[nbPoints];
PVector[] dirs = new PVector[nbPoints];

void setup() {
  size(500, 500);
  noSmooth();
  noFill();
  for (int i=0;i<points.length;i++) {
    points[i] = new PVector(random(width), random(height));
    dirs[i] = new PVector(random(-1, 1), random(-1, 1));
  }
}

void draw() {
  nbBzPoints = floor(max(2, 25*(float)mouseY/height));
  for (int i=0;i<points.length;i++) {
    points[i].x+=dirs[i].x;
    points[i].y+=dirs[i].y;
    if (points[i].x>=width ) dirs[i].x = abs(dirs[i].x) * -1;
    if (points[i].y>=height) dirs[i].y = abs(dirs[i].y) * -1;
    if (points[i].x<=0     ) dirs[i].x = abs(dirs[i].x) * 1;
    if (points[i].y<=0     ) dirs[i].y = abs(dirs[i].y) * 1;
  }
  background(0);
  stroke(0, 0, 0xFF);
  strokeWeight(3);
  for (int i=0;i<points.length-1;i++) {
    line(points[i].x, points[i].y, points[i+1].x, points[i+1].y);
  }
  PVector[] bzPts = new PVector[nbBzPoints];
  for (int i=0;i<bzPts.length;i++) {
    float thisProp = (float)i / (float)(bzPts.length-1);
    bzPts[i] = getNextBezier(points, thisProp);
  }
  stroke(0xFF, 0, 0);
  strokeWeight(3);
  for (int i=0;i<bzPts.length-1;i++) {
    line(bzPts[i].x, bzPts[i].y, bzPts[i+1].x, bzPts[i+1].y);
  }
  stroke(0x50);
  text("mouse vertical axis = number of lines in curve", 20, 20);
}

PVector getNextBezier(PVector[] lines, float prop) {
  if (lines.length==2) {
    float thisX = lines[0].x + (lines[1].x-lines[0].x)*prop;
    float thisY = lines[0].y + (lines[1].y-lines[0].y)*prop; 
    return new PVector(thisX, thisY);
  } 
  else {
    PVector[] newLines = new PVector[lines.length-1];
    for (int i=0 ; i<newLines.length ; i++) {
      float thisX = lines[i].x + (lines[i+1].x-lines[i].x)*prop;
      float thisY = lines[i].y + (lines[i+1].y-lines[i].y)*prop; 
      newLines[i] = new PVector(thisX, thisY);
    }
    for (int i=0 ; i<newLines.length-1 ; i++) {
      stroke(0xFF, (float)0xFF/(nbBzPoints+newLines.length));
      strokeWeight(1);
      line(newLines[i].x, newLines[i].y, newLines[i+1].x, newLines[i+1].y);
    }
    return getNextBezier(newLines, prop);
  }
}


