
/**
* a sketch that automatically datamoshes a file and outputs the result
* For instance I used it to generate this video <a href="https://www.youtube.com/watch?v=fimEKq5jU9E">https://www.youtube.com/watch?v=fimEKq5jU9E</a>
*/

void setup() {
  byte[] by = loadBytes("some RIFF file.avi");
  int dataStart = 6083800;// you can use riffPad to know where to start
  int dataEnd = 6296916;
  float maxJumpLength = 10000;
  int bytesToSwitch=300;
  float lendEnd = 3;
  for (int i=0;i<bytesToSwitch;i++) {
    int from = dataEnd-floor(pow(random(1),lendEnd)*(dataEnd-dataStart));
    while ((from-dataStart)%64!=0) from++;
    int to = floor(constrain(from+random((int)(from-dataStart)*maxJumpLength/(dataEnd-dataStart)),dataStart,dataEnd));
    while ((to-dataStart)%64!=0) to++;
    int partLength = floor(random(min(by.length-from,by.length-to)));
    for (int j=0;j<partLength;j++) {
      byte thisByte = by[from+j];
      by[from+j] = by[to+j];
      by[to+j] = thisByte;
    }
  }
  saveBytes("result.avi",by);
}

