import processing.core.PApplet;
import processing.core.PImage;

int tileSize = 16;
int nbTilesX = 30;
int nbTilesY = 30;

int nbOfNonCross = 8;// nb of non crossing tiles in the tileset

PImage tileset;

boolean[][] crossable = new boolean[nbTilesX][nbTilesY];
int[][] highness = new int[nbTilesX][nbTilesY];
int[][][] id = new int[nbTilesX][nbTilesY][4];

public void setup() {
  size(nbTilesX * tileSize, nbTilesY * tileSize);
  generateHighness();
  generateCrossable();
  setsRightIds();
  tileset = loadImage("tileset.png");
}

private void setsRightIds() {
  // first sets a table of ids only based
  // on crossable areas
  for (int x = 0; x < nbTilesX; x++) {
    for (int y = 0; y < nbTilesY; y++) {
      // skip non-crossable tiles before the other ones
      // on the tileset
      for (int i = 0; i < 4; i++) {
        id[x][y][i] = nbOfNonCross + highness[x][y];
      }
    }
  }
  // then sets the right tile if there is a non crossable area on it
  for (int x = 0; x < nbTilesX; x++) {
    for (int y = 0; y < nbTilesY; y++) {
      // if non crossable
      if (!crossable[x][y]) {
        id[x][y] = findGoodWallFor(x, y);
      }
    }
  }
}

private int[] findGoodWallFor(int xB, int yB) {
  // sets default to 3
  int[] id = new int[4];
  boolean[][] bC = new boolean[3][3];
  // creates a small matrix for the borders
  for (int x = -1; x < 2; x++) {
    for (int y = -1; y < 2; y++) {
      // if it's out of the screen, set as crossable
      if (xB + x >= 0 && yB + y >= 0 && xB + x < nbTilesX
        && yB + y < nbTilesY) {
        bC[x + 1][y + 1] = crossable[x + xB][y + yB];
      } 
      else {
        bC[x + 1][y + 1] = true;
      }
    }
  }
  // then sets each case separately
  if (!bC[0][0] && !bC[1][0] && !bC[0][1]) {
    id[0] = 0;
  }
  if (bC[0][0] && !bC[1][0] && !bC[0][1]) {
    id[0] = 1;
  }
  if (bC[1][0] && bC[0][1]) {
    id[0] = 2;
  }
  if (!bC[1][0] && bC[0][1]) {
    id[0] = 3;
  }
  if (bC[1][0] && !bC[0][1]) {
    id[0] = 4;
  }
  if (!bC[2][0] && !bC[1][0] && !bC[2][1]) {
    id[1] = 0;
  }
  if (bC[2][0] && !bC[1][0] && !bC[2][1]) {
    id[1] = 1;
  }
  if (bC[1][0] && bC[2][1]) {
    id[1] = 2;
  }
  if (!bC[1][0] && bC[2][1]) {
    id[1] = 3;
  }
  if (bC[1][0] && !bC[2][1]) {
    id[1] = 4;
  }
  if (!bC[0][2] && !bC[1][2] && !bC[0][1]) {
    id[2] = 0;
  }
  if (bC[0][2] && !bC[1][2] && !bC[0][1]) {
    id[2] = 1;
  }
  if (bC[1][2] && bC[0][1]) {
    id[2] = 2;
  }
  if (!bC[1][2] && bC[0][1]) {
    id[2] = 3;
  }
  if (bC[1][2] && !bC[0][1]) {
    id[2] = 4;
  }
  if (!bC[2][2] && !bC[1][2] && !bC[2][1]) {
    id[3] = 0;
  }
  if (bC[2][2] && !bC[1][2] && !bC[2][1]) {
    id[3] = 1;
  }
  if (bC[1][2] && bC[2][1]) {
    id[3] = 2;
  }
  if (!bC[1][2] && bC[2][1]) {
    id[3] = 3;
  }
  if (bC[1][2] && !bC[2][1]) {
    id[3] = 4;
  }
  return id;
}

private Integer booleanToInt(boolean b) {
  if (b) {
    return 1;
  } 
  else {
    return 0;
  }
}

private void generateCrossable() {
  // sets all the borders and the rest to crossable
  for (int x = 0; x < nbTilesX; x++) {
    for (int y = 0; y < nbTilesY; y++) {
      if (x == 0 || y == 0 || x == nbTilesX - 1 || y == nbTilesY - 1) {
        // borders
        crossable[x][y] = true;
      } 
      else {
        // center
        crossable[x][y] = true;
      }
    }
  }
  // choose the density of the walls
  float density = random(0.02f);
  // set some tiles to wall
  for (int x = 0; x < nbTilesX; x++) {
    for (int y = 0; y < nbTilesY; y++) {
      if (random(1) < density) {
        // sets it to a wall if it's flat enough
        if (flatAround(x, y) > 4) {
          crossable[x][y] = false;
        }
      }
    }
  }
  // sets a random number of passes for expansion of the walls
  int passes = (int) 10;
  // then pass some time through the tiles
  // and sets it to wall if it has a lot of neighbors
  for (int i = 0; i < passes; i++) {
    for (int x = 0; x < nbTilesX; x++) {
      for (int y = 0; y < nbTilesY; y++) {
        if (nbSurroundingWallsOf(x, y) >= random(10)) {
          if (flatAround(x, y) >= random(10)) {
            crossable[x][y] = false;
          }
        }
      }
    }
  }
}

private int flatAround(int xB, int yB) {
  int nbFlat = 0;
  for (int x = -1; x < 2; x++) {
    for (int y = -1; y < 2; y++) {
      // don't check the tile itself
      if (x != 0 || y != 0) {
        // don't check if it goes out of the screen
        if (xB + x >= 0 && yB + y >= 0 && xB + x < nbTilesX
          && yB + y < nbTilesY) {
          // if it's the same highness
          if (highness[x + 1][y + 1] == highness[xB][yB]) {
            nbFlat++;
          }
        }
      }
    }
  }
  return nbFlat;
}

private int nbSurroundingWallsOf(int xBase, int yBase) {
  // calculates the number of surrounding walls around a tile
  int nbOfSur = 0;
  for (int x = -1; x < 2; x++) {
    for (int y = -1; y < 2; y++) {
      // don't check the tile itself
      if (x != 0 || y != 0) {
        // don't check if it goes out of the screen
        if (xBase + x >= 0 && yBase + y >= 0
          && xBase + x < nbTilesX && yBase + y < nbTilesY) {
          if (!crossable[xBase + x][yBase + y]) {
            nbOfSur++;
          }
        }
      }
    }
  }
  return nbOfSur;
}

private void displayHighness() {
  // displays a highness map on the screen, just for checking purposes
  background(0);
  for (int x = 0; x < nbTilesX; x++) {
    for (int y = 0; y < nbTilesY; y++) {
      stroke(highness[x][y] * 0xFF / 8);
      point(x, y);
    }
  }
}

private void displayCrossable() {
  // displays a crossable map on the screen, just for checking purposes
  background(0);
  for (int x = 0; x < nbTilesX; x++) {
    for (int y = 0; y < nbTilesY; y++) {
      if (crossable[x][y]) {
        stroke(0xFF);
      } 
      else {
        stroke(0x00);
      }
      point(x, y);
    }
  }
}

private void generateHighness() {
  // sets random parameters for a perlin noise
  float noiseScale = 0.15f;
  noiseDetail((int) random(10), random(1));
  noiseSeed((int) random(0xFF));
  // and use the perlin noise to generate high values on the map
  for (int x = 0; x < nbTilesX; x++) {
    for (int y = 0; y < nbTilesY; y++) {
      highness[x][y] = (int) (noise(x * noiseScale, y * noiseScale) * 8);
      highness[x][y] = constrain(highness[x][y], 0, 7);
    }
  }
}

public void draw() {
  displayTiles();
}

private void displayTiles() {
  // displays the map as seen in the game
  for (int x = 0; x < nbTilesX; x++) {
    for (int y = 0; y < nbTilesY; y++) {
      for (int i = 0; i < 4; i++) {
        for (int x2 = 0; x2 < tileSize / 2; x2++) {
          for (int y2 = 0; y2 < tileSize / 2; y2++) {
            stroke(tileset.get((int) (id[x][y][i] / 4)
              * tileSize + x2 + ((i % 2) * tileSize / 2),
            (int) (id[x][y][i] % 4) * tileSize + y2
              + (int) ((i / 2) * tileSize / 2)));
            point(x * tileSize + x2 + ((i % 2) * tileSize / 2),
            y * tileSize + y2
              + (int) ((i / 2) * tileSize / 2));
          }
        }
      }
    }
  }
}

public void mousePressed() {
  generateHighness();
  generateCrossable();
  setsRightIds();
}

