
double[][][][] performDFT(double[][] input, int windowPower) {

  int nbChannels = input.length;
  int wLength = (int)pow(2, windowPower);

  double[][][][] result = new double[2][nbChannels][][];// value type, channel, partial, part

  for (int c=0 ; c<nbChannels ; c++) {

    int sLength = input[c].length;

    int nbParts = ceil(sLength/wLength);
    int nbHarm = wLength;// for audible part only, put int nbHarm=ceil(wLength/2);

    float[][] sinPart = new float[nbHarm][nbParts];
    float[][] cosPart = new float[nbHarm][nbParts];  
    for (int partial=0;partial<nbHarm;partial++) {
      for (int part=0;part<nbParts;part++) {
        sinPart[partial][part]=0;
        cosPart[partial][part]=0;
        for (int i=0;i<wLength;i++) {
          float phasor=(float)(i+part*wLength)*partial*TWO_PI/wLength;
          sinPart[partial][part]+=input[c][(i+part*wLength)%sLength]*sin(phasor);
          cosPart[partial][part]+=input[c][(i+part*wLength)%sLength]*cos(phasor);
        }
      }
    }

    //getting frequency magnitude and phase
    result[0][c] = new double[nbHarm][nbParts]; // magnitude
    result[1][c] = new double[nbHarm][nbParts]; // phase
    for (int partial=0;partial<nbHarm;partial++) {
      for (int part=0;part<nbParts;part++) {
        // frequency is (float)partial*sampleRate/(float)wLength
        result[0][c][partial][part] = 2.0*sqrt(sq(sinPart[partial][part])+sq(cosPart[partial][part]))/(float)wLength;
        // value in db is 20.0*log10(magn[partial][part])
        result[1][c][partial][part] = atan2(cosPart[partial][part], sinPart[partial][part]);
      }
    }
  }

  return result;
}

double[][] resynthDFT(double[][][][] input, int windowPower) {
  int wLength = (int)pow(2, windowPower);
  int nbChannels = input[0].length;
  double[][] sample= new double[nbChannels][];
  for (int c=0 ; c<nbChannels ; c++) {
    double[][] magn = input[0][c];
    double[][] phas = input[1][c];  
    int sLength = wLength*magn[0].length;
    int nbHarm = magn.length;
    sample[c] = new double[sLength];
    for (int i=0;i<sLength;i++) {
      sample[c][i] = 0;
    }
    for (int i=0;i<sLength;i++) {
      int cPart = floor((float)i/(wLength));//which part of the sample are we in
      int cPartS = i%(wLength);//which sample on this part
      double thisSample=0;
      for (int partial=0;partial<nbHarm;partial++) {
        double phasor = (double)cPartS*TWO_PI*partial/wLength+phas[partial][cPart];
        thisSample += Math.sin(phasor)*magn[partial][cPart];
      }
      sample[c][i]=thisSample;
    }
  }
  return sample;
}

