
void setup() {
  WavFile wavFileToTest1 = WavFile.readFromFilePath(getDialogFileUrl("file A"));
  WavFile wavFileToTest2 = WavFile.readFromFilePath(getDialogFileUrl("file B"));
  String folder = getDialogFileUrl("save to folder");
  double[][] waveForm1 = wavFileToTest1.samplesAsDouble();
  double[][] waveForm2 = wavFileToTest2.samplesAsDouble();
  double[][] convolved = convolveFFT(waveForm1, waveForm2, 8);
  convolved = normalizeArray(convolved);
  wavFileToTest1.setSamplesFromDouble(convolved);
  wavFileToTest1.writeToFilePath(folder+"convolved.wav");
  double[][] ringMod = ringMod(waveForm1, waveForm2);
  ringMod = normalizeArray(ringMod);
  wavFileToTest1.setSamplesFromDouble(ringMod);  
  wavFileToTest1.writeToFilePath(folder+"ringMod.wav");  
  double[][] ampMod = ampMod(waveForm1, waveForm2);
  ampMod = normalizeArray(ampMod);
  wavFileToTest1.setSamplesFromDouble(ampMod);  
  wavFileToTest1.writeToFilePath(folder+"ampMod.wav");
}

void draw() {
}

