
double[][] normalizeArray(double[][] input) {
  double[][] result = new double[input.length][];
  for (int i=0;i<input.length;i++) {
    result[i] = new double[input[i].length];
  }
  double higherValue = 0;
  for (int i=0;i<input.length;i++) {
    for (int j=0;j<input[i].length;j++) {
      if (abs(input[i][j]) > higherValue) higherValue = abs(input[i][j]);
    }
  }
  for (int i=0;i<input.length;i++) {
    for (int j=0;j<input[i].length;j++) {
      result[i][j] = input[i][j] / higherValue;
    }
  }
  return result;
}

double[][] invertArray(double[][] input) {
  double[][] inverted = new double[input.length][];
  for (int i=0;i<input.length;i++) {
    inverted[i] = new double[input[i].length];
    for (int j=0;j<input[i].length;j++) {
      inverted[i][j] = input[i][input[i].length-j-1];
    }
  }
  return inverted;
}

double abs(double value) {
  if (value<0) value *= -1;
  return value;
}

double[][] simpleIRFilter(double[][] input, float feedback) {
  feedback = sqrt(feedback);
  double[][] output = new double[input.length][];
  for (int i=0;i<input.length;i++) {
    output[i] = new double[input[i].length];
    for (int j=0;j<input[i].length;j++) {
      output[i][j] = input[i][j] * (1-feedback);
      output[i][j] += output[i][max(j-1, 0)] * feedback;
    }
  }
  return output;
}

double[][] addArrays(double[][] inputA, double[][] inputB) {
  double[][] result = new double[max(inputA.length, inputB.length)][];
  for (int c=0 ; c<result.length ; c++) {
    result[c] = new double[max(inputA[c].length, inputB[c].length)];
    for (int i=0 ; i<result[c].length ; i++) {
      result[c][i] = inputA[c][i%inputA[c].length] + inputB[c][i%inputB[c].length];
    }
  }
  return result;
}

double[][] invertPhase(double[][] inputA) {
  double[][] result = new double[inputA.length][];
  for (int c=0 ; c<result.length ; c++) {
    result[c] = new double[inputA[c].length];
    for (int i=0 ; i<result[c].length ; i++) {
      result[c][i] = inputA[c][i] * -1;
    }
  }
  return result;
}

double[][] ringMod(double[][] inputA, double[][] inputB) {
  double[][] result = new double[max(inputA.length, inputB.length)][];
  for (int c=0 ; c<result.length ; c++) {
    result[c] = new double[max(inputA[c].length, inputB[c].length)];
    for (int i=0 ; i<result[c].length ; i++) {
      result[c][i] = inputA[c][i%inputA[c].length] * inputB[c][i%inputB[c].length];
    }
  }
  return result;
}

double[][] ampMod(double[][] inputA, double[][] inputB) {
  double[][] result = new double[max(inputA.length, inputB.length)][];
  for (int c=0 ; c<result.length ; c++) {
    result[c] = new double[max(inputA[c].length, inputB[c].length)];
    for (int i=0 ; i<result[c].length ; i++) {
      result[c][i] = inputA[c][i%inputA[c].length] * abs(inputB[c][i%inputB[c].length]);
    }
  }
  return result;
}

double[][] arrayOfSize(double[][] input) {
  double[][] output = new double[input.length][];
  for (int i=0;i<input.length;i++) {
    output[i] = new double[input[i].length];
  }
  return output;
}

Complex[][][] performFFT(double[][] input, int windowPower) {
  int nbChannels = input.length;
  int wLength = (int)pow(2, windowPower);
  Complex[][][] result = new Complex[nbChannels][][];// [channel][part][partial]
  for (int c=0 ; c<nbChannels ; c++) {
    int sLength = input[c].length;
    int nbParts = ceil(sLength/wLength);
    result[c] = new Complex[nbParts][];
    for (int i=0;i<nbParts;i++) {
      Complex[] thisChunk = new Complex[wLength];
      for (int j = 0 ; j < wLength ; j++) {
        thisChunk[j] = new Complex(input[c][(j+i*wLength)%sLength], 0);
      }
      Complex[] thisFFT = FFT.fft(thisChunk);
      result[c][i] = new Complex[thisFFT.length];
      for (int j=0;j<thisFFT.length;j++) result[c][i][j] = thisFFT[j];
    }
  }
  return result;
}

double[][] resynthFFT(Complex[][][] input, int windowPower) {
  int wLength = (int)pow(2, windowPower);
  int nbChannels = input.length;
  double[][] sample= new double[nbChannels][];
  for (int c=0 ; c<nbChannels ; c++) {
    int nbParts = input[c].length;
    int sLength = wLength*nbParts;
    int nbHarm = input[c][0].length;
    sample[c] = new double[sLength];
    for (int i=0;i<sLength;i++) {
      sample[c][i] = 0;
    }
    for (int p=0;p<nbParts;p++) {
      Complex[] thisPart = FFT.ifft(input[c][p]);
      for (int i=0;i<thisPart.length;i++) {
        sample[c][p*wLength+i] = thisPart[i].re();
      }
    }
  }
  return sample;
}

double[][][][] shiftDFT(double[][][][] input, int amount) {
  double[][][][] result = new double[input.length][][][];
  for (int v=0;v<input.length;v++) {
    result[v] = new double[input[v].length][][];
    for (int c=0;c<input[v].length;c++) {
      result[v][c] = new double[input[v][c].length][];
      for (int h=0;h<input[v][c].length;h++) {
        result[v][c][h] = new double[input[v][c][h].length];
        for (int p=0;p<input[v][c][h].length;p++) {
          result[v][c][h][p] = input[v][c][(h+amount)%input[v][c].length][p];
        }
      }
    }
  }
  return result;
}

double[][] convolveFFT(double[][] inputA, double[][] inputB, int windowPower) {
  int nbChannels = max(inputA.length, inputB.length);
  int wLength = (int)pow(2, windowPower);
  double[][] result = new double[nbChannels][];// [channel][sample]
  for (int c=0 ; c<nbChannels ; c++) {
    int sLengthA = inputA[c%inputA.length].length;
    int sLengthB = inputB[c%inputB.length].length;
    int sLength = max(sLengthA, sLengthB);
    int nbParts = ceil(sLength/wLength);
    result[c] = new double[nbParts*wLength];
    for (int i=0;i<nbParts;i++) {
      Complex[] thisChunkA = new Complex[wLength];
      Complex[] thisChunkB = new Complex[wLength];      
      for (int j = 0 ; j < wLength ; j++) {
        thisChunkA[j] = new Complex(inputA[c][(j+i*wLength)%sLengthA], 0);
        thisChunkB[j] = new Complex(inputB[c][(j+i*wLength)%sLengthB], 0);
      }
      Complex[] thisFFT = FFT.convolve(thisChunkA, thisChunkB);
      for (int j=0 ; j < wLength ; j++) result[c][i*wLength+j] = thisFFT[j*2].re();
    }
  }
  return result;
}

