
ArrayList<Node> nodes = new ArrayList<Node>();

int nbRoads = 3;
Pathfound[] paths = new Pathfound[nbRoads];

void setup() {
  size(700, 700);
  frameRate(30);
  colorMode(HSB);
  int nbNodes = 100;
  for (int i=0;i<nbNodes;i++) {
    nodes.add(new Node(new PVector(random(width), random(height))));
  }
  Node[] startingNodes = new Node[nbRoads];
  Node[] endingNodes = new Node[nbRoads];
  for (int i=0;i<nbRoads;i++) {
    Node randomNode=null;
    while (arrayContains (startingNodes, randomNode)||arrayContains(endingNodes, randomNode)) randomNode=nodes.get(floor(random(nodes.size())));
    startingNodes[i] = randomNode;
    while (arrayContains (startingNodes, randomNode)||arrayContains(endingNodes, randomNode)) randomNode=nodes.get(floor(random(nodes.size())));
    endingNodes[i] = randomNode;
  }
  for (int i=0;i<nbRoads;i++) paths[i] = new Pathfound((float)i/nbRoads*0x100, startingNodes[i], endingNodes[i]);
}

<T>boolean arrayContains(T[] haystack, T object) {
  for (T element : haystack) if (object==element) return true;
  return false;
}

void draw() {
  for (int i=0;i<nbRoads;i++) paths[i].computePath(nodes);
  for (int i=0;i<nodes.size();i++) nodes.get(i).update();
  background(0xFF);
  ArrayList<Link> drawnLinks = new ArrayList<Link>();
  for (int i=0;i<nodes.size();i++) nodes.get(i).drawLinks(drawnLinks);
  for (int i=0;i<nodes.size();i++) nodes.get(i).draw();
  for (int i=0;i<nbRoads;i++) paths[i].draw();
}

class Node {
  PVector pos;
  PVector dir;
  ArrayList<Node> neighbours = new ArrayList<Node>();
  float distance=0;
  Node(PVector pos) {
    this.pos=pos;
    this.dir=new PVector(random(-3, 3), random(-3, 3));
  }
  void updateNeighbours() {
    for (Node node:neighbours) node.neighbours.remove(this);
    neighbours = new ArrayList<Node>();
    float threshold=0;
    while (neighbours.size ()<=2) {
      threshold+=5;
      for (Node node:nodes) {
        if (!neighbours.contains(node)) {
          if (PVector.dist(node.pos, pos)<threshold&&node!=this) {
            neighbours.add(node);
            node.neighbours.add(this);
          }
        }
      }
    }
  }
  void update() {
    if (pos.x<=0||pos.x>=width) dir.x*=-1;
    if (pos.y<=0||pos.y>=width) dir.y*=-1;
    pos.add(dir);
    distance+=dir.mag();
    if (distance>150||neighbours.size()==0) {
      distance=0;
      updateNeighbours();
    }
  }
  void draw() {
    stroke(0xE0);
    fill(0xFF);
    ellipse(pos.x, pos.y, 10, 10);
  }
  void drawLinks(ArrayList<Link> drawn) {
    stroke(0xE0);
    for (Node neighbour : neighbours) {
      if (!hasLink(drawn, this, neighbour)) {
        line(pos.x, pos.y, neighbour.pos.x, neighbour.pos.y);
        drawn.add(new Link(this, neighbour));
      }
    }
  }
}

class Link {
  Node a, b;
  Link (Node a, Node b) {
    this.a=a;
    this.b=b;
  }
}

boolean hasLink(ArrayList<Link> list, Node a, Node b) {
  for (Link link:list) {
    if (link.a==a) if (link.b==b) return true;
    if (link.b==a) if (link.a==b) return true;
  } 
  return false;
}

class ScoredNode {
  Node node;
  ScoredNode cameFrom;
  float score;
  float esScore;
  ScoredNode(Node node, ScoredNode cameFrom, float score, float estimatedRest) {
    this.cameFrom=cameFrom;
    this.node=node;
    this.score=score;
    this.esScore=score+estimatedRest;
  }
}

class Pathfound {
  Node startingNode, endingNode;
  ArrayList<Node> visited;
  ArrayList<Node> bestPath;
  float hue;
  Pathfound(float hue, Node startingNode, Node endingNode) {
    this.hue=hue;
    this.startingNode=startingNode;
    this.endingNode=endingNode;
  }
  void computePath(ArrayList<Node> nodes) {
    visited = new ArrayList<Node>();
    bestPath = new ArrayList<Node>();
    ArrayList<ScoredNode> openSet = new ArrayList<ScoredNode>();
    openSet.add(new ScoredNode(startingNode, null, 0, sqDist(startingNode.pos, endingNode.pos)));
    while (openSet.size ()>0) {
      ScoredNode current = openSet.get(0);
      for (ScoredNode node:openSet) if (node.esScore<current.esScore) current=node;
      if (current.node==endingNode) {
        ScoredNode currentNode=current;
        while (currentNode!=null) {          
          bestPath.add(0, currentNode.node);
          currentNode = currentNode.cameFrom;
        }
        return;
      }
      visited.add(current.node);
      openSet.remove(current);
      for (Node node:current.node.neighbours) {
        if (!visited.contains(node)) {
          float score = current.score+sqDist(current.node.pos, node.pos);
          Node nInOpenSet;
          for (ScoredNode osNode:openSet) if (osNode.node==node) nInOpenSet=osNode;
          if (nInOpenSet==null) {
            openSet.add(new ScoredNode(node, current, score, sqDist(node.pos, endingNode.pos)));
          } else if (score<nInOpenSet.score) {
            nInOpenSet.cameFrom=current;
            nInOpenSet.estimatedRest-=(nInOpenSet.score-score);
            nInOpenSet.score=score;
          }
        }
      }
    }
    return;
  }
  void draw() {
    stroke(hue, 0xFF, 0xFF);
    fill(0xFF);
    if (bestPath.size()>0) fill(hue, 0xFF, 0xFF);  
    ellipse(startingNode.pos.x, startingNode.pos.y, 20, 20);
    ellipse(endingNode.pos.x, endingNode.pos.y, 20, 20);
    for (int i=0;i<bestPath.size()-1;i++) {
      line(bestPath.get(i).pos.x, bestPath.get(i).pos.y, bestPath.get(i+1).pos.x, bestPath.get(i+1).pos.y);
    }
    noFill();
    stroke(hue, 0xFF, 0xFF, 0x50);
    for (int i=0;i<visited.size();i++) {
      ellipse(visited.get(i).pos.x, visited.get(i).pos.y, 3, 3);
    }
  }
}

float sqDist(PVector a, PVector b) {
  return abs(b.x-a.x)+abs(b.y-a.y);
}


