
import krister.Ess.*;

int nbSeq=4;//nombre de squences (il y en aura 4)

float longMes=512;//Longueur de la squence (= aussi taille en pxl)
float margeGauche;
int freqEchant=10000;//frequence d'chantillonnage
int taiSamp=freqEchant/5;//taille d'un son, en chantillons

float cursVit=10;//vitesse du curseur (tempo)

Seqs[] seq=new Seqs[nbSeq];

PGraphics[] pg=new PGraphics[nbSeq+1];
AudioChannel[][] chan= new AudioChannel[4][8];//[Seq][Note]

float cursPos=0;//position du curseur;

class Notes {//Notes (monstres)
  float pos;//position de la note sue la squence
  float[] son= new float[taiSamp];
  boolean joue;
  boolean actif;
  int nb;

  Notes(int nb, float pos) {
    this.nb=nb;
    this.pos=pos;
    actif=false;
    if (random(100)<40) {
      actif=true;
    }
    float freq=100*ceil(random(13));
    int synType=floor(random(4));
    for (int i=0;i<taiSamp;i++) {
      if (synType==0) {
        son[i]=sin(i*TWO_PI/(freqEchant/freq))/2;
      }
      if (synType==1) {
        if (sin(i*TWO_PI/(freqEchant/freq))>0) {
          son[i]=0.5;
        }
        else {
          son[i]=-0.5;
        }
      }
      if (synType==2) {
        son[i]=sin(i*TWO_PI/(freqEchant/freq)+sin(2*i*TWO_PI/(freqEchant/freq)))/2;
      }
      if (synType==3) {
        son[i]=sin(i*TWO_PI/(freqEchant/freq)+random(0.1))/2;
      }
    }
  }
}

class Seqs {//Squence
  int nb;
  int nbNotes=8;//nb de notes (8 maxi par Sequence)
  Notes[] note = new Notes[nbNotes];//8 notes maxi par squence

  Seqs(int nb) {
    this.nb=nb;
    for (int i=0;i<nbNotes;i++) {
      note[i]=new Notes(i,longMes/nbNotes*i);
    }  
    assigneSons();
  }

  void GMAJ() {
    pg[nb].beginDraw();
    pg[nb].background(0,0);
    for (int i=0;i<nbNotes;i++) {
      dessineNote(i);
    }
    pg[nb].endDraw();
  }

  void dessineNote(int i) {
    if (note[i].joue==true) {
      pg[nb].fill(255,0,0);
      pg[nb].ellipse(note[i].pos+margeGauche,pg[nb].height/2,pg[nb].height/2,pg[nb].height/2);
      pg[nb].fill(0);
      pg[nb].ellipse(note[i].pos+margeGauche-margeGauche/10,margeGauche-margeGauche/10,margeGauche/20,margeGauche/20);
      pg[nb].ellipse(note[i].pos+margeGauche+margeGauche/10,margeGauche-margeGauche/10,margeGauche/20,margeGauche/20);
      pg[nb].ellipse(note[i].pos+margeGauche,margeGauche+margeGauche/8,margeGauche/5,margeGauche/5);
    }
    else {
      pg[nb].fill(255);
      pg[nb].ellipse(note[i].pos+margeGauche,pg[nb].height/2,pg[nb].height/2,pg[nb].height/2);
      pg[nb].fill(0);
      pg[nb].ellipse(note[i].pos+margeGauche-margeGauche/10,margeGauche-margeGauche/10,margeGauche/20,margeGauche/20);
      pg[nb].ellipse(note[i].pos+margeGauche+margeGauche/10,margeGauche-margeGauche/10,margeGauche/20,margeGauche/20);
      pg[nb].ellipse(note[i].pos+margeGauche,margeGauche+margeGauche/8,margeGauche/5,margeGauche/20);
    }
    if (note[i].actif==false) {
      pg[nb].fill(0);
      pg[nb].ellipse(note[i].pos+margeGauche,pg[nb].height/2,pg[nb].height/2,pg[nb].height/2);
    }
  }

  void verifNotes() {
    for (int i=0;i<nbNotes;i++) {
      if (note[i].actif==true) {
        note[i].joue=false;
        if (note[i].pos>=cursPos && note[i].pos<=cursPos+cursVit) {
          note[i].joue=true;
        }
        if (cursPos+cursVit>=longMes && note[i].pos<=(cursPos+cursVit)-longMes) {
          note[i].joue=true;
        }
        if (note[i].joue==true) {
          chan[nb][i].play(1);
        }
      }
    }
  }

  void assigneSons() {
    for (int i=0;i<nbNotes;i++) {
      chan[nb][i].initChannel(note[i].son.length);
      for (int i2=0;i2<note[i].son.length;i2++) {
        chan[nb][i].samples[i2]=note[i].son[i2];
      }
    }
  }
}

void setup() {
  size(600,200);
  frameRate(30);
  margeGauche=(height/nbSeq)/2;
  Ess.start(this);

  for (int i=0;i<4;i++) {
    for (int i2=0;i2<8;i2++) {
      chan[i][i2]=new AudioChannel();
      chan[i][i2].sampleRate(freqEchant);
    }
  }

  for (int i=0;i<nbSeq;i++){
    seq[i]=new Seqs(i);
  }
  for (int i=0;i<nbSeq;i++){
    pg[i]=createGraphics(ceil(longMes),height/nbSeq,JAVA2D);
    pg[i].beginDraw();
    pg[i].smooth();
    pg[i].endDraw();
  }
  pg[nbSeq]=createGraphics(ceil(longMes),height,JAVA2D);
  pg[nbSeq].beginDraw();
  pg[nbSeq].smooth();
  pg[nbSeq].endDraw();
}

void draw() {
  cursPos=(cursPos+cursVit)%longMes;
  background(0);
  dessineCurs();
  for (int i=0;i<nbSeq;i++) {
    seq[i].verifNotes();
    stroke(100);
    seq[i].GMAJ();
    image(pg[i],0,height*i/nbSeq);
  }
}

void dessineCurs() {
  pg[nbSeq].beginDraw();
  pg[nbSeq].background(0,0);
  pg[nbSeq].stroke(255);
  pg[nbSeq].rect(cursPos+margeGauche,0,cursVit,height);  
  pg[nbSeq].endDraw();
  image(pg[nbSeq],0,0);
}

public void stop() {
  Ess.stop();
  super.stop();
}

