
int[][] state;
// 0 = background
// 1 = picture
// 2 = taken

PImage input;

float whiteThreshold = 0xE0;
int minPicSize = 100;

import java.awt.FileDialog;

ArrayList parts = new ArrayList();

String folderName;

void setup() {
  input = loadImage(getAFile("load image"));
  state = new int[input.width][input.height];
  for (int x=0;x<input.width;x++) {
    for (int y=0;y<input.height;y++) {
      state[x][y] = 1;
      if (brightness(input.get(x, y)) >= whiteThreshold) state[x][y] = 0;
      if (x==0 || y==0) state[x][y] = 0;
      if (x==input.width-1 || y==input.height-1) state[x][y] = 0;
    }
  }
  for (int y=0;y<input.height;y++) {
    println("find pic for y:"+nf(y, 5)+" / "+nf(input.height, 5));
    for (int x=0;x<input.width;x++) {
      if (state[x][y]==0) findPicFrom(x, y);
    }
  }
  // saveStateMap();
  onVoitEncoreTonVisage();
  exportPictures();
}

void exportPictures() {
  for (int i=0;i<parts.size();i++) {
    int x1 = ((Splitted)parts.get(i)).x1;
    int y1 = ((Splitted)parts.get(i)).y1;
    int x2 = ((Splitted)parts.get(i)).x2;
    int y2 = ((Splitted)parts.get(i)).y2; 
    println(x1+" "+y1+" "+x2+" "+y2+" ");
    PImage toExport = createImage(x2-x1, y2-y1, RGB);
    for (int x=x1;x<x2;x++) {
      for (int y=y1;y<y2;y++) {
        toExport.set(x-x1, y-y1, input.get(x, y));
      }
    }
    toExport.save(folderName+"/split"+nf(i, 3)+".png");
  }
}

void onVoitEncoreTonVisage() {
  for (int i=0;i<parts.size();i++) {
    println("expanding surface for part " + i + " out of " + parts.size());
    int bestSurface=-1;
    int bestX=0;
    int bestY=0;
    int x1=((Splitted)parts.get(i)).x1;
    int y1=((Splitted)parts.get(i)).y1;
    int x2=((Splitted)parts.get(i)).x2;
    int y2=((Splitted)parts.get(i)).y2;
    for (int x=x2 ; x<input.width ; x++) {
      for (int y=y2 ; y<input.height ; y++) {
        if (notTakenFrom(x1, y1, x, y, x2, y2)) {
          int thisSurface=(x-x1)*(y-y1);
          if (thisSurface >= bestSurface) {
            bestSurface = thisSurface;
            bestX = x;
            bestY = y;
          }
        }
      }
    }
    if (bestSurface!=-1) {
      ((Splitted)parts.get(i)).x2=bestX;
      ((Splitted)parts.get(i)).y2=bestY;
    }
  }
}

boolean notTakenFrom(int x1, int y1, int x2, int y2, int x3, int y3) {
  boolean free = true;
  for (int x=x1 ; x<x2 && free ; x++) {
    for (int y=y1 ; y<y2 && free ; y++) {
      if (x >= x3 || y >= y3) {
        if (state[x][y]==2) free=false;
      }
    }
  }
  return free;
}

class Splitted {
  public int x1, x2, y1, y2;
  Splitted(int x1, int y1, int x2, int y2) {
    this.x1=x1;
    this.y1=y1;
    this.x2=x2;
    this.y2=y2;
  }
}

void saveStateMap() {
  PImage sMap = createImage(input.width, input.height, RGB);
  for (int x=0;x<input.width;x++) {
    for (int y=0;y<input.height;y++) {
      sMap.set(x, y, color(floor((float)state[x][y]/3*0xFF)));
    }
  }
  sMap.save("stateMap.png");
}

void findPicFrom(int fromX, int fromY) {
  int maxX=state.length;
  int maxY=state[0].length;
  for (int x=fromX+minPicSize;x<maxX;x++) {
    if (state[x][fromY]!=0) maxX=x;
    for (int y=fromY+minPicSize;y<maxY;y++) {
      if (state[fromX][y]!=0) maxY=y;
      if (linesAreBack(fromX, fromY, x, y)) {
        saveSplitFor(fromX, fromY, x, y);
        x=maxX;
        y=maxY;
      }
    }
  }
}

void saveSplitFor(int x1, int y1, int x2, int y2) {
  for (int x=x1;x<x2;x++) {
    for (int y=y1;y<y2;y++) {
      if (x>x1 && y>y1 && x<x2-1 && y<y2-1) state[x][y] = 2;
    }
  }
  parts.add(new Splitted(x1, y1, x2, y2));
}

boolean linesAreBack(int x1, int y1, int x2, int y2) {
  boolean toutVaBien = true;
  for (int x=x1;x<=x2;x++) if (state[x][y1]!=0) toutVaBien=false;
  for (int x=x1;x<=x2;x++) if (state[x][y2]!=0) toutVaBien=false;
  for (int y=y1;y<=y2;y++) if (state[x1][y]!=0) toutVaBien=false;
  for (int y=y1;y<=y2;y++) if (state[x2][y]!=0) toutVaBien=false;
  return toutVaBien;
}

String getAFile(String label) {
  Frame frame = new Frame();
  FileDialog fileDialog = new FileDialog(frame, label, FileDialog.LOAD);
  fileDialog.setVisible(true);
  if (fileDialog.getFile()!=null) {
    folderName=withoutExt(fileDialog.getFile());
    String filePath = fileDialog.getDirectory() + fileDialog.getFile();
    return filePath;
  }
  return null;
}

String withoutExt(String in) {
  for (int i=in.length()-1;i>=0;i--) {
    if (in.charAt(i)=='.') return in.substring(0, i);
  }
  return in;
}

