PImage[] ims;
String[] imsUrl;
String[] dirs;
int currentDir = 0;
PVector[] imPos;
float thumbSize = 100;
int chosenPict = 0;
PImage[] thumbPics;
float offsetY = 0;

void setup() {
  size(1000, 600);
  dirs = loadStrings("listDirs.php?dir=posts");
  loadPost("posts/"+dirs[currentDir]);
  loadThumbs();
}

int frame=0;
void draw() {
  background(0xFF);
  for (int i=0;i<ims.length;i++) {
    noStroke();
    fill(0);
    rect(imPos[i].x, imPos[i].y + offsetY, thumbSize, thumbSize);
    if (ims[i].width>0) image(ims[i], imPos[i].x, imPos[i].y + offsetY, thumbSize, thumbSize);
  }
  noStroke();
  fill(0xFF);
  rect(0, 0, width, 70);
  rect(0, 500, width, height-500);
  fill(0);
  if (offsetY < 0) triangle(150, 65, 160, 55, 170, 65);
  triangle(150, 505, 160, 515, 170, 505);
  for (int i=0;i<thumbPics.length;i++) {
    if (thumbPics[i].width>0) image(thumbPics[i], 10+35*i, 10, 30, 30);
  }
  if (ims[chosenPict].width>0) {
    float maxDim = 400/(float)max(ims[chosenPict].width, ims[chosenPict].height);
    image(ims[chosenPict], 350, 50, ims[chosenPict].width*maxDim, ims[chosenPict].height*maxDim);
  }
  if (mousePressed) {
    if (mouseX<350) {
      if (mouseY>=55 && mouseY<=65) offsetY=min(offsetY+10, 0);
      if (mouseY>=505 && mouseY<=515) offsetY=offsetY-10;
    }
  }
  frame++;
}

void loadPost(String dir) {
  String[] picts = loadStrings("listDirs.php?dir="+dir+"/img/");
  int cols = 3;
  ims = new PImage[picts.length];
  imsUrl = new String[picts.length];
  for (int i=0;i<ims.length;i++) {
    ims[i] = requestImage(dir+"/img/"+picts[i]);
    imsUrl[i] = dir+"/img/"+picts[i];
  }
  imPos = new PVector[ims.length];
  for (int i=0;i<ims.length;i++) {
    imPos[i] = new PVector(10+(i%cols)*110, 70 + floor(i/cols)*110);
  }
  try {
    String[] thisText = loadStrings(dir+"/text.html");
    String htmlText = "";
    for (int i=0;i<thisText.length;i++) {
      htmlText += thisText[i] + "\r\n";
    }
    document.getElementById("text").innerHTML = htmlText;
  } 
  catch (Exception e) {
    document.getElementById("text").innerHTML = "";
  }
}

void loadThumbs() {
  thumbPics = new PImage[dirs.length];
  for (int i=0;i<thumbPics.length;i++) {  
    String[] picts = loadStrings("listDirs.php?dir=posts/"+dirs[i]+"/img/");
    thumbPics[i] = requestImage("posts/"+dirs[i]+"/img/"+picts[0]);
  }
}

void vertexRect(float x, float y, float w, float h) {
  beginShape();
  vertex(x, y);
  vertex(x+w, y);
  vertex(x+w, y+h);
  vertex(x, y+h);
  endShape();
}

void mousePressed() {
  for (int i=0;i<ims.length;i++) {
    if (mouseX>=imPos[i].x && mouseY>=offsetY+imPos[i].y && mouseX<=imPos[i].x+thumbSize && mouseY<=offsetY+imPos[i].y+thumbSize && mouseY<505 && mouseY>65) {
      chosenPict=i;
    }
  }
  if (mouseY<=40) {
    int currentDir = 0;
    if (mouseX<floor(10+35*dirs.length)) currentDir = floor(((float)mouseX-10)/35);
    currentDir=(currentDir)%dirs.length;
    loadPost("posts/"+dirs[currentDir]);
    chosenPict=0;
    offsetY=0;
    mousePressed=false;
  }
  if (mouseX>350) {
    window.open(imsUrl[chosenPict]);
  }
}



