
PFont font;
String[] textContent;
int t=0;

int currentCharIndex = 0;
int currentLineIndex = 0;
int currentEffect;
color textColor;

PImage bufferEffect;

import oscP5.*;
import netP5.*;

OscP5 oscP5;
NetAddress myRemoteLocation;

void setup() {
  size(300, 300, JAVA2D);
  frameRate(15);
  colorMode(RGB);
  noSmooth();
  textColor=color(0);
  frame.setResizable(true);
  font = loadFont("PixelArial11-16.vlw");
  textFont(font);
  textAlign(CENTER, CENTER);
  background(0);
  reloadText();

  oscP5 = new OscP5(this, 12000);
  myRemoteLocation = new NetAddress("127.0.0.1", 12001);
}

void draw() {
  if ((t%30)==0) reloadText();
  if ((t%100)==0 && textContent.length>0) {
    currentLineIndex++;
    currentLineIndex = (currentLineIndex)%textContent.length;
    for (int i=0;i<textContent[currentLineIndex].length();i++) { 
      OscMessage myOscMessage = new OscMessage("/playEffect");
      myOscMessage.add((int)textContent[currentLineIndex].charAt(i));
      oscP5.send(myOscMessage, myRemoteLocation);
    }
  }
  currentLineIndex = (currentLineIndex)%textContent.length;
  fill(textColor);
  stroke(textColor); 
  if (textContent.length>0) {
    if (textContent[currentLineIndex].length()>0) {
      textSize((width+height)/50);
      text(textContent[currentLineIndex], 20, 20, width-40, height-40);
      currentCharIndex=(currentCharIndex+1)%textContent[currentLineIndex].length();
      currentEffect=textContent[currentLineIndex].charAt(currentCharIndex);
    }
  }
  effect(currentEffect);
  t++;
  //saveFrame("result/#####.png");// décommenter enregiste les images
}

void reloadText() {
  textContent=loadStrings(dataPath("text.txt"));
}

int fxOffset=2;
void keyPressed() {
  if (keyCode==UP) fxOffset++;
  if (keyCode==DOWN) fxOffset--;
  fxOffset=(fxOffset+27)%27;
  println("fx offset : "+fxOffset);
}


void effect(int effectNumber) {
  if (effectNumber==65279) {
    // rien
  }
  else {
    effectNumber+=fxOffset;//changer chiffre après le = permet un autre mappage des charactere et des effets
    effectNumber=effectNumber%27;
  }
  if (effectNumber==0) {
    stroke(random(0x100));
    int x = floor(random(width));
    int y = floor(random(width));
    for (int x2=0;x2<3;x2++) {
      for (int y2=0;y2<3;y2++) {
        point(x+x2, y+y2);
      }
    }
  }
  if (effectNumber==1) {
    stroke(random(0x100));
    noFill();
    int x = floor(-width/2+random(width*2));
    int y = floor(-height/2+random(height*2));
    int w = floor(random(width/2));
    int h = floor(random(height/2));
    rect(x, y, w, h);
  }
  if (effectNumber==2) {
    stroke(random(0x100));
    noFill();
    int x = floor(-width/2+random(width*2));
    int y = floor(-height/2+random(height*2));
    int w = floor(random(width/2));
    int h = floor(random(height/2));
    copy(floor(-width/2+random(width*2)), floor(-height/2+random(height*2)), floor(random(width/2)), floor(random(height/2)), x, y, w, h);
    rect(x, y, w, h);
  }
  if (effectNumber==3) {
    int sX=floor(random(width/2));
    int sY=floor(random(height/2));
    copy(floor(-width/2+random(width*2)), floor(-height/2+random(height*2)), sX, sY, floor(-width/2+random(width*2)), floor(-height/2+random(height*2)), sX, sY);
  }
  if (effectNumber==4) {
    int m=floor(random(3)+2);
    PImage imTmp = createImage(width, height, HSB);
    loadPixels();
    for (int x=0;x<width;x++) {
      for (int y=0;y<height;y++) {
        imTmp.pixels[x+y*imTmp.width] = pixels[(x*m)%imTmp.width+((y*m)%imTmp.height)*imTmp.width];
      }
    }
    imTmp.updatePixels();
    image(imTmp, 0, 0);
  }
  if (effectNumber==5) {
    int s=4;
    PGraphics grTmp = createGraphics(width, height, JAVA2D);
    grTmp.beginDraw();
    grTmp.noStroke();
    for (int x=0;x<width;x+=s) {
      for (int y=0;y<height;y+=s) {
        grTmp.fill(get(x, y));
        grTmp.rect(x, y, s, s);
      }
    }
    grTmp.endDraw();
    image(grTmp, 0, 0);
  }
  if (effectNumber==6) {
    float mean = 0;
    for (int x=0;x<width;x++) {
      for (int y=0;y<height;y++) {
        mean+=brightness(get(x, y));
      }
    }
    mean/=(width*height);
    for (int x=0;x<width;x++) {
      for (int y=0;y<height;y++) {
        if (brightness(get(x, y))<mean/2) stroke(0);
        else if (brightness(get(x, y))>mean*3/2) stroke(0xFF);
        else stroke(0x7F);
        point(x, y);
      }
    }
  }
  if (effectNumber==7) {
    PImage imTmp = createImage(width, height, RGB);
    loadPixels();
    for (int x=0;x<width;x++) {
      for (int y=0;y<height;y++) {
        imTmp.pixels[x+y*imTmp.width] = color(red(pixels[(1+x+y*imTmp.width)%pixels.length]), green(pixels[(2+x+y*imTmp.width)%pixels.length]), blue(pixels[(3+x+y*imTmp.width)%pixels.length]));
      }
    }
    for (int x=0;x<width;x++) {
      for (int y=0;y<height;y++) {
        pixels[x+y*width] = imTmp.pixels[x+y*width];
      }
    }
    updatePixels();
  }
  if (effectNumber==8) {
    PImage imTmp = createImage(width, height, RGB);
    loadPixels();
    for (int x=0;x<width;x++) {
      for (int y=0;y<height;y++) {
        imTmp.pixels[x+y*imTmp.width] = color(red(pixels[(x+(y+1)*imTmp.width)%pixels.length]), green(pixels[(x+(y+3)*imTmp.width)%pixels.length]), blue(pixels[(x+(y+2)*imTmp.width)%pixels.length]));
      }
    }
    for (int x=0;x<width;x++) {
      for (int y=0;y<height;y++) {
        pixels[x+y*width] = imTmp.pixels[x+y*width];
      }
    }
    updatePixels();
  }
  if (effectNumber==9) {
    PImage imTmp = createImage(width, height, RGB);
    loadPixels();
    imTmp.loadPixels();
    for (int x=0;x<width;x++) {
      for (int y=0;y<height;y++) {
        imTmp.pixels[x+y*imTmp.width] = color(floor(red(pixels[x+y*width]))+floor(red(pixels[(y+x*height)%pixels.length])), 
        floor(green(pixels[x+y*width]))+floor(green(pixels[(y+x*height)%pixels.length])), 
        floor(blue(pixels[x+y*width]))+floor(blue(pixels[(y+x*height)%pixels.length])));
      }
    }
    imTmp.updatePixels();    
    for (int x=0;x<width;x++) {
      for (int y=0;y<height;y++) {
        pixels[x+y*width] = imTmp.pixels[x+y*width];
      }
    }
    updatePixels();
  }  
  if (effectNumber==10) {
    loadPixels();
    for (int x=0;x<width;x++) {
      for (int y=0;y<height;y++) {
        color thisPixel = pixels[x+y*width];
        pixels[x+y*width] = color(constrain(red(thisPixel)+0x1, 0, 0xFF), green(thisPixel), blue(thisPixel));
      }
    }
    updatePixels();
  }  
  if (effectNumber==11) {
    loadPixels();
    for (int x=0;x<width;x++) {
      for (int y=0;y<height;y++) {
        color thisPixel = pixels[x+y*width];
        pixels[x+y*width] = color(red(thisPixel), constrain(green(thisPixel)+0x1, 0, 0xFF), blue(thisPixel));
      }
    }
    updatePixels();
  }
  if (effectNumber==12) {
    loadPixels();
    for (int x=0;x<width;x++) {
      for (int y=0;y<height;y++) {
        color thisPixel = pixels[x+y*width];
        pixels[x+y*width] = color(red(thisPixel), green(thisPixel), constrain(blue(thisPixel)+0x1, 0, 0xFF));
      }
    }
    updatePixels();
  }
  if (effectNumber==13) {
    textColor=color((red(textColor)+random(10))%0x100, (green(textColor)+random(10))%0x100, (blue(textColor)+random(10))%0x100);
  }
  if (effectNumber==14) {
    loadPixels();
    for (int x=0;x<width;x++) {
      for (int y=0;y<height;y++) {
        pixels[x+y*width] = pixels[(x+(y+1)*width)%pixels.length];
      }
    }
  }
  if (effectNumber==15) {
    stroke(random(0x100));
    noFill();
    int x = floor(random(width/20))*20;
    int y = floor(random(height/20))*20;
    int type = floor(random(4));
    if (type==0) triangle(x, y, x+floor(width/20), y, x+floor(width/20), y+floor(height/20));
    if (type==1) triangle(x+floor(width/20), y, x+floor(width/20), y+floor(height/20), x, y+floor(height/20));
    if (type==2) triangle(x+floor(width/20), y+floor(height/20), x, y+floor(height/20), x, y);
    if (type==3) triangle(x, y+floor(height/20), x, y, x+floor(width/20), y);
  }
  if (effectNumber==16) {
    copy(width/2, 0, width/2, height, width/2, floor(-random(height/2)), width/2, height);
  }
  if (effectNumber==17) {
    copy(0, 0, width/2, height, 0, floor(random(height/2)), width/2, height);
  }
  if (effectNumber==18) {
    loadPixels();
    for (int x=0;x<width;x++) {
      for (int y=0;y<height;y++) {
        pixels[x+y*width] = pixels[(x+(y+10)*width)%pixels.length];
      }
    }
  }
  if (effectNumber==19) {
    filter(POSTERIZE, 4);
  }
  if (effectNumber==20) {
    filter(INVERT);
  }
  if (effectNumber==21) {
    filter(BLUR, 1);
  }
  if (effectNumber==22) {
    filter(ERODE);
  }
  if (effectNumber==23) {
    filter(DILATE);
  }
  if (effectNumber==24) {
    fill(0x0, 0x20);
    noStroke();
    rect(0, 0, width, height);
  }
  if (effectNumber==25) {
    PImage imTmp = createImage(width, height, HSB);
    loadPixels();
    for (int x=0;x<width;x++) {
      for (int y=0;y<height;y++) {
        imTmp.pixels[x+y*imTmp.width] = pixels[(x+y)%imTmp.width+y*imTmp.width];
      }
    }
    imTmp.updatePixels();
    image(imTmp, 0, 0);
  }
  if (effectNumber==26) {
    if (bufferEffect!=null) image(bufferEffect,-width+random(width*2),-height+random(height*2));
    bufferEffect = get();
  }
}

