
import android.net.wifi.*;
import android.content.Context;
import android.os.Bundle;
import java.util.List;

WifiManager mainWifiObj;
List<ScanResult> results;

ArrayList<Wifimon> wildWifimons = new ArrayList<Wifimon>();
ArrayList<Wifimon> ownedWifimons = new ArrayList<Wifimon>();

ArrayList<Button> buttons = new ArrayList<Button>();

int frame = 0;

PImage banner;

PImage[][] limbs = new PImage[7][4];

int gameState;// wander, choice, fight, message, recover

int nextGameState=0;
Wifimon showed;

String currentBSSID = "";

int chosenFighter=0; 
Wifimon opponent;

boolean fingerUp=true;

String logA="";

float recoverTime=0;

void setup() {
  orientation(PORTRAIT);
  banner=loadImage("banner01.png");
  for (int i=0;i<limbs.length;i++) {
    for (int j=0;j<limbs[i].length;j++) {
      limbs[i][j] = loadImage("limb"+nf(i, 2)+"_"+nf(j, 2)+".png");
    }
  }
  loadGame();
  mainWifiObj = (WifiManager) getSystemService(Context.WIFI_SERVICE);
  updateScan();
  initWanderState();
  textSize(14);
}

void draw() {
  if (gameState==0) {
    wanderState();
  }
  if (gameState==1) {
    choiceState();
  }
  if (gameState==2) {
    fightState();
  }
  if (gameState==3) {
    messageState();
  }
  if (gameState==4) {
    recoverState();
  }
  frame++;
}

void initWanderState() {
  updateScan();
  buttons = new ArrayList<Button>();
  buttons.add(new Button(new PVector(10, 170), new PVector(width-20, 40), "scan for wild Wifimons", new Action() {
    public void doIt() {
      updateScan();
    }
  }
  ));
  for (int i=0;i<6;i++) buttons.add(new Button(new PVector(width-100, 10+i*40+245-20), new PVector(100-10, 25), "", new WildInteract(i)));
  gameState=0;
}

void wanderState() {
  // update
  // draw
  background(0x10, 0x50, 0x05); 
  image(banner, 0, 0);
  for (int i=0;i<buttons.size();i++) {
    buttons.get(i).draw();
  }
  textAlign(LEFT);
  for (int i=0;i<6;i++) {
    if (i<wildWifimons.size()) {
      image(wildWifimons.get(i).pic, 5, 10+i*40+250-30);
      if (wildWifimons.get(i).BSSID.equals(currentBSSID)) fill(0, 0xFF, 0);
      else fill(0xA0, 0xA0, 0);
      text(wildWifimons.get(i).name, 50, 0+i*40+245 );
      text("level "+wildWifimons.get(i).level, 50, 15+i*40+245);
      if (wildWifimons.get(i).BSSID.equals(currentBSSID)) buttons.get(i+1).label="catch";
      else buttons.get(i+1).label="fight";
      buttons.get(i+1).hidden=false;
    }
    else {
      buttons.get(i+1).hidden=true;
    }
  }
  fill(0xFF);
  text(logA, 10, height-60, width-20, 60); 
  text("You own "+ownedWifimons.size()+" Wifimon"+((ownedWifimons.size()>1)?"s":""), 10, height-35, width-20, 20);
}

void initChoiceState() {
  chosenFighter=0;
  buttons = new ArrayList<Button>();
  if (ownedWifimons.size()>0) {
    if (ownedWifimons.size()>1) {
      buttons.add(new Button(new PVector(10, 50), new PVector(width-20, 40), "next Wifimon", new Action() {
        public void doIt() {
          chosenFighter = (chosenFighter+1)%ownedWifimons.size();
        }
      }
      ));
    }
    buttons.add(new Button(new PVector(10, 300), new PVector(width-20, 40), "do the fight !", new Action() {
      public void doIt() {
        initFightState();
      }
    }
    ));
  } 
  else {
    buttons.add(new Button(new PVector(10, 170), new PVector(width-20, 40), "You don't have any Wifimon yet to fight with.", new Action() {
      public void doIt() {
        initWanderState();
      }
    }
    ));
  }
  gameState=1;
}

void choiceState() {
  background(0x10, 0x05, 0x50);
  fill(0xFF);
  if (chosenFighter<ownedWifimons.size()) {
    text("Choose a Wifimon to fight with.", 10, 100, width-20, 30);
    image(ownedWifimons.get(chosenFighter).pic, floor((float)width/2-(float)ownedWifimons.get(chosenFighter).pic.width*2/2), 170, ownedWifimons.get(chosenFighter).pic.width*2, ownedWifimons.get(chosenFighter).pic.height*2);
    noStroke();
    fill(0, 0xFF, 0);
    rect((float)width/2-ownedWifimons.get(chosenFighter).life/2, 145, ownedWifimons.get(chosenFighter).life, 10);
    text(ownedWifimons.get(chosenFighter).name, 10, 245, width-20, 30);
    text("level "+ownedWifimons.get(chosenFighter).level, 10, 260, width-20, 30);
  }
  for (int i=0;i<buttons.size();i++) {
    buttons.get(i).draw();
  }
}

void initFightState() {
  buttons = new ArrayList<Button>();
  String attackName = "attack";
  if (ownedWifimons.get(chosenFighter).capacities<2) {
    attackName = "ping";
  }
  if (ownedWifimons.get(chosenFighter).capacities>5) {
    attackName = "DDoS";
  }
  buttons.add(new Button(new PVector(10, 350), new PVector((float)width/2-20, 25), attackName, new Action() {
    public void doIt() {
      logA = "Attack !";
      ownedWifimons.get(chosenFighter).life-=floor(random(opponent.level+2));
      opponent.life-=floor(random(ownedWifimons.get(chosenFighter).level+2));
      checkDeath();
    }
  }
  ));
  buttons.add(new Button(new PVector(10, 400), new PVector((float)width/2-20, 25), "recover", new Action() {
    public void doIt() {
      initRecoverState();
      ownedWifimons.get(chosenFighter).life-=floor(random(opponent.level)+1);
      checkDeath();
    }
  }
  ));
  buttons.add(new Button(new PVector((float)width/2+10, 350), new PVector((float)width/2-20, 25), "escape", new Action() {
    public void doIt() {
      logA = "You escaped";
      initWanderState();
      saveGame();
    }
  }
  ));
  buttons.add(new Button(new PVector((float)width/2+10, 400), new PVector((float)width/2-20, 25), "catch", new Action() {
    public void doIt() {
      ownedWifimons.get(chosenFighter).life-=floor(random(opponent.level+2));
      checkDeath();
      if (gameState==2) {
        if (random(ownedWifimons.get(chosenFighter).level/2)>opponent.life) {
          logA = "You successfully caught "+opponent.name+".";
          opponent.life+=ownedWifimons.get(chosenFighter).level;
          ownedWifimons.add(opponent);
          showed=opponent;
          nextGameState=0;
          initMessageState();
          saveGame();
        } 
        else {
          logA = "The catching process on "+opponent.name+" timed out, you failed.";
        }
      }
    }
  }
  ));
  logA = "A wild "+opponent.name+" appears !";
  gameState=2;
}

void checkDeath() {
  if (chosenFighter<ownedWifimons.size()) {
    if (ownedWifimons.get(chosenFighter).life<=0) {
      logA = ownedWifimons.get(chosenFighter).name+" died.";
      showed = ownedWifimons.get(chosenFighter);
      ownedWifimons.remove(chosenFighter);
      nextGameState = (ownedWifimons.size()>0)?1:0;
      initMessageState();
      saveGame();
    }
  }
  if (opponent!=null) {
    if (opponent.life<=0) {
      logA = opponent.name+" died.";
      if (chosenFighter<ownedWifimons.size()) {
        logA += " "+ownedWifimons.get(chosenFighter).name+" is now level "+ownedWifimons.get(chosenFighter).level+".";
        ownedWifimons.get(chosenFighter).level++;
      }
      showed = ownedWifimons.get(chosenFighter);
      nextGameState=0;
      initMessageState();
      saveGame();
    }
  }
}

void fightState() {
  background(0x50, 0x20, 0x05);
  for (int i=0;i<buttons.size();i++) {
    buttons.get(i).draw();
  }
  text(logA, 10, 30, width-20, 60);
  pushMatrix();
  translate(floor((float)width/3), 200);
  image(ownedWifimons.get(chosenFighter).pic, 0, 0);
  noStroke();
  fill(0, 0xFF, 0);
  rect(-20, -30, ownedWifimons.get(chosenFighter).life, 10);
  popMatrix();
  pushMatrix();
  translate(floor((float)width*2/3), 150);
  image(opponent.pic, 0, 0);
  noStroke();
  fill(0, 0xFF, 0);
  rect(-20, -30, opponent.life, 10);
  popMatrix();
}

void initMessageState() {
  buttons = new ArrayList<Button>();
  buttons.add(new Button(new PVector(10, height-100), new PVector(width-20, 50), "ok", new Action() {
    public void doIt() {
      if (nextGameState==0) {
        initWanderState();
      }
      else if (nextGameState==1) {
        initChoiceState();
      }
      else if (nextGameState==2) {
        initFightState();
      }
      else if (nextGameState==3) {
        initMessageState();
      }
    }
  }
  ));
  gameState=3;
}

void messageState() {
  background(0x05, 0x20, 0x50);
  for (int i=0;i<buttons.size();i++) {
    buttons.get(i).draw();
  }
  if (showed!=null) image(showed.pic, floor((float)width/2-(float)showed.pic.width*2/2), floor((float)height/2-(float)showed.pic.height*2/2), showed.pic.width*2, showed.pic.height*2);
  text(logA, 10, 30, width-20, 60);
}

void initRecoverState() {
  buttons = new ArrayList<Button>();
  recoverTime=1000;
  logA = "Move close to the "+ownedWifimons.get(chosenFighter).name+" wifi source to recover more life.";
  gameState=4;
}

float signal=0;
void recoverState() {
  // update
  if (frame%10==0) {
    mainWifiObj.startScan();
    results =  mainWifiObj.getScanResults();
    for (int i=0;i<results.size();i++) {
      ScanResult thisResult = results.get(i);
      if (thisResult.BSSID.equals(ownedWifimons.get(chosenFighter).BSSID)) {
        signal = map((float)thisResult.level, 0, -200, 1, 0);
      }
    }
  }
  ownedWifimons.get(chosenFighter).life+=signal/30;
  if (recoverTime<=5) {
    logA = "recovering done";
    initFightState();
  }
  recoverTime=(float)recoverTime*0.99f;
  // draw
  background(0x20, 0x05, 0x50);
  fill(0, 0xFF, 0);
  rect(width/2-ownedWifimons.get(chosenFighter).life/2, 140, ownedWifimons.get(chosenFighter).life, 10);
  fill(0xFF);
  text(logA, 10, 30, width-20, 60);
  text("time", width*1/3, 175);
  text("signal", width*2/3, 175);
  noStroke();
  fill(0xFF, 0xFF, 0);
  rect(width*1/3-20, 200, 20, recoverTime-5);
  fill(0, 0xFF, 0xFF);
  rect(width*2/3-20, 200, 20, signal*200*random(0.8, 1.2));
}

void mousePressed() {
  if (fingerUp) {
    fingerUp=false;
    int buttonPressed=-1;
    for (int i=0;i<buttons.size();i++) {
      if (testButton(buttons.get(i))) buttonPressed=i;
    }
    if (buttonPressed!=-1) buttons.get(buttonPressed).doIt();
  }
}

void mouseReleased() {
  fingerUp=true;
}

boolean testButton(Button button) {
  if (!button.hidden&&mouseX>=button.pos.x&&mouseY>=button.pos.y&&mouseX<=button.pos.x+button.size.x&&mouseY<=button.pos.y+button.size.y) {
    return true;
  }
  return false;
}

class Button {
  PVector pos;
  PVector size;
  String label;
  Action action;
  boolean hidden=false;
  Button (PVector pos, PVector size, String label, Action action) {
    this.pos=pos;
    this.size=size;
    this.label=label;
    this.action=action;
  }
  void draw() {
    if (!hidden) {
      stroke(0xFF);
      fill(0);
      rect(pos.x, pos.y, size.x, size.y);
      fill(0xFF);
      textAlign(CENTER, CENTER);
      text(label, pos.x+size.x/2, pos.y+size.y/2);
    }
  }
  void doIt() {
    action.doIt();
  }
}

class Wifimon {
  String name;
  String BSSID;
  int level;
  PGraphics pic;
  float life;
  int capacities;
  Wifimon(String name, String BSSID, int level, float life, int capacities) {
    this.name=name;
    this.BSSID=BSSID;
    this.level=level;
    this.life=life;
    this.capacities=capacities;
    float uniqueNumber = 0;
    for (int i=0;i<BSSID.length();i++) if ((i-2)%3!=0) uniqueNumber+=BSSID.charAt(i)*i;
    int hue = floor(uniqueNumber*10.0f)%0x100;
    pic = createGraphics(32, 32, JAVA2D);
    pic.beginDraw();
    for (int i=0;i<limbs.length;i++) {
      pic.image(limbs[i][floor(uniqueNumber/(i+10))%limbs[i].length], 0, 0);
    }
    colorMode(HSB);
    for (int x=0;x<pic.width;x++) {
      for (int y=0;y<pic.width;y++) {
        color c = pic.get(x, y);
        if (alpha(c)>0) {
          if (brightness(c)==99) c = color(hue, 0xA0, 0x80);
          if (brightness(c)==137) c = color(hue, 0xA0, 0xA0);
          pic.stroke(c);
          pic.point(x, y);
        }
      }
    }
    colorMode(RGB);
    pic.endDraw();
  }
}

interface Action {
  abstract void doIt();
}

void updateScan() {
  try {
    mainWifiObj.startScan();
    currentBSSID = mainWifiObj.getConnectionInfo().getBSSID();
    results =  mainWifiObj.getScanResults();
    wildWifimons = new ArrayList<Wifimon>();
    for (int i=0;i<results.size();i++) {
      ScanResult thisResult = results.get(i);
      if (thisResult.BSSID.equals(currentBSSID)) {
        boolean found = false;
        for (int j=0;j<ownedWifimons.size();j++) {
          if (ownedWifimons.get(j).BSSID.equals(thisResult.BSSID)) found=true;
        }
        if (!found) {
          wildWifimons.add(new Wifimon(thisResult.SSID, thisResult.BSSID, floor(constrain(map(thisResult.level, 0, -100, 20, 1), 1, 20)), 20, thisResult.capabilities.split("-").length));
        }
      }
    }
    for (int i=0;i<results.size();i++) {
      ScanResult thisResult = results.get(i);
      if (!thisResult.BSSID.equals(currentBSSID)) {
        boolean found = false;
        for (int j=0;j<ownedWifimons.size();j++) {
          if (ownedWifimons.get(j).BSSID.equals(thisResult.BSSID)) found=true;
        }
        if (!found) {
          wildWifimons.add(new Wifimon(thisResult.SSID, thisResult.BSSID, floor(constrain(map(thisResult.level, 0, -100, 20, 0), 0, 20)), 20, thisResult.capabilities.split("-").length));
        }
      }
    }
  } 
  catch (Exception e) {
    println(e);
  }
}

class WildInteract implements Action {
  int index;
  WildInteract(int index) {
    this.index=index;
  }
  void doIt() {
    if (index<wildWifimons.size()) {
      if (wildWifimons.get(index).BSSID.equals(currentBSSID)) {
        logA = "You successfully caught "+wildWifimons.get(index).name+".";
        ownedWifimons.add(wildWifimons.get(index));
        updateScan();
        saveGame();
      }
      else {
        opponent = wildWifimons.get(index);
        initChoiceState();
      }
    }
  }
}

void saveGame() {
  try {
    PrintWriter output = createWriter("wifimonSaveState.txt");
    for (int i=0;i<ownedWifimons.size();i++) {
      output.println(ownedWifimons.get(i).name);
      output.println(ownedWifimons.get(i).BSSID);
      output.println(str(ownedWifimons.get(i).level));
      output.println(str(ownedWifimons.get(i).life));
      output.println(str(ownedWifimons.get(i).capacities));
    }
    output.flush();
    output.close();
  } 
  catch (Exception e) {
  }
}

void loadGame() {
  try {
    String[] saveState = loadStrings("wifimonSaveState.txt");
    for (int i=0;i<floor((float)saveState.length/5);i++) {
      ownedWifimons.add(new Wifimon(saveState[i*5+0], saveState[i*5+1], Integer.parseInt(saveState[i*5+2]), Float.parseFloat(saveState[i*5+3]), Integer.parseInt(saveState[i*5+4])));
    }
  } 
  catch (Exception e) {
    println(e);
  }
}

