using System;
using System.Collections.Generic;
using System.Text;
using Microsoft.Xna.Framework;
using Ika.Graphics;

namespace TestBoids.Collisions
{
    class BoxCollision : CollisionsManager
    {

        private Vector2 m_size;       
        public Vector2 Size
        {
            get { return m_size; }

        }

        public BoxCollision(Vector2 bounds, Vector2 size, Vector2 position)
        {
            m_bounds = bounds;
            m_size = size;
            m_pos = position;
        }

        public override bool isCollideWith(CollisionsManager collision)
        {
            if (typeof(BoxCollision) == collision.GetType())
            {
                BoxCollision box = (BoxCollision)collision;
                return !(
                    Position.X + Bounds.X + Size.X < box.Position.X + box.Bounds.X ||
                    box.Position.X + box.Bounds.X + box.Size.X < Position.X + Bounds.X ||
                    Position.Y + Bounds.Y + Size.Y < box.Position.Y + box.Bounds.Y ||
                    box.Position.Y + box.Bounds.Y + box.Size.Y < Position.Y + Bounds.Y);
            }
            else if (typeof(PixelCollision) == collision.GetType())
            {
                PixelCollision pixel = (PixelCollision)collision;
                return (
                       pixel.Bounds.X + pixel.Position.X >= Bounds.X + Position.X
                    && pixel.Bounds.X + pixel.Position.X <= Bounds.X + Position.X + Size.X
                    && pixel.Bounds.Y + pixel.Position.Y >= Bounds.Y + Position.Y
                    && pixel.Bounds.Y + pixel.Position.Y <= Bounds.Y + Position.Y + Size.Y);
            }
            else if (typeof(CircleCollision) == collision.GetType())
                return collision.isCollideWith(this);

            return false;
        }
    }
}
