using System;
using System.Collections.Generic;
using System.Text;
using Microsoft.Xna.Framework;
using Ika.Graphics;

namespace TestBoids.Collisions
{
    class CircleCollision : CollisionsManager
    {
        private float m_radius;
        public float Radius
        {
            get { return m_radius; }
            set { m_radius = value; }
        }

        public CircleCollision(Vector2 center, float radius, Vector2 position)
        {
            m_bounds = center;
            m_radius = radius;
            m_pos = position;
        }

        public override bool isCollideWith(CollisionsManager collision)
        {
            if (typeof(BoxCollision) == collision.GetType())
            {
                BoxCollision box = (BoxCollision)collision;
                PixelCollision pixel;
                // center
                pixel = new PixelCollision(Bounds, Position);
                if (pixel.isCollideWith(box)) return true;
                // cotes rect
                pixel.Position = box.Position;
                pixel.Bounds = box.Bounds;
                if (pixel.isCollideWith(this)) return true;
                pixel.Bounds = box.Bounds + new Vector2(box.Size.X, 0);
                if (pixel.isCollideWith(this)) return true;
                pixel.Bounds = box.Bounds + new Vector2(0, box.Size.Y);
                if (pixel.isCollideWith(this)) return true;
                pixel.Bounds = box.Bounds + new Vector2(box.Size.X, box.Size.Y);
                if (pixel.isCollideWith(this)) return true;
                //cote cercles
                pixel.Position = Position;
                pixel.Bounds = Bounds + new Vector2(Radius, 0);
                if (pixel.isCollideWith(box)) return true;
                pixel.Bounds = Bounds + new Vector2(-Radius, 0);
                if (pixel.isCollideWith(box)) return true;
                pixel.Bounds = Bounds + new Vector2(0, Radius);
                if (pixel.isCollideWith(box)) return true;
                pixel.Bounds = Bounds + new Vector2(0, -Radius);
                if (pixel.isCollideWith(box)) return true;
                // else .. 
                return false;
            }
            else if (typeof(PixelCollision) == collision.GetType())
            {
                PixelCollision point = (PixelCollision)collision;
                return (Vector2.Distance(point.Position + point.Bounds, Position + Bounds) <= m_radius);
            }
            else if (typeof(CircleCollision) == collision.GetType())
            {
                CircleCollision circle = (CircleCollision)collision;
                float result = Vector2.Distance(Bounds + Position, circle.Bounds + circle.Position);
                return result <= (Radius + circle.Radius);
            }

            return false;
        }

    }

}
