using System;
using System.Collections.Generic;
using System.Text;
using Microsoft.Xna.Framework;

namespace TestBoids.Collisions
{
    class PixelCollision : CollisionsManager
    {
        public PixelCollision(Vector2 bounds, Vector2 position)
        {
            m_bounds = bounds;
            m_pos = position;
        }

        public override bool isCollideWith(CollisionsManager collision)
        {
            if (typeof(PixelCollision) == collision.GetType())
                return ((Position + Bounds) == (collision.Position + collision.Bounds));
            else
                return collision.isCollideWith(this);
        }
    }
}
