using System;
using System.Collections.Generic;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Storage;
using Microsoft.Xna.Framework.Content;

namespace Ika.Components
{
    public class RelativeKeyboardComponent : Microsoft.Xna.Framework.GameComponent, Ika.Components.IRelativeKeyboardService
    {
        KeyboardState m_oldState;
        KeyboardState m_currentState;

        public RelativeKeyboardComponent(Game game)
            : base(game)
        {
            game.Services.AddService(typeof(IRelativeKeyboardService), this);
        }

        public override void Initialize()
        {
            m_currentState = Keyboard.GetState();
            base.Initialize();
        }

        public override void Update(GameTime gameTime)
        {
            m_oldState = m_currentState;
            m_currentState = Keyboard.GetState();
            base.Update(gameTime);
        }

        public bool isKeyPressed(Keys key)
        {
            if(m_oldState.IsKeyUp(key) && m_currentState.IsKeyDown(key))
            {
                return true;
            }
            return false;
        }
    }
}