using System;
using System.Collections.Generic;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Storage;
using Microsoft.Xna.Framework.Content;

namespace Ika.Components
{

#if !XBOX
    public class RelativeMouseComponent : Microsoft.Xna.Framework.GameComponent, IRelativeMouseService
    {

        public Vector2 XY
        {
            get
            {
                return new Vector2(m_mouse_dX, m_mouse_dY);
            }
        }

        public int X
        {
            get
            {
                return m_mouse_dX;
            }
        }

        public int Y
        {
            get
            {
                return m_mouse_dY;
            }
        }

        public int Wheel
        {
            get
            {
                if (m_mouse_dWheel == 0)
                    return 0;
                else
                    return m_mouse_dWheel/120;
            }
        }

        public bool LeftButton
        {
            get
            {
                return m_leftClickPressed;
            }
        }

        public MouseState State
        {
            get
            {
                return Mouse.GetState();
            }
        }

        int m_mouse_X, m_mouse_Y;
        int m_mouse_dX, m_mouse_dY;

        int m_mouse_Wheel;
        int m_mouse_dWheel;

        bool m_leftClickstate, m_leftClickPressed;


        public RelativeMouseComponent(Game game)
            : base(game)
        {
            game.Services.AddService(typeof(IRelativeMouseService), this);
        }

        public override void Initialize()
        {
            MouseState mouseState = Mouse.GetState();
            m_mouse_X = mouseState.X;
            m_mouse_Y = mouseState.Y;
            m_mouse_Wheel = mouseState.ScrollWheelValue;

            m_leftClickstate = false;

            base.Initialize();
        }

        public override void Update(GameTime gameTime)
        {
            MouseState mouseState = Mouse.GetState();

            m_mouse_dX = mouseState.X - m_mouse_X;
            m_mouse_dY = mouseState.Y - m_mouse_Y;
            m_mouse_dWheel = mouseState.ScrollWheelValue - m_mouse_Wheel;

            m_mouse_X = mouseState.X;
            m_mouse_Y = mouseState.Y;
            m_mouse_Wheel = mouseState.ScrollWheelValue;

            m_leftClickPressed = (m_leftClickstate ^ (mouseState.LeftButton == ButtonState.Pressed));
            m_leftClickstate = (mouseState.LeftButton == ButtonState.Pressed);

            base.Update(gameTime);
        }
    }
    #else
    public class RelativeMouseComponent : Microsoft.Xna.Framework.GameComponent, RelativeMouse.IRelativeMouseService
    {
        public Microsoft.Xna.Framework.Vector2 XY { get { return Vector2.Zero; } }
        public int X { get{return 0;} }
        public int Y { get{return 0;} }
        public int Wheel  { get{return 0;} }
        public RelativeMouseComponent(Game game)
            : base(game)
        {
            game.Services.AddService(typeof(IRelativeMouseService), this);
        }

        public override void Initialize()
        {

            base.Initialize();
        }

        public override void Update(GameTime gameTime)
        {
            base.Update(gameTime);
        }
    }
#endif
}


