using System;
using System.Collections.Generic;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Storage;
using Microsoft.Xna.Framework.Content;

namespace Ika.Components
{
    public class StatsViewerComponent : DrawableGameComponent
    {
        public class StatsEntry
        {
            String m_Name;
            public String Name
            {
                get { return m_Name; }
                set { m_Name = value; }
            }

            String m_Value;
            public String Value
            {
                get { return m_Value; }
                set { m_Value = value; }
            }

            public StatsEntry(String name)
            {
                m_Name = name;
                Value = "";
            }
        }

        ICollection<StatsEntry> m_entries;
        IDictionary<String, StatsEntry> m_entriesByName;

        SpriteBatch m_spriteBatch;
        SpriteFont m_spriteFont;
        Vector2 m_position;

        bool m_drawStats = true;
        public bool DrawStats
        {
            get { return m_drawStats; }
            set { m_drawStats = value; }
        }

        public StatsViewerComponent(Game game)
            : base(game)
        {
            m_position = new Vector2(40.0f, 40.0f);
            m_entries = new List<StatsEntry>();
            m_entriesByName = new Dictionary<String, StatsEntry>();
            game.Services.AddService(typeof(StatsViewerComponent), this);
        }

        public StatsViewerComponent(Game game, Vector2 position)
            : base(game)
        {
            m_position = position;
        }

        public StatsEntry CreateNewEntry(String name)
        {
            StatsEntry entry = new StatsEntry(name);
            m_entries.Add(entry);
            m_entriesByName.Add(name, entry);
            return entry;
        }

        public void SetEntryValue(String name, String value)
        {
            if (!m_entriesByName.ContainsKey(name))
            {
                CreateNewEntry(name);
            }
            m_entriesByName[name].Value = value;
        }

        public override void Initialize()
        {
            m_spriteBatch = new SpriteBatch(Game.GraphicsDevice);
            m_spriteFont = Game.Content.Load<SpriteFont>("fpsFont");
            base.Initialize();
        }

        public void Reset()
        {
            m_entries.Clear();
            m_entriesByName.Clear();
        }

        public override void Update(GameTime gameTime)
        {
            base.Update(gameTime);
        }

        public override void Draw(GameTime gameTime)
        {
            String s = "";
            foreach (StatsEntry entry in m_entries)
            {
                s = s + entry.Name + ": " + entry.Value + "\n";
            }
            if (DrawStats)
            {
                m_spriteBatch.Begin(SpriteBlendMode.Additive, SpriteSortMode.Immediate, SaveStateMode.SaveState);
                m_spriteBatch.DrawString(m_spriteFont, s, m_position, Color.White);
                m_spriteBatch.End();
            }

            base.Update(gameTime);
        }
    }
}