using System;
using System.Collections.Generic;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Storage;
using Microsoft.Xna.Framework.Content;

namespace Ika.Components
{
    public class TimeComponent : Microsoft.Xna.Framework.GameComponent
    {
        float m_totalTime = 0;
        float m_elapsedTime = 0;

        bool m_paused = false;
        public bool Paused
        {
            get { return m_paused; }
            set { m_paused = value; }
        }

        public float ElapsedTime
        {
            get { return m_elapsedTime; }
        }

        public float TotalTime
        {
            get { return m_totalTime; }
        }

        public delegate void TimeWatcher(TimeSpan time);

        public event TimeWatcher TimeElapsedEvent;

        public TimeComponent(Game game)
            : base(game)
        {
            game.Services.AddService(typeof(TimeComponent), this);
        }

        public void Reset()
        {
            TimeElapsedEvent = null;
        }

        public override void Initialize()
        {
            base.Initialize();
        }

        public override void Update(GameTime gameTime)
        {
            if (m_paused)
            {
                m_elapsedTime = 0;
            }
            else
            {
                m_elapsedTime = (float)gameTime.ElapsedGameTime.TotalMilliseconds;
                m_totalTime += m_elapsedTime;
                if (gameTime != null && TimeElapsedEvent != null)
                {
                    TimeElapsedEvent(gameTime.ElapsedGameTime);
                }
            }

            base.Update(gameTime);
        }
    }
}