using System;
using System.Collections.Generic;
using System.Text;
using Microsoft.Xna.Framework;
using Ika.Graphics;

namespace TestBoids.Entities
{
    public class EnergyEntity : Entity
    {
        Vector2 m_power;
        public Vector2 Power
        {
            get { return m_power; }
            set { m_power = value; }
        }

        public EnergyEntity(Vector2 position, Sprite sprite, Vector2 power)
            : base(position, sprite, 0.0f)
        {
            m_power = power;  
        }

        public override void Update(float dt)
        {
            if (Collision != null)
                Collision.UpdatePosition(Position);
        }
    }
}
