using System;
using System.Collections.Generic;
using System.Text;
using Microsoft.Xna.Framework;
using Ika.Graphics;
using TestBoids.Collisions;
using TestBoids.Scene;

namespace TestBoids.Entities
{
    public enum EntityMovementType
    {
        MT_Static,
        MT_Dynamic
    }

    public abstract class Entity
    {
        private EntityMovementType m_movementType;
        public EntityMovementType MovementType
        {
            get { return m_movementType; }
            set { m_movementType = value; }
        }

        protected Vector2 m_position;
        public Vector2 Position
        {
            set { m_position = value; }
            get { return m_position; }
        }

        protected Vector2 m_orientation;
        public Vector2 Orientation
        {
            get { return m_orientation; }
            set { m_orientation = value; }
        }

        protected Sprite m_sprite;
        public Sprite Sprite
        {
            set { m_sprite = value; }
            get { return m_sprite; }
        }

        protected Vector2 m_speed;
        public Vector2 Speed
        {
            get { return m_speed; }
            set { m_speed = value; }
        }

        protected float m_maxSpeed;
        public float MaxSpeed
        {
            get { return m_maxSpeed; }
            set { m_maxSpeed = value; }
        }

        protected bool m_solid;
        public bool isSolid
        {
            get { return m_solid; }
            set { m_solid = value; }
        }

        protected CollisionsManager m_collision;
        public CollisionsManager Collision
        {
            get { return m_collision; }
            set { m_collision = value; isSolid = true; }
        }

        protected SceneManager m_sceneManager;
        public SceneManager Scene
        {
            get { return m_sceneManager; }
            set { m_sceneManager = value; }
        }

        public Entity(Vector2 position, Sprite sprite, float maxSpeed)
        {
            m_position = position;
            m_sprite = sprite;
            m_maxSpeed = maxSpeed;
            m_solid = false;
            m_collision = null;
        }

        public bool isCollideWith(Entity entity)
        {
            if (entity.isSolid)
                return m_collision.isCollideWith(entity.Collision);
            else
                return false;
        }

        public bool isStatic()
        {
            return m_movementType == EntityMovementType.MT_Static;
        }

        public bool isDynamic()
        {
            return m_movementType == EntityMovementType.MT_Dynamic;
        }

        public abstract void Update(float dt);
    }
}
