using System;
using System.Collections.Generic;
using System.Text;
using Microsoft.Xna.Framework;
using Ika.Graphics;

namespace TestBoids.Entities
{
    class EvilBird : BlockEntity
    {
        float m_amplitude = 3;
        float m_timeCoef = 0.1f;
        float m_phase;

        float m_timer;

        public EvilBird(Vector2 position, Sprite sprite, float maxSpeed)
            : base(position, sprite, maxSpeed)
        {  
            MovementType = EntityMovementType.MT_Dynamic;

            Random r = new Random();
            m_phase = MathHelper.Pi * (float)r.NextDouble();
        }

        public override void Update(float dt)
        {
            m_timer += dt;
            Speed = new Vector2(1.5f, m_amplitude * (float)Math.Cos(m_phase + m_timer * m_timeCoef));

            Collision.UpdatePosition(Position);
        }
    }
}
