using System;
using System.Collections.Generic;
using System.Text;
using Microsoft.Xna.Framework;
using Ika.Graphics;

namespace TestBoids.Entities
{
    public class EvilFish : BlockEntity
    {
        float m_timer, m_timerMax;
        float MinSpeed = 4;
        float m_dashSpeed = 20;
        Random r;

        public EvilFish(Vector2 position, Sprite sprite, float maxSpeed)
            : base(position, sprite, maxSpeed)
        {
            m_timer = 0;
            r = new Random();
            m_timerMax = r.Next(18) + 24;
        }

        public override void Update(float dt)
        {
            base.Update(dt);
            m_timer += dt;
            if (m_timer > m_timerMax)
            {
                m_timer = 0;
                m_timerMax = r.Next(18) + 24;
                MaxSpeed = m_dashSpeed;
            }

            Speed = new Vector2(-MaxSpeed - MinSpeed,0);
            MaxSpeed = 0.96f * MaxSpeed;
        }
    }
}
