using System;
using System.Collections.Generic;
using System.Text;
using Microsoft.Xna.Framework;
using Ika.Graphics;

namespace TestBoids.Entities
{
    public class IntroEntity : Entity
    {

        Vector2 m_goal;
        float m_mass = 1f;
        float m_acceleration = 6f;

        public IntroEntity(Vector2 position, Sprite sprite, float maxSpeed, Vector2 destination)
            : base(position, sprite, maxSpeed)
        {
            m_goal = destination;
            MovementType = EntityMovementType.MT_Dynamic;
        }

        public void UpdateSpeed(float dt)
        {
            Vector2 relativeGoal = m_goal - m_position;
            if (relativeGoal.Length() > 0)
            {
                relativeGoal.Normalize();
            }

            m_speed += relativeGoal * m_acceleration / m_mass * dt;

            if (m_speed.Length() > m_maxSpeed)
            {
                m_speed.Normalize();
                m_speed *= m_maxSpeed;
            }
        }

        public override void Update(float dt)
        {
            UpdateSpeed(dt);
        }
    }
}
