using System;
using System.Collections.Generic;
using System.Text;
using Microsoft.Xna.Framework;

namespace TestBoids.Entities
{
    class Level0 : LevelSpawner
    {
        List<BackgroundEntity> m_listObstacle;
        int m_maxObstacle;

        bool m_init = false;

        public Level0()
            : base(12, 30)
        {
            m_maxObstacle = 12;
            m_listObstacle = new List<BackgroundEntity>();
        }

        public override void RemoveObstacle(Entity e)
        {
        }

        void addCloud(Vector2 position)
        {
            BackgroundEntity e = Scene.Factory.CreateCloud(Scene.ScreenToWorld(position));
            e.Speed = new Vector2((float)r.NextDouble() * 5 + 1, 0);
            if (r.NextDouble() > 0.5)
            {
                e.Speed = -e.Speed;
            }
            e.MovementType = EntityMovementType.MT_Dynamic;
            m_listObstacle.Add((BackgroundEntity)
                Scene.AddEntity(e));
            UpdateSpawnTimer();
        }

        public override void Update(float dt)
        {
            base.Update(dt);
            SpawnRandom(new Vector2(10, (float)r.NextDouble() * 600), 0.992f);

            if (!m_init)
            {
                for( int i=0;i<m_maxObstacle;i++)
                {
                    addCloud(new Vector2((float)r.NextDouble() * 800, (float)r.NextDouble() * 600));
                }
                m_init = true;

                Spawn(new Vector2(1150, 160));
                Spawn(new Vector2(1280, 220));
                Spawn(new Vector2(1380, 560));
                Spawn(new Vector2(1150, 420));
                Spawn(new Vector2(1010, 375));
                Spawn(new Vector2(950, 320));

                Scene.AddEntity(Scene.Factory.CreateCloud(Scene.ScreenToWorld(
                    new Vector2(950, 220))));
                Scene.AddEntity(Scene.Factory.CreateCloud(Scene.ScreenToWorld(
                    new Vector2(1080, 540))));
                Scene.AddEntity(Scene.Factory.CreateCloud(Scene.ScreenToWorld(
                    new Vector2(1100, 380))));

                Scene.AddEntity(Scene.Factory.CreateCloud(Scene.ScreenToWorld(
                    new Vector2(1260, 350))));
                Scene.AddEntity(Scene.Factory.CreateCloud(Scene.ScreenToWorld(
                    new Vector2(1520, 110))));
                Scene.AddEntity(Scene.Factory.CreateCloud(Scene.ScreenToWorld(
                    new Vector2(1200, 420))));
            }

            foreach (BackgroundEntity b in m_listObstacle)
            {
                if (b.Position.X < -40)
                {
                    Vector2 newPos = b.Position + Vector2.UnitX * 900;
                    Scene.UpdatePosition(b, newPos);
                }
                else if (b.Position.X > 850)
                {
                    Vector2 newPos = b.Position - Vector2.UnitX * 900;
                    Scene.UpdatePosition(b, newPos);
                }
            }
        }
    }
}
