using System;
using System.Collections.Generic;
using System.Text;
using Microsoft.Xna.Framework;
using TestBoids.Collisions;

namespace TestBoids.Entities
{
    class Level1 : LevelSpawner
    {

        List<BlockEntity> m_listObstacle;
        int m_maxObstacle;
        

        public Level1(int maxObstacle, float minTimerSpawn, float maxTimerSpawn)
            : base(minTimerSpawn, maxTimerSpawn)
        {
            m_maxObstacle = maxObstacle;
            m_listObstacle = new List<BlockEntity>();
        }

        public override void RemoveObstacle(Entity e)
        {
            if(e is BlockEntity)
                m_listObstacle.Remove((BlockEntity)e);
        }        

        void addBird(Vector2 position)
        {
            BlockEntity b = Scene.Factory.CreateEvilBird(Scene.ScreenToWorld(position));
            b.MovementType = EntityMovementType.MT_Dynamic;
            m_listObstacle.Add((BlockEntity)
                Scene.AddEntity(b));
            UpdateSpawnTimer();
        }
  
        public override void Update(float dt)
        {
            base.Update(dt);

            SpawnRandom(new Vector2(810, (float)r.NextDouble() * 600), 0.99f);

            if (Timer > 12.0f && m_timerSpawn < Timer && m_listObstacle.Count < m_maxObstacle)
            {     
                if(((float)r.NextDouble() * 100 < 60) )
                    addCloud(new Vector2(900, (float)r.NextDouble() * 550), true);
                else
                    addBird(new Vector2(900, (float)r.NextDouble() * 550));

                //AddEnergyStream(new Vector2(1750, 300), new Vector2(200, 200), new Vector2(0,-4));
            }
        }
    }
}
