using System;
using System.Collections.Generic;
using System.Text;
using Microsoft.Xna.Framework;

namespace TestBoids.Entities
{
    class Level2 : LevelSpawner
    {
        List<BlockEntity> m_listObstacle;
        Zeppelin m_zep1, m_zep2;
        int m_maxObstacle;


        public Level2(int maxObstacle, float minTimerSpawn, float maxTimerSpawn)
            : base(minTimerSpawn, maxTimerSpawn)
        {
            m_maxObstacle = maxObstacle;
            m_listObstacle = new List<BlockEntity>();
            m_zep1 = null;
            m_zep2 = null; 
        }

        public override void RemoveObstacle(Entity e)
        {
            if(e is BlockEntity)
                m_listObstacle.Remove((BlockEntity)e);
        }

        public override void Update(float dt)
        {
            base.Update(dt);

            SpawnRandom(new Vector2(810, (float)r.NextDouble() * 600), 0.995f);

            if (m_timerSpawn < Timer && m_listObstacle.Count < m_maxObstacle)
            {
                 addCloud(new Vector2(900, (float)r.NextDouble() * 300), true);                
            }
            
            if (Timer > 0f && m_zep1 == null)
            {
                m_zep1 = (Zeppelin)Scene.AddEntity(Scene.Factory.CreateBigBaloon(Scene.ScreenToWorld(new Vector2(1500, 140)), 1));
                m_zep2 = (Zeppelin)Scene.AddEntity(Scene.Factory.CreateBigBaloon(Scene.ScreenToWorld(new Vector2(2150, 140)), 1));
            }

            if (Timer > 226)
            {
                m_zep1.MoveUp();
            }
            if (Timer > 320)
            {
                m_zep2.MoveUp();
            }
        }
    }
}
