using System;
using System.Collections.Generic;
using System.Text;
using Microsoft.Xna.Framework;

namespace TestBoids.Entities
{
    class Level3 : LevelSpawner
    {
        List<BlockEntity> m_listObstacle;
        EnergyEntity e1, e2, e3;
     

        public Level3(float minTimerSpawn, float maxTimerSpawn)
            : base(minTimerSpawn, maxTimerSpawn)
        {
           
            m_listObstacle = new List<BlockEntity>();      
        }

        public override void RemoveObstacle(Entity e)
        {
            if(e is BlockEntity)
                m_listObstacle.Remove((BlockEntity)e);
        }

        void addEvilFish(Vector2 position)
        {
            EvilFish e = Scene.Factory.CreateEvilFish(Scene.ScreenToWorld(position));
            e.MovementType = EntityMovementType.MT_Dynamic;
            Scene.AddEntity((Entity)e);
            UpdateSpawnTimer();
        }

        public void SpawnBulle(Vector2 position)
        {
            BulleEntity e = Scene.Factory.CreateBulle(Scene.ScreenToWorld(position));
            
            Scene.AddEntity((Entity)e);            
        }

        public override void Update(float dt)
        {
            base.Update(dt);
            SpawnRandom(new Vector2(810, (float)r.NextDouble() * 600), 0.99f);

            if (Timer > 50f && e1 == null)
            {
                e1 = AddEnergyStream(new Vector2(900, 100), new Vector2(300, 200), new Vector2(0, 1));
                for (int i = 0; i < 5; i++)
                {
                    SpawnBulle(new Vector2((float)r.NextDouble() * 900 + 300, (float)r.NextDouble() * 100 + 200));
                }
            }
            if (Timer > 110f && e2 == null)
            {
                e2 = AddEnergyStream(new Vector2(900, 500), new Vector2(300, 250), new Vector2(0, -3));            
            }
            if (Timer > 150f && e3 == null)
            {
                e3 = AddEnergyStream(new Vector2(800, 200), new Vector2(200, 150), new Vector2(-0.4f, 0));
                AddEnergyStream(new Vector2(1000, 200), new Vector2(100, 150), new Vector2(-1, 0));
            }

            if (m_timerSpawn < Timer && Timer > 18.0f)
            {
                addEvilFish(new Vector2(900, 50 + (float)r.NextDouble() * 500));
            }
            
        }
    }
}
