using System;
using System.Collections.Generic;
using System.Text;
using Microsoft.Xna.Framework;

namespace TestBoids.Entities
{
    class Level4 : LevelSpawner
    {

        public Level4(float minTimerSpawn, float maxTimerSpawn)
            : base(minTimerSpawn, maxTimerSpawn)
        {

        }     

        void addCactus(Vector2 position)
        {
            Scene.AddEntity((Entity)Scene.Factory.CreateCactus(Scene.ScreenToWorld(position)));
            UpdateSpawnTimer();
        }
            
        void addFall(Vector2 position)
        {
            Scene.AddEntity((Entity)Scene.Factory.CreateFall(Scene.ScreenToWorld(position)));
            UpdateSpawnTimer();
        }

        
        public override void RemoveObstacle(Entity e)
        {
            
        }
        public override void Update(float dt)
        {
            base.Update(dt);

            SpawnRandom(new Vector2(810, (float)r.NextDouble() * 600), 0.995f);

            if (m_timerSpawn < Timer && Timer > 18.0f)
            {
                if(r.NextDouble() > 0.4f)
                    addCactus(new Vector2(900, 50 + (float)r.NextDouble() * 500));
                else
                    addFall(new Vector2(900, 50 + (float)r.NextDouble() * 500));
            }
        }

    }
}
