using System;
using System.Collections.Generic;
using System.Text;
using Microsoft.Xna.Framework;

namespace TestBoids.Entities
{
    class Level5 : LevelSpawner
    {

        Zeppelin m_zep;
        PlaneEntity m_plane;
        bool m_team = false;
        bool m_aplane = false;
        bool m_azep = false;
        
        public Level5(float minTimerSpawn, float maxTimerSpawn)
            : base(minTimerSpawn, maxTimerSpawn)
        {

        }

        void addBird(Vector2 position)
        {
            BlockEntity b = Scene.Factory.CreateEvilBird(Scene.ScreenToWorld(position));
            b.MovementType = EntityMovementType.MT_Dynamic;

            m_zep = null;
            m_plane = null;
            Scene.AddEntity(b);
            UpdateSpawnTimer();
        }

        public override void RemoveObstacle(Entity e)
        {

        }
        public override void Update(float dt)
        {
            base.Update(dt);

            SpawnRandom(new Vector2(810, (float)r.NextDouble() * 600), 0.995f);

            if (m_timerSpawn < Timer && Timer > 18.0f)
            {
                addBird(new Vector2(900, 50 + (float)r.NextDouble() * 500));
            }
            if (Timer > 100.0f && !m_azep)
            {
                m_azep = true;
                m_zep = (Zeppelin)Scene.AddEntity(Scene.Factory.CreateBigBaloon(Scene.ScreenToWorld(new Vector2(1200, 140)), 2));
            }
            if(Timer > 250.0f && !m_aplane)
            {
                m_aplane = true;
                m_plane = (PlaneEntity)Scene.AddEntity(Scene.Factory.CreatePlane(Scene.ScreenToWorld(new Vector2(1200, 200))));
            }

            if (Timer > 350 && !m_team)
            {
                m_team = true;
                Scene.AddEntity(Scene.Factory.CreateTeam(Scene.ScreenToWorld(new Vector2(1200, 100)), 0));
                Scene.AddEntity(Scene.Factory.CreateTeam(Scene.ScreenToWorld(new Vector2(1250, 310)), 1));
                Scene.AddEntity(Scene.Factory.CreateTeam(Scene.ScreenToWorld(new Vector2(1150, 460)), 2));
                Scene.AddEntity(Scene.Factory.CreateTeam(Scene.ScreenToWorld(new Vector2(1320, 205)), 3));
                
            }
        }

    }
}
