using System;
using System.Collections.Generic;
using System.Text;
using Microsoft.Xna.Framework;
using TestBoids.Collisions;

namespace TestBoids.Entities
{
    public abstract class LevelSpawner : Entity
    {
        float m_timer;
        protected float m_minTimerSpawn, m_maxTimerSpawn, m_timerSpawn;
        public Random r;

        public float Timer
        {
            get { return m_timer; }
            set { m_timer = value; }
        }

        public void Reset()
        {
            m_timer = 0;
        }

        public LevelSpawner(float minTimerSpawn, float maxTimerSpawn)
            : base(new Vector2(), null, 0)
        {
            m_timer = 0;
            m_timerSpawn = 0;
            m_minTimerSpawn = minTimerSpawn;
            m_maxTimerSpawn = maxTimerSpawn;
            r = new Random();
        }

        protected virtual BackgroundEntity addCloud(Vector2 position, bool updateTimer)
        {            
            if(updateTimer) UpdateSpawnTimer();
            position = Scene.ScreenToWorld(position);
            return (BackgroundEntity)Scene.AddEntity(Scene.Factory.CreateCloud(position));
        }

        protected virtual EnergyEntity AddEnergyStream(Vector2 position, Vector2 size, Vector2 power)
        {
            position = Scene.ScreenToWorld(position);
            EnergyEntity stream = new EnergyEntity(position, null, power);
            /* ca marche, c'est la position qui tait pas bonne :p */
            stream.Collision = new BoxCollision(-0.5f * size, size, stream.Position);
            Scene.AddEntity(stream);

            return stream;
        }

        public void Spawn(Vector2 position)
        {
            float rand = (float)r.NextDouble();
            int t = r.Next(1, 4);
            for (int i = 0; i < t; i++)
            {
                Vector2 offset = 50 * new Vector2((float)r.NextDouble() - 0.5f, (float)r.NextDouble() - 0.5f);
                Boid b = Scene.Factory.CreateBoid(Scene.ScreenToWorld(offset + position));
                b.Leader = false;
                Scene.AddEntity(b);
            }
        }

        public void SpawnRandom(Vector2 position, float randLuck)
        {
            float rand = (float)r.NextDouble();
            if (rand > randLuck)
            {                
                int t = r.Next(1, 4);
                for (int i = 0; i < t; i++)
                {
                    Vector2 offset = 50 * new Vector2((float)r.NextDouble() - 0.5f, (float)r.NextDouble() - 0.5f);
                    Boid b = Scene.Factory.CreateBoid(Scene.ScreenToWorld(offset + position));
                    b.Leader = false;
                    Scene.AddEntity(b);
                }
            }
        }

        public void UpdateSpawnTimer()
        {
            m_timerSpawn = Timer + ((float)r.NextDouble() * (m_maxTimerSpawn - m_minTimerSpawn) + m_minTimerSpawn);
        }

        public abstract void RemoveObstacle(Entity e);

        public override void Update(float dt)
        {
            Position = Scene.ScreenToWorld(new Vector2());
            m_timer += dt;
        }
    }
}
